/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dmi;

import com.tc.util.Assert;

public class DmiClassSpec {
    private final String classLoaderDesc;
    private final String className;
    private final String spec;

    public DmiClassSpec(String classLoaderDesc, String className) {
        Assert.pre(classLoaderDesc != null);
        Assert.pre(className != null);
        this.classLoaderDesc = classLoaderDesc;
        this.className = className;
        this.spec = classLoaderDesc + "-" + className;
    }

    public String getClassLoaderDesc() {
        return this.classLoaderDesc;
    }

    public String getClassName() {
        return this.className;
    }

    public int hashCode() {
        return this.spec.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DmiClassSpec)) {
            return false;
        }
        DmiClassSpec that = (DmiClassSpec)obj;
        return this.spec.equals(that.spec);
    }

    public String toString() {
        return "DmiClassSpec{loader=" + this.classLoaderDesc + ", className=" + this.className + "}";
    }

    public static String toString(DmiClassSpec[] specs) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < specs.length; ++i) {
            sb.append(specs[i].toString()).append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

