/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.config.schema;

import com.tc.config.schema.BaseNewConfigObject;
import com.tc.config.schema.context.ConfigContext;
import com.tc.config.schema.dynamic.BooleanConfigItem;
import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.config.schema.DSORuntimeOutputOptions;
import com.terracottatech.config.DsoClientData;

public class StandardDSORuntimeOutputOptions
extends BaseNewConfigObject
implements DSORuntimeOutputOptions {
    private final BooleanConfigItem doAutoLockDetails;
    private final BooleanConfigItem doCaller;
    private final BooleanConfigItem doFullStack;
    private static final TCLogger consoleLogger = CustomerLogging.getConsoleLogger();
    private static final TCLogger logger = TCLogging.getLogger(StandardDSORuntimeOutputOptions.class);

    public StandardDSORuntimeOutputOptions(ConfigContext context) {
        super(context);
        this.context.ensureRepositoryProvides(DsoClientData.class);
        this.doAutoLockDetails = this.context.booleanItem("debugging/runtime-output-options/auto-lock-details");
        this.doCaller = this.context.booleanItem("debugging/runtime-output-options/caller");
        this.doFullStack = this.context.booleanItem("debugging/runtime-output-options/full-stack");
        if (this.doCaller.getBoolean()) {
            String msg = "<caller> element in <runtime-output-options> is deprecated. Please set the value of <caller> to false in your tc-config file to remove this warning.";
            consoleLogger.warn("<caller> element in <runtime-output-options> is deprecated. Please set the value of <caller> to false in your tc-config file to remove this warning.");
            logger.warn("<caller> element in <runtime-output-options> is deprecated. Please set the value of <caller> to false in your tc-config file to remove this warning.");
        }
    }

    public BooleanConfigItem doAutoLockDetails() {
        return this.doAutoLockDetails;
    }

    public BooleanConfigItem doCaller() {
        return this.doCaller;
    }

    public BooleanConfigItem doFullStack() {
        return this.doFullStack;
    }
}

