/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.config.schema;

import com.tc.util.Assert;

public class IncludeOnLoad {
    private static final int UNDEFINED = -1;
    public static final int METHOD = 0;
    public static final int CALL_CONSTRUCTOR = 1;
    public static final int EXECUTE = 2;
    private int type;
    private Object value;

    public IncludeOnLoad() {
        this(-1, null);
    }

    public IncludeOnLoad(int type, Object value) {
        this.type = type;
        this.value = value;
    }

    public boolean isCallConstructorOnLoadType() {
        return this.type == 1;
    }

    public boolean isExecuteScriptOnLoadType() {
        return this.type == 2;
    }

    public boolean isCallMethodOnLoadType() {
        return this.type == 0;
    }

    public boolean isCallConstructorOnLoad() {
        if (!this.isCallConstructorOnLoadType()) {
            return false;
        }
        return (Boolean)this.value;
    }

    public String getExecuteScript() {
        Assert.eval(this.isExecuteScriptOnLoadType());
        return (String)this.value;
    }

    public String getMethod() {
        Assert.eval(this.isCallMethodOnLoadType());
        return (String)this.value;
    }

    public void setToCallConstructorOnLoad(boolean b) {
        this.type = 1;
        this.value = b;
    }

    public void setExecuteScriptOnLoad(String script) {
        this.type = 2;
        this.value = script;
    }

    public void setMethodCallOnLoad(String method) {
        this.type = 0;
        this.value = method;
    }

    public int type() {
        return this.type;
    }

    public Object value() {
        return this.value;
    }

    public String toString() {
        return "type: " + this.type + " value=" + this.value;
    }
}

