/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.config.schema;

import com.tc.object.config.schema.AutoLock;
import com.tc.object.config.schema.ExcludedInstrumentedClass;
import com.tc.object.config.schema.IncludeOnLoad;
import com.tc.object.config.schema.IncludedInstrumentedClass;
import com.tc.object.config.schema.InstrumentedClass;
import com.tc.object.config.schema.Lock;
import com.tc.object.config.schema.LockLevel;
import com.tc.object.config.schema.NamedLock;
import com.tc.util.Assert;
import com.terracottatech.config.Autolock;
import com.terracottatech.config.ClassExpression;
import com.terracottatech.config.Include;
import com.terracottatech.config.Locks;
import com.terracottatech.config.OnLoad;
import org.apache.xmlbeans.XmlObject;

public class ConfigTranslationHelper {
    static Object translateIncludes(XmlObject xmlObject) {
        if (xmlObject == null) {
            return null;
        }
        XmlObject[] objects = xmlObject.selectPath("*");
        InstrumentedClass[] classes = new InstrumentedClass[objects.length];
        Assert.eval(classes.length == objects.length);
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] instanceof Include) {
                Include theInclude = (Include)objects[i];
                boolean honorVolatile = false;
                classes[i] = new IncludedInstrumentedClass(theInclude.getClassExpression(), theInclude.getHonorTransient(), honorVolatile, ConfigTranslationHelper.createOnLoadObj(theInclude.getOnLoad()));
                continue;
            }
            if (objects[i] instanceof ClassExpression) {
                ClassExpression theExpression = (ClassExpression)objects[i];
                classes[i] = new ExcludedInstrumentedClass(theExpression.getStringValue());
                continue;
            }
            throw Assert.failure("Child #" + i + " of the <instrumented-classes> element appears to be " + "neither an <include> nor an <exclude> element. This is a programming error in " + "Terracotta software.");
        }
        return classes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object translateLocks(XmlObject xmlObject) {
        LockLevel level;
        int i;
        if (xmlObject == null) {
            return null;
        }
        com.terracottatech.config.NamedLock[] namedLocks = ((Locks)xmlObject).getNamedLockArray();
        Autolock[] autoLocks = ((Locks)xmlObject).getAutolockArray();
        int namedLength = namedLocks == null ? 0 : namedLocks.length;
        int autoLength = autoLocks == null ? 0 : autoLocks.length;
        Lock[] out = new Lock[namedLength + autoLength];
        for (i = 0; i < namedLength; ++i) {
            if (namedLocks[i].getLockLevel() != null) {
                if (namedLocks[i].getLockLevel().equals(com.terracottatech.config.LockLevel.CONCURRENT)) {
                    level = LockLevel.CONCURRENT;
                } else if (namedLocks[i].getLockLevel().equals(com.terracottatech.config.LockLevel.READ)) {
                    level = LockLevel.READ;
                } else {
                    if (!namedLocks[i].getLockLevel().equals(com.terracottatech.config.LockLevel.WRITE)) throw Assert.failure("Unknown lock level " + namedLocks[i].getLockLevel());
                    level = LockLevel.WRITE;
                }
            } else {
                level = LockLevel.WRITE;
            }
            out[i] = new NamedLock(namedLocks[i].getLockName(), namedLocks[i].getMethodExpression(), level);
        }
        for (i = 0; i < autoLength; ++i) {
            if (autoLocks[i].getLockLevel() != null) {
                if (autoLocks[i].getLockLevel().equals(com.terracottatech.config.LockLevel.CONCURRENT)) {
                    level = LockLevel.CONCURRENT;
                } else if (autoLocks[i].getLockLevel().equals(com.terracottatech.config.LockLevel.READ)) {
                    level = LockLevel.READ;
                } else if (autoLocks[i].getLockLevel().equals(com.terracottatech.config.LockLevel.WRITE)) {
                    level = LockLevel.WRITE;
                } else {
                    if (!autoLocks[i].getLockLevel().equals(com.terracottatech.config.LockLevel.SYNCHRONOUS_WRITE)) throw Assert.failure("Unknown lock level " + namedLocks[i].getLockLevel());
                    level = LockLevel.SYNCHRONOUS_WRITE;
                }
            } else {
                level = LockLevel.WRITE;
            }
            out[namedLength + i] = new AutoLock(autoLocks[i].getMethodExpression(), level);
        }
        return out;
    }

    private static IncludeOnLoad createOnLoadObj(OnLoad xmlOnLoad) {
        if (xmlOnLoad == null) {
            return new IncludeOnLoad();
        }
        String value = xmlOnLoad.getExecute();
        if (value != null) {
            return new IncludeOnLoad(2, value);
        }
        value = xmlOnLoad.getMethod();
        if (value != null) {
            return new IncludeOnLoad(0, value);
        }
        return new IncludeOnLoad();
    }
}

