/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.config.schema;

import com.tc.object.config.schema.Lock;
import com.tc.object.config.schema.LockLevel;
import com.tc.util.Assert;
import com.tc.util.stringification.OurStringBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class AutoLock
implements Lock {
    private final String methodExpression;
    private final LockLevel lockLevel;

    public AutoLock(String methodExpression, LockLevel lockLevel) {
        Assert.assertNotBlank(methodExpression);
        Assert.assertNotNull(lockLevel);
        this.methodExpression = methodExpression;
        this.lockLevel = lockLevel;
    }

    public boolean isAutoLock() {
        return true;
    }

    public String lockName() {
        throw Assert.failure("Autolocks don't have names.");
    }

    public String methodExpression() {
        return this.methodExpression;
    }

    public LockLevel lockLevel() {
        return this.lockLevel;
    }

    public boolean equals(Object that) {
        if (!(that instanceof AutoLock)) {
            return false;
        }
        AutoLock thatLock = (AutoLock)that;
        return new EqualsBuilder().append((Object)this.methodExpression, (Object)thatLock.methodExpression).append((Object)this.lockLevel, (Object)thatLock.lockLevel).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.methodExpression).append((Object)this.lockLevel).toHashCode();
    }

    public String toString() {
        return new OurStringBuilder(this, (ToStringStyle)OurStringBuilder.COMPACT_STYLE).append("method expression", this.methodExpression).append("lock level", (Object)this.lockLevel).toString();
    }
}

