/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.config;

import com.tc.aspectwerkz.expression.ExpressionContext;
import com.tc.aspectwerkz.expression.ExpressionVisitor;
import com.tc.aspectwerkz.expression.PointcutType;
import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.reflect.FieldInfo;
import com.tc.aspectwerkz.reflect.ReflectionInfo;
import com.tc.object.bytecode.aspectwerkz.ExpressionHelper;

public class Root {
    private final String className;
    private final String fieldNameOrExpression;
    private final String rootName;
    private final DsoFinal dsoFinal;
    private final Type type;

    public Root(String rootExpr) {
        this(null, rootExpr, null, DsoFinal.NOT_SET, Type.FIELD_EXPR);
    }

    public Root(String rootExpr, String rootName) {
        this(null, rootExpr, rootName, DsoFinal.NOT_SET, Type.FIELD_EXPR);
    }

    public Root(String className, String fieldName, String rootName) {
        this(className, fieldName, rootName, DsoFinal.NOT_SET, Type.FIELD_NAME);
    }

    public Root(String className, String fieldName, String rootName, boolean dsoFinal) {
        this(className, fieldName, rootName, dsoFinal ? DsoFinal.TRUE : DsoFinal.FALSE, Type.FIELD_NAME);
    }

    private Root(String className, String fieldName, String rootName, DsoFinal dsoFinal, Type type) {
        this.className = className;
        this.fieldNameOrExpression = fieldName;
        this.rootName = rootName;
        this.dsoFinal = dsoFinal;
        this.type = type;
    }

    public boolean isExpression() {
        return this.type == Type.FIELD_EXPR;
    }

    public String getClassName() {
        if (this.type != Type.FIELD_NAME) {
            throw new IllegalStateException();
        }
        return this.className;
    }

    public String getFieldName() {
        if (this.type != Type.FIELD_NAME) {
            throw new IllegalStateException();
        }
        return this.fieldNameOrExpression;
    }

    public String getFieldExpression() {
        if (this.type != Type.FIELD_EXPR) {
            throw new IllegalStateException();
        }
        return this.fieldNameOrExpression;
    }

    public String getRootName(FieldInfo fieldInfo) {
        return this.rootName == null ? fieldInfo.getDeclaringType().getName() + "." + fieldInfo.getName() : this.rootName;
    }

    public boolean isDsoFinal(boolean isPrimitive) {
        if (this.dsoFinal != DsoFinal.NOT_SET) {
            return this.dsoFinal == DsoFinal.TRUE;
        }
        return !isPrimitive;
    }

    private boolean isDsoFinal() {
        return this.dsoFinal == DsoFinal.TRUE;
    }

    public boolean matches(ClassInfo ci, ExpressionHelper expressionHelper) {
        if (this.type == Type.FIELD_EXPR) {
            ExpressionContext ctxt = expressionHelper.createWithinExpressionContext(ci);
            ExpressionVisitor visitor = expressionHelper.createExpressionVisitor(this.fieldNameOrExpression);
            return visitor.match(ctxt);
        }
        if (this.type == Type.FIELD_NAME) {
            return ci.getName().equals(this.className);
        }
        throw new AssertionError();
    }

    public boolean matches(FieldInfo fi, ExpressionHelper expressionHelper) {
        if (this.type == Type.FIELD_EXPR) {
            ExpressionVisitor visitor = expressionHelper.createExpressionVisitor("get(" + this.fieldNameOrExpression + ")");
            return visitor.match(new ExpressionContext(PointcutType.GET, (ReflectionInfo)fi, (ReflectionInfo)fi));
        }
        if (this.type == Type.FIELD_NAME) {
            return fi.getDeclaringType().getName().equals(this.className) && fi.getName().equals(this.fieldNameOrExpression);
        }
        throw new AssertionError();
    }

    public String toString() {
        return this.getClass().getName() + "[className=" + this.className + ", fieldNameOrExpression=" + this.fieldNameOrExpression + ", rootName=" + this.rootName + ", dsoFinal=" + this.isDsoFinal() + "]";
    }

    private static class DsoFinal {
        private final String s;
        static final DsoFinal NOT_SET = new DsoFinal("not set");
        static final DsoFinal TRUE = new DsoFinal("true");
        static final DsoFinal FALSE = new DsoFinal("false");

        public DsoFinal(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }

    private static class Type {
        static final Type FIELD_NAME = new Type();
        static final Type FIELD_EXPR = new Type();

        private Type() {
        }
    }
}

