/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.config;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.config.DSOApplicationConfig;
import com.tc.object.config.DSOClientConfigHelper;
import com.tc.object.config.Visitable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConfigVisitor {
    private final Map visited = new HashMap();
    private final TCLogger logger = TCLogging.getLogger(this.getClass());
    public static final String VISIT_METHOD_NAME = "visitL1DSOConfig";
    public static final String VISIT_INSTANCE_METHOD_NAME = "instanceVisitL1DSOConfig";
    public static final Class[] VISIT_METHOD_PARAMETERS = new Class[]{ConfigVisitor.class, DSOClientConfigHelper.class};
    public static final Class[] VISIT_METHOD_PARAMETERS_WITH_ATTRIBUTES = new Class[]{ConfigVisitor.class, DSOClientConfigHelper.class, Map.class};
    public static final String VISIT_DSO_APPLICATION_CONFIG_METHOD_NAME = "visitDSOApplicationConfig";
    public static final Class[] VISIT_DSO_APPLICATION_CONFIG_METHOD_PARAMETERS = new Class[]{ConfigVisitor.class, DSOApplicationConfig.class};

    public void visitDSOApplicationConfig(DSOApplicationConfig config, Class clazz) {
        if (this.checkAndSetVisited((Object)config, clazz)) {
            return;
        }
        this.doVisit(clazz, VISIT_DSO_APPLICATION_CONFIG_METHOD_NAME, VISIT_DSO_APPLICATION_CONFIG_METHOD_PARAMETERS, new Object[]{this, config});
    }

    public void visit(DSOClientConfigHelper config, Visitable v) {
        if (this.checkAndSetVisited((Object)config, v)) {
            return;
        }
        v.visit(this, config);
    }

    public void visit(DSOClientConfigHelper config, Class clazz) {
        if (this.checkAndSetVisited((Object)config, clazz)) {
            return;
        }
        Object[] args = new Object[]{this, config};
        if (!this.doInstanceVisit(clazz, VISIT_INSTANCE_METHOD_NAME, VISIT_METHOD_PARAMETERS, args)) {
            this.doVisit(clazz, VISIT_METHOD_NAME, VISIT_METHOD_PARAMETERS, new Object[]{this, config});
        }
    }

    public void visit(DSOClientConfigHelper config, Class clazz, Map optionalAttributes) {
        if (this.checkAndSetVisited((Object)config, clazz)) {
            return;
        }
        Object[] args = new Object[]{this, config};
        if (!this.doInstanceVisit(clazz, VISIT_INSTANCE_METHOD_NAME, VISIT_METHOD_PARAMETERS, args)) {
            this.doVisit(clazz, VISIT_METHOD_NAME, VISIT_METHOD_PARAMETERS_WITH_ATTRIBUTES, new Object[]{this, config, optionalAttributes});
        }
    }

    private boolean doInstanceVisit(Class clazz, String methodName, Class[] parameters, Object[] arguments) {
        boolean result = false;
        try {
            Method visitMethod = clazz.getMethod(VISIT_INSTANCE_METHOD_NAME, parameters);
            System.out.println("instance configuration method found");
            Constructor construct = clazz.getConstructor(new Class[0]);
            Object instance = construct.newInstance(new Object[0]);
            visitMethod.setAccessible(true);
            visitMethod.invoke(instance, arguments);
            result = true;
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private void doVisit(Class clazz, String methodName, Class[] parameters, Object[] arguments) {
        while (clazz != null) {
            try {
                Method visitMethod = clazz.getMethod(methodName, parameters);
                if (!Modifier.isStatic(visitMethod.getModifiers())) continue;
                visitMethod.setAccessible(true);
                this.logger.info("Visiting: " + clazz.getName());
                visitMethod.invoke(null, arguments);
            }
            catch (NoSuchMethodException e) {
                if (Object.class.getName().equals(clazz.getName())) continue;
                StringBuffer paramString = new StringBuffer();
                for (int i = 0; i < parameters.length; ++i) {
                    if (i > 0) {
                        paramString.append(",");
                    }
                    paramString.append(parameters[i].getName());
                }
                this.logger.info("Visit method not defined: " + clazz.getName() + "." + methodName + "(" + paramString + ")");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                clazz = clazz.getSuperclass();
            }
        }
    }

    private boolean checkAndSetVisited(Object config, Class clazz) {
        return this.checkAndSetVisited(config, clazz.getName());
    }

    private boolean checkAndSetVisited(Object config, Visitable v) {
        return this.checkAndSetVisited(config, v.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndSetVisited(Object config, Object key) {
        Set set;
        Object object = this.visited;
        synchronized (object) {
            set = this.getOrCreateVisitedFor(key);
        }
        object = set;
        synchronized (object) {
            boolean rv;
            boolean bl = rv = !set.add(config);
            if (rv) {
                this.logger.warn("Already visited: " + key);
            }
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getOrCreateVisitedFor(Object key) {
        Map map = this.visited;
        synchronized (map) {
            HashSet set = (HashSet)this.visited.get(key);
            if (set == null) {
                set = new HashSet();
                this.visited.put(key, set);
            }
            return set;
        }
    }
}

