/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode.hook.impl;

import com.tc.net.NIOWorkarounds;
import com.tc.object.bytecode.Manager;
import com.tc.object.bytecode.ManagerUtil;
import com.tc.object.bytecode.hook.ClassPostProcessor;
import com.tc.object.bytecode.hook.ClassPreProcessor;
import com.tc.object.bytecode.hook.DSOContext;
import com.tc.object.bytecode.hook.impl.Util;
import com.tc.object.loaders.NamedClassLoader;
import com.tc.text.Banner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.LogManager;
import sun.misc.Launcher;

public class ClassProcessorHelper {
    public static final String ROOT_WEB_APP_NAME = "ROOT";
    private static final String TC_INSTALL_ROOT_SYSPROP = "tc.install-root";
    private static final String TC_ACTIVE_SYSPROP = "tc.active";
    private static final String TC_CLASSPATH_SYSPROP = "tc.classpath";
    private static final String TC_DSO_GLOBALMODE_SYSPROP = "tc.dso.globalmode";
    private static final String CLASS_SUFFIX = ".class";
    private static final int CLASS_SUFFIX_LENGTH = ".class".length();
    private static final boolean GLOBAL_MODE_DEFAULT = true;
    public static final boolean USE_GLOBAL_CONTEXT;
    private static final State initState;
    private static final String tcInstallRootSysProp;
    private static final Map contextMap;
    private static URLClassLoader tcLoader;
    private static DSOContext globalContext;
    private static final boolean TRACE;
    private static final PrintStream TRACE_STREAM;
    private static volatile boolean systemLoaderInitialized;

    private static URLClassLoader createTCLoader() throws Exception {
        return new URLClassLoader(ClassProcessorHelper.buildTerracottaClassPath(), null);
    }

    public static URL getTCResource(String name, ClassLoader cl) {
        String className = null;
        if (name.endsWith(CLASS_SUFFIX)) {
            className = name.substring(0, name.length() - CLASS_SUFFIX_LENGTH).replace('/', '.');
        }
        URL resource = ClassProcessorHelper.getClassResource(className, cl, false);
        return resource;
    }

    public static byte[] loadClassInternalHook(String name, ClassLoader cl) throws ClassNotFoundException {
        URL resource = ClassProcessorHelper.getClassResource(name, cl, true);
        if (null == resource) {
            return null;
        }
        return ClassProcessorHelper.getResourceBytes(resource);
    }

    public static byte[] systemLoaderFindClassHook(String name, ClassLoader loader) throws ClassNotFoundException {
        URL resource = ClassProcessorHelper.getClassResource(name, loader, false);
        if (resource == null) {
            return null;
        }
        return ClassProcessorHelper.getResourceBytes(resource);
    }

    private static byte[] getResourceBytes(URL url) throws ClassNotFoundException {
        byte[] byArray;
        InputStream is = null;
        try {
            byte[] c;
            int n;
            is = url.openStream();
            byte[] b = new byte[is.available()];
            int len = 0;
            while ((n = is.read(b, len, b.length - len)) > 0) {
                if ((len += n) >= b.length) continue;
                c = new byte[b.length + 1000];
                System.arraycopy(b, 0, c, 0, len);
                b = c;
            }
            if (len == b.length) {
                c = b;
                return c;
            }
            c = new byte[len];
            System.arraycopy(b, 0, c, 0, len);
            byArray = c;
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Unable to load " + url.toString() + "; " + e.toString(), e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ex) {}
        }
        return byArray;
    }

    private static URL getClassResource(String name, ClassLoader cl, boolean hideSystemResources) {
        DSOContext context;
        if (name != null && (context = ClassProcessorHelper.getContext(cl)) != null) {
            return context.getClassResource(name, cl, hideSystemResources);
        }
        return null;
    }

    private static void handleError(Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    static File getTCInstallDir(boolean systemClassPathAllowed) {
        File tcInstallDir;
        if (tcInstallRootSysProp == null) {
            if (systemClassPathAllowed) {
                try {
                    ClassLoader.getSystemClassLoader().loadClass("com.tc.object.NotInBootJar");
                    return null;
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
            Banner.errorBanner("Terracotta home directory is not set. Please set it with -Dtc.install-root=<path-to-Terracotta-install>");
            Util.exit();
        }
        if (!((tcInstallDir = new File(tcInstallRootSysProp)).exists() && tcInstallDir.isDirectory() && tcInstallDir.canRead())) {
            Banner.errorBanner("Terracotta install directory [" + tcInstallDir.getAbsolutePath() + "] is not accessible. This value is set via system property " + TC_INSTALL_ROOT_SYSPROP);
            Util.exit();
        }
        return tcInstallDir;
    }

    private static URL[] buildTerracottaClassPath() throws Exception {
        File[] entries;
        if (System.getProperty(TC_CLASSPATH_SYSPROP) != null) {
            return ClassProcessorHelper.buildDevClassPath();
        }
        File tcHomeDir = ClassProcessorHelper.getTCInstallDir(true);
        if (tcHomeDir == null) {
            ClassLoader classPathLoader = Launcher.getLauncher().getClassLoader();
            URL[] systemURLS = ((URLClassLoader)classPathLoader).getURLs();
            return (URL[])systemURLS.clone();
        }
        File tcLib = new File(tcHomeDir, "lib");
        if (!(tcLib.exists() && tcLib.isDirectory() && tcLib.canRead())) {
            Banner.errorBanner("Terracotta lib directory [" + tcLib.getAbsolutePath() + "] is not accessible. This value is based off of the system property " + TC_INSTALL_ROOT_SYSPROP);
            Util.exit();
        }
        if ((entries = tcLib.listFiles(new TcCommonLibQualifier())).length == 0) {
            Banner.errorBanner("Absolutely no .jar files or resources directory found in Terracotta common lib directory [" + tcLib.getAbsolutePath() + "]. Please check the value of your " + TC_INSTALL_ROOT_SYSPROP + " system property");
            Util.exit();
        }
        URL[] rv = new URL[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i].getCanonicalPath().replace(File.separatorChar, '/');
            if (entries[i].isDirectory()) {
                entry = entry + "/";
            }
            rv[i] = new URL("file", "", entry);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String slurpFile(String path) throws IOException {
        URL url = new URL(path);
        InputStream in = url.openStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf, 0, buf.length)) >= 0) {
                bos.write(buf, 0, len);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {}
            try {
                bos.close();
            }
            catch (IOException ioe) {}
        }
        return new String(bos.toByteArray());
    }

    private static URL[] buildDevClassPath() throws MalformedURLException, IOException {
        String tcClasspath = System.getProperty(TC_CLASSPATH_SYSPROP);
        if (tcClasspath.startsWith("file:/")) {
            tcClasspath = ClassProcessorHelper.slurpFile(tcClasspath);
        }
        String[] parts = tcClasspath.split(File.pathSeparator);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String part : parts) {
            if (part.length() <= 0) continue;
            File file = new File(part);
            if (!(part = file.getAbsolutePath().replace(File.separatorChar, '/')).startsWith("/")) {
                part = "/" + part;
            }
            if (file.isDirectory() && !part.endsWith("/")) {
                part = part + "/";
            }
            urls.add(new URL("file", "", part));
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static Method getContextMethod(String name, Class[] args) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> c = tcLoader.loadClass("com.tc.object.bytecode.hook.impl.DSOContextImpl");
        return c.getDeclaredMethod(name, args);
    }

    public static void initialize() {
        if (initState.attemptInit()) {
            try {
                tcLoader = ClassProcessorHelper.createTCLoader();
                ClassProcessorHelper.initTCLogging();
                if (USE_GLOBAL_CONTEXT) {
                    globalContext = ClassProcessorHelper.createGlobalContext();
                }
                initState.initialized();
                System.setProperty(TC_ACTIVE_SYSPROP, Boolean.TRUE.toString());
            }
            catch (Throwable t) {
                t.printStackTrace();
                ClassProcessorHelper.handleError(t);
                throw new AssertionError();
            }
        }
    }

    private static void initTCLogging() throws Exception {
        Class<?> loggerClass = tcLoader.loadClass("com.tc.logging.Log4jSafeInit");
        Method theMethod = loggerClass.getMethod("init", new Class[0]);
        theMethod.invoke(null, (Object[])null);
    }

    @Deprecated
    public static void registerGlobalLoader(NamedClassLoader loader) {
        ClassProcessorHelper.registerGlobalLoader(loader, null);
    }

    public static void registerGlobalLoader(NamedClassLoader loader, String webAppName) {
        if (!USE_GLOBAL_CONTEXT) {
            throw new IllegalStateException("Not global DSO mode");
        }
        if (TRACE) {
            ClassProcessorHelper.traceNamedLoader(loader);
        }
        ManagerUtil.registerNamedLoader(loader, webAppName);
    }

    public static void shutdown() {
        if (!USE_GLOBAL_CONTEXT) {
            throw new IllegalStateException("Not global DSO mode");
        }
        try {
            if (globalContext != null) {
                globalContext.getManager().stop();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static String computeAppName(String context) {
        if (context == null) {
            return ROOT_WEB_APP_NAME;
        }
        if ((context = context.trim()).startsWith("/")) {
            context = context.substring(1);
        }
        if (context.endsWith("/")) {
            context = context.substring(0, context.length() - 2);
        }
        if (context.length() == 0) {
            return ROOT_WEB_APP_NAME;
        }
        return context;
    }

    public static boolean isDSOSessions(String appName) {
        appName = "/".equals(appName) ? ROOT_WEB_APP_NAME : appName;
        try {
            Method m = ClassProcessorHelper.getContextMethod("isDSOSessions", new Class[]{String.class});
            boolean rv = (Boolean)m.invoke(null, appName);
            return rv;
        }
        catch (Throwable t) {
            ClassProcessorHelper.handleError(t);
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContext(ClassLoader loader, DSOContext context) {
        if (USE_GLOBAL_CONTEXT) {
            throw new IllegalStateException("DSO Context is global in this VM");
        }
        if (loader == null || context == null) {
            throw new IllegalArgumentException("Loader and/or context may not be null");
        }
        Map map = contextMap;
        synchronized (map) {
            contextMap.put(loader, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manager getManager(ClassLoader caller) {
        DSOContext context;
        if (USE_GLOBAL_CONTEXT) {
            return globalContext.getManager();
        }
        Map map = contextMap;
        synchronized (map) {
            context = (DSOContext)contextMap.get(caller);
        }
        if (context == null) {
            return null;
        }
        return context.getManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSOContext getContext(ClassLoader cl) {
        if (USE_GLOBAL_CONTEXT) {
            return globalContext;
        }
        Map map = contextMap;
        synchronized (map) {
            return (DSOContext)contextMap.get(cl);
        }
    }

    private static DSOContext createGlobalContext() {
        try {
            Method m = ClassProcessorHelper.getContextMethod("createGlobalContext", new Class[0]);
            DSOContext context = (DSOContext)m.invoke(null, new Object[0]);
            context.getManager().init();
            return context;
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
            throw new AssertionError();
        }
    }

    public static byte[] defineClass0Pre(ClassLoader caller, String name, byte[] b, int off, int len, ProtectionDomain pd) {
        if (ClassProcessorHelper.skipClass(caller)) {
            return b;
        }
        String string = name = name != null ? name.replace('/', '.') : null;
        if (TRACE) {
            ClassProcessorHelper.traceLookup(caller, name);
        }
        if (ClassProcessorHelper.isAWDependency(name)) {
            return b;
        }
        ClassProcessorHelper.initialize();
        if (!initState.isInitialized()) {
            return b;
        }
        ManagerUtil.enable();
        ClassPreProcessor preProcessor = ClassProcessorHelper.getPreProcessor(caller);
        if (preProcessor == null) {
            return b;
        }
        return preProcessor.preProcess(name, b, off, len, caller);
    }

    private static boolean skipClass(ClassLoader caller) {
        return caller == tcLoader;
    }

    public static void defineClass0Post(Class clazz, ClassLoader caller) {
        ClassPostProcessor postProcessor = ClassProcessorHelper.getPostProcessor(caller);
        if (!initState.isInitialized()) {
            return;
        }
        if (ClassProcessorHelper.skipClass(caller)) {
            return;
        }
        if (postProcessor == null) {
            return;
        }
        postProcessor.postProcess(clazz, caller);
    }

    public static Manager getGlobalManager() {
        return globalContext.getManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassPreProcessor getPreProcessor(ClassLoader caller) {
        if (USE_GLOBAL_CONTEXT) {
            return globalContext;
        }
        Map map = contextMap;
        synchronized (map) {
            return (ClassPreProcessor)contextMap.get(caller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassPostProcessor getPostProcessor(ClassLoader caller) {
        if (USE_GLOBAL_CONTEXT) {
            return globalContext;
        }
        Map map = contextMap;
        synchronized (map) {
            return (ClassPostProcessor)contextMap.get(caller);
        }
    }

    public static boolean isAWDependency(String className) {
        return className == null || className.endsWith("_AWFactory") || className.endsWith("___AW_JoinPoint") || className.startsWith("com.tc.aspectwerkz.") || className.startsWith("com.tc.asm.") || className.startsWith("com.tc.backport175.") || className.startsWith("com.tc.jrexx.") || className.startsWith("org.dom4j.") || className.startsWith("org.xml.sax.") || className.startsWith("javax.xml.parsers.") || className.startsWith("sun.reflect.Generated");
    }

    public static int getSessionLockType(String appName) {
        return globalContext.getSessionLockType(appName);
    }

    public static boolean isApplicationSessionLocked(String appName) {
        return globalContext.isApplicationSessionLocked(appName);
    }

    private static void traceNamedLoader(NamedClassLoader ncl) {
        ClassProcessorHelper.trace("loader[" + ncl + "] of type[" + ncl.getClass().getName() + "] registered as[" + ncl.__tc_getClassLoaderName() + "]");
    }

    private static void traceLookup(ClassLoader cl, String clazz) {
        ClassProcessorHelper.trace("loader[" + cl + "] of type[" + cl.getClass().getName() + "] looking for class[" + clazz + "]");
    }

    private static void trace(String msg) {
        TRACE_STREAM.println("<TRACE> TC classloading: " + msg);
        TRACE_STREAM.flush();
    }

    public static void systemLoaderInitialized() {
        Security.getProviders();
        LogManager.getLogManager();
        NIOWorkarounds.solaris10Workaround();
        systemLoaderInitialized = true;
    }

    static {
        initState = new State();
        tcInstallRootSysProp = System.getProperty(TC_INSTALL_ROOT_SYSPROP);
        contextMap = new WeakHashMap();
        systemLoaderInitialized = false;
        try {
            Class.forName(DSOContext.class.getName());
            String global = System.getProperty(TC_DSO_GLOBALMODE_SYSPROP, null);
            USE_GLOBAL_CONTEXT = global != null ? Boolean.valueOf(global) : true;
            String traceOutput = System.getProperty("l1.classloader.trace.output", "none");
            PrintStream ts = null;
            if (traceOutput != null) {
                if ("stdout".equals(traceOutput)) {
                    ts = System.out;
                } else if ("stderr".equals(traceOutput)) {
                    ts = System.err;
                }
            }
            TRACE = (TRACE_STREAM = ts) != null;
        }
        catch (Throwable t) {
            Util.exit(t);
            throw new AssertionError();
        }
    }

    public static final class State {
        private static final int NOT_INITIALIZED = 0;
        private static final int INITIALIZING = 1;
        private static final int INITIALIZED = 2;
        private int state = 0;

        final synchronized boolean attemptInit() {
            if (this.state == 0 && systemLoaderInitialized && !State.creatingPlatformMBeanServer()) {
                this.state = 1;
                return true;
            }
            return false;
        }

        private static boolean creatingPlatformMBeanServer() {
            StackTraceElement[] stack;
            for (StackTraceElement frame : stack = new Throwable().getStackTrace()) {
                if (!frame.getClassName().equals("java.lang.management.ManagementFactory") || !frame.getMethodName().equals("getPlatformMBeanServer")) continue;
                return true;
            }
            return false;
        }

        final synchronized void initialized() {
            if (this.state != 1) {
                throw new IllegalStateException("State was " + this.state);
            }
            this.state = 2;
        }

        final synchronized boolean isInitialized() {
            return this.state == 2;
        }
    }

    public static class TcCommonLibQualifier
    implements FileFilter {
        public boolean accept(File pathname) {
            return pathname.isDirectory() && pathname.getName().equals("resources") || pathname.isFile() && pathname.getAbsolutePath().toLowerCase().endsWith(".jar");
        }
    }
}

