/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode.hook;

import com.tc.asm.ClassAdapter;
import com.tc.asm.ClassReader;
import com.tc.asm.ClassVisitor;
import com.tc.asm.ClassWriter;
import com.tc.asm.Label;
import com.tc.asm.MethodAdapter;
import com.tc.asm.MethodVisitor;
import com.tc.asm.Opcodes;
import com.tc.asm.Type;
import com.tc.object.bytecode.hook.impl.ClassProcessorHelper;
import com.tc.util.runtime.Vm;
import java.util.HashMap;
import java.util.Map;

public class ClassLoaderPreProcessorImpl {
    private static final String CLASSLOADER_CLASS_NAME = "java/lang/ClassLoader";
    private static final String DEFINECLASS0_METHOD_NAME = "defineClass0";
    private static final String DEFINECLASS1_METHOD_NAME = "defineClass1";
    private static final String DEFINECLASS2_METHOD_NAME = "defineClass2";
    private static final String DESC_CORE = "Ljava/lang/String;[BIILjava/security/ProtectionDomain;";
    private static final String DESC_PREFIX = "(Ljava/lang/String;[BIILjava/security/ProtectionDomain;";
    private static final String DESC_HELPER = "(Ljava/lang/ClassLoader;Ljava/lang/String;[BIILjava/security/ProtectionDomain;)[B";
    private static final String DESC_BYTEBUFFER_CORE = "Ljava/lang/String;Ljava/nio/ByteBuffer;IILjava/security/ProtectionDomain;";
    private static final String DESC_BYTEBUFFER_PREFIX = "(Ljava/lang/String;Ljava/nio/ByteBuffer;IILjava/security/ProtectionDomain;";
    private static final String DESC_BYTEBUFFER_HELPER = "(Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/nio/ByteBuffer;IILjava/security/ProtectionDomain;)Ljava/nio/ByteBuffer;";

    public byte[] preProcess(byte[] classLoaderBytecode) {
        try {
            ClassReader cr = new ClassReader(classLoaderBytecode);
            ClassWriter cw = new ClassWriter(cr, 1);
            ClassAdapter cv = Vm.isIBM() ? new IBMClassLoaderAdapter(cw) : new ClassLoaderVisitor(cw);
            cr.accept(cv, 4);
            return cw.toByteArray();
        }
        catch (Exception e) {
            System.err.println("failed to patch ClassLoader:");
            e.printStackTrace();
            return classLoaderBytecode;
        }
    }

    void food(Class c, ClassLoader cl) {
        ClassProcessorHelper.defineClass0Post(c, cl);
    }

    private static class IntRef {
        int key;

        private IntRef() {
        }

        public boolean equals(Object o) {
            return this.key == ((IntRef)o).key;
        }

        public int hashCode() {
            return this.key;
        }
    }

    private static class State {
        Map locals = new HashMap();
        int firstLocal;
        int nextLocal;

        State(int access, Type[] args) {
            this.nextLocal = (8 & access) != 0 ? 0 : 1;
            for (int i = 0; i < args.length; ++i) {
                this.nextLocal += args[i].getSize();
            }
            this.firstLocal = this.nextLocal;
        }
    }

    private static class RemappingMethodVisitor
    extends MethodAdapter {
        private State state;
        private IntRef check = new IntRef();

        public RemappingMethodVisitor(MethodVisitor v, int access, String desc) {
            super(v);
            this.state = new State(access, Type.getArgumentTypes(desc));
        }

        public RemappingMethodVisitor(RemappingMethodVisitor wrap) {
            super(wrap.mv);
            this.state = wrap.state;
        }

        protected int nextLocal(int size) {
            int var = this.state.nextLocal;
            this.state.nextLocal += size;
            return var;
        }

        private int remap(int var, int size) {
            if (var < this.state.firstLocal) {
                return var;
            }
            this.check.key = size == 2 ? ~var : var;
            Integer value = (Integer)this.state.locals.get(this.check);
            if (value == null) {
                IntRef ref = new IntRef();
                ref.key = this.check.key;
                value = new Integer(this.nextLocal(size));
                this.state.locals.put(ref, value);
            }
            return value;
        }

        public void visitIincInsn(int var, int increment) {
            this.mv.visitIincInsn(this.remap(var, 1), increment);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            this.mv.visitLocalVariable(name, desc, signature, start, end, this.remap(index, 0));
        }

        public void visitVarInsn(int opcode, int var) {
            int size;
            switch (opcode) {
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    size = 2;
                    break;
                }
                default: {
                    size = 1;
                }
            }
            this.mv.visitVarInsn(opcode, this.remap(var, size));
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            this.mv.visitMaxs(0, 0);
        }
    }

    private static class ProcessingVisitor
    extends RemappingMethodVisitor {
        public ProcessingVisitor(MethodVisitor cv, int access, String desc) {
            super(cv, access, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            boolean insertPostCall = false;
            if ((ClassLoaderPreProcessorImpl.DEFINECLASS0_METHOD_NAME.equals(name) || ClassLoaderPreProcessorImpl.DEFINECLASS1_METHOD_NAME.equals(name)) && ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME.equals(owner)) {
                insertPostCall = true;
                this.wrapCallToDefineClass01(opcode, owner, name, desc);
            } else if (ClassLoaderPreProcessorImpl.DEFINECLASS2_METHOD_NAME.equals(name) && ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME.equals(owner)) {
                insertPostCall = true;
                this.wrapCallToDefineClass2(opcode, owner, name, desc);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc);
            }
            if (insertPostCall) {
                super.visitInsn(89);
                super.visitVarInsn(25, 0);
                super.visitMethodInsn(184, "com/tc/object/bytecode/hook/impl/ClassProcessorHelper", "defineClass0Post", "(Ljava/lang/Class;Ljava/lang/ClassLoader;)V");
            }
        }

        private void wrapCallToDefineClass01(int opcode, String owner, String name, String desc) throws Error {
            int i;
            Type[] args = Type.getArgumentTypes(desc);
            if (args.length < 5 || !desc.startsWith(ClassLoaderPreProcessorImpl.DESC_PREFIX)) {
                throw new Error("non supported JDK, native call not supported: " + desc);
            }
            int[] locals = new int[args.length];
            for (i = args.length - 1; i >= 0; --i) {
                locals[i] = this.nextLocal(args[i].getSize());
                this.mv.visitVarInsn(args[i].getOpcode(54), locals[i]);
            }
            for (i = 0; i < 5; ++i) {
                this.mv.visitVarInsn(args[i].getOpcode(21), locals[i]);
            }
            super.visitMethodInsn(184, "com/tc/object/bytecode/hook/impl/ClassProcessorHelper", "defineClass0Pre", ClassLoaderPreProcessorImpl.DESC_HELPER);
            int returnLocalByteArray = this.nextLocal(args[1].getSize());
            this.mv.visitVarInsn(58, returnLocalByteArray);
            this.mv.visitVarInsn(25, locals[1]);
            this.mv.visitVarInsn(25, returnLocalByteArray);
            Label l1 = new Label();
            this.mv.visitJumpInsn(165, l1);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, locals[0]);
            this.mv.visitVarInsn(25, returnLocalByteArray);
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(25, returnLocalByteArray);
            this.mv.visitInsn(190);
            this.mv.visitVarInsn(25, locals[4]);
            for (int i2 = 5; i2 < args.length; ++i2) {
                this.mv.visitVarInsn(args[i2].getOpcode(21), locals[i2]);
            }
            super.visitMethodInsn(opcode, owner, name, desc);
            Label l2 = new Label();
            this.mv.visitJumpInsn(167, l2);
            this.mv.visitLabel(l1);
            this.mv.visitVarInsn(25, 0);
            for (int i3 = 0; i3 < args.length; ++i3) {
                this.mv.visitVarInsn(args[i3].getOpcode(21), locals[i3]);
            }
            super.visitMethodInsn(opcode, owner, name, desc);
            this.mv.visitLabel(l2);
        }

        private void wrapCallToDefineClass2(int opcode, String owner, String name, String desc) throws Error {
            int i;
            Type[] args = Type.getArgumentTypes(desc);
            if (args.length < 5 || !desc.startsWith(ClassLoaderPreProcessorImpl.DESC_BYTEBUFFER_PREFIX)) {
                throw new Error("non supported JDK, bytebuffer native call not supported: " + desc);
            }
            int[] locals = new int[args.length];
            for (i = args.length - 1; i >= 0; --i) {
                locals[i] = this.nextLocal(args[i].getSize());
                this.mv.visitVarInsn(args[i].getOpcode(54), locals[i]);
            }
            for (i = 0; i < 5; ++i) {
                this.mv.visitVarInsn(args[i].getOpcode(21), locals[i]);
            }
            super.visitMethodInsn(184, "com/tc/object/bytecode/hook/impl/ClassProcessorHelperJDK15", "defineClass0Pre", ClassLoaderPreProcessorImpl.DESC_BYTEBUFFER_HELPER);
            this.mv.visitVarInsn(58, locals[1]);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, locals[0]);
            this.mv.visitVarInsn(25, locals[1]);
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(25, locals[1]);
            this.mv.visitMethodInsn(182, "java/nio/ByteBuffer", "remaining", "()I");
            this.mv.visitVarInsn(25, locals[4]);
            for (i = 5; i < args.length; ++i) {
                this.mv.visitVarInsn(args[i].getOpcode(21), locals[i]);
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    public static class LoadClassVisitor
    extends MethodAdapter
    implements Opcodes {
        private boolean isInstrumented = false;

        public LoadClassVisitor(MethodVisitor mv) {
            super(mv);
        }

        public void visitLineNumber(int line, Label start) {
            super.visitLineNumber(line, start);
            if (!this.isInstrumented) {
                this.instrument();
            }
        }

        public void visitVarInsn(int opcode, int var) {
            if (!this.isInstrumented) {
                this.instrument();
            }
            super.visitVarInsn(opcode, var);
        }

        private void instrument() {
            Label l = new Label();
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, "com/tc/object/bytecode/hook/impl/ClassProcessorHelper", "loadClassInternalHook", "(Ljava/lang/String;Ljava/lang/ClassLoader;)[B");
            this.mv.visitVarInsn(58, 2);
            this.mv.visitVarInsn(25, 2);
            this.mv.visitJumpInsn(198, l);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(25, 2);
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(25, 2);
            this.mv.visitInsn(190);
            this.mv.visitMethodInsn(182, ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME, "defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
            this.mv.visitInsn(176);
            this.mv.visitLabel(l);
            this.isInstrumented = true;
        }
    }

    public static class GetResourceVisitor
    extends MethodAdapter
    implements Opcodes {
        private boolean isInstrumented = false;

        public GetResourceVisitor(MethodVisitor mv) {
            super(mv);
        }

        public void visitLineNumber(int line, Label start) {
            super.visitLineNumber(line, start);
            if (!this.isInstrumented) {
                this.instrument();
            }
        }

        public void visitVarInsn(int opcode, int var) {
            if (!this.isInstrumented) {
                this.instrument();
            }
            super.visitVarInsn(opcode, var);
        }

        private void instrument() {
            Label l = new Label();
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, "com/tc/object/bytecode/hook/impl/ClassProcessorHelper", "getTCResource", "(Ljava/lang/String;Ljava/lang/ClassLoader;)Ljava/net/URL;");
            this.mv.visitVarInsn(58, 2);
            this.mv.visitVarInsn(25, 2);
            this.mv.visitJumpInsn(198, l);
            this.mv.visitVarInsn(25, 2);
            this.mv.visitInsn(176);
            this.mv.visitLabel(l);
            this.isInstrumented = true;
        }
    }

    private static class SclSetAdapter
    extends MethodAdapter
    implements Opcodes {
        public SclSetAdapter(MethodVisitor mv) {
            super(mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            super.visitFieldInsn(opcode, owner, name, desc);
            if ("sclSet".equals(name) && 179 == opcode) {
                Label l = new Label();
                super.visitFieldInsn(178, owner, "scl", "Ljava/lang/ClassLoader;");
                super.visitJumpInsn(198, l);
                super.visitMethodInsn(184, "com/tc/object/bytecode/hook/impl/ClassProcessorHelper", "systemLoaderInitialized", "()V");
                super.visitLabel(l);
            }
        }
    }

    private static class ClassLoaderVisitor
    extends ClassAdapter {
        private String className;

        public ClassLoaderVisitor(ClassVisitor cv) {
            super(cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME.equals(this.className) && "loadClassInternal".equals(name) && "(Ljava/lang/String;)Ljava/lang/Class;".equals(desc)) {
                return new LoadClassVisitor(mv);
            }
            if (ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME.equals(this.className) && "getResource".equals(name) && "(Ljava/lang/String;)Ljava/net/URL;".equals(desc)) {
                return new GetResourceVisitor(mv);
            }
            if ("initSystemClassLoader".equals(name)) {
                return new SclSetAdapter(mv);
            }
            return new ProcessingVisitor(mv, access, desc);
        }
    }

    static class IBMClassLoaderAdapter
    extends ClassAdapter
    implements Opcodes {
        private String className;

        public IBMClassLoaderAdapter(ClassVisitor cv) {
            super(cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME.equals(this.className) && "loadClass".equals(name) && "(Ljava/lang/String;)Ljava/lang/Class;".equals(desc)) {
                return new LoadClassVisitor(mv);
            }
            if (ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME.equals(this.className) && "getResource".equals(name) && "(Ljava/lang/String;)Ljava/net/URL;".equals(desc)) {
                return new GetResourceVisitor(mv);
            }
            return new MethodAdapter(mv){

                public void visitMethodInsn(int opcode, String owner, String mname, String mdesc) {
                    if (ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME.equals(owner) && "defineClassImpl".equals(mname)) {
                        mname = "__tc_defineClassImpl";
                    }
                    super.visitMethodInsn(opcode, owner, mname, mdesc);
                }
            };
        }

        public void visitEnd() {
            Label postDefine = new Label();
            MethodVisitor mv = super.visitMethod(4098, "__tc_defineClassImpl", "(Ljava/lang/String;[BIILjava/lang/Object;)Ljava/lang/Class;", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(21, 3);
            mv.visitVarInsn(21, 4);
            mv.visitVarInsn(25, 5);
            mv.visitTypeInsn(192, "java/security/ProtectionDomain");
            mv.visitMethodInsn(184, "com/tc/object/bytecode/hook/impl/ClassProcessorHelper", "defineClass0Pre", ClassLoaderPreProcessorImpl.DESC_HELPER);
            mv.visitVarInsn(58, 6);
            Label notInstrumented = new Label();
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 6);
            mv.visitJumpInsn(165, notInstrumented);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 6);
            mv.visitInsn(3);
            mv.visitVarInsn(25, 6);
            mv.visitInsn(190);
            mv.visitVarInsn(25, 5);
            mv.visitMethodInsn(183, ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME, "defineClassImpl", "(Ljava/lang/String;[BIILjava/lang/Object;)Ljava/lang/Class;");
            mv.visitJumpInsn(167, postDefine);
            mv.visitLabel(notInstrumented);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(21, 3);
            mv.visitVarInsn(21, 4);
            mv.visitVarInsn(25, 5);
            mv.visitMethodInsn(183, ClassLoaderPreProcessorImpl.CLASSLOADER_CLASS_NAME, "defineClassImpl", "(Ljava/lang/String;[BIILjava/lang/Object;)Ljava/lang/Class;");
            mv.visitLabel(postDefine);
            mv.visitVarInsn(58, 7);
            mv.visitVarInsn(25, 7);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "com/tc/object/bytecode/hook/impl/ClassProcessorHelper", "defineClass0Post", "(Ljava/lang/Class;Ljava/lang/ClassLoader;)V");
            mv.visitVarInsn(25, 7);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            super.visitEnd();
        }
    }
}

