/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode.aspectwerkz;

import com.tc.aspectwerkz.expression.ExpressionContext;
import com.tc.aspectwerkz.expression.ExpressionInfo;
import com.tc.aspectwerkz.expression.ExpressionVisitor;
import com.tc.aspectwerkz.expression.PointcutType;
import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.reflect.MemberInfo;
import com.tc.aspectwerkz.reflect.ReflectionInfo;
import java.util.HashMap;
import java.util.Map;

public class ExpressionHelper {
    private final Map expressionInfoCache = new HashMap();

    public ExpressionVisitor[] createExpressionVisitors(String[] expressions) {
        ExpressionVisitor[] rv = null;
        if (expressions == null) {
            rv = new ExpressionVisitor[]{};
        } else {
            rv = new ExpressionVisitor[expressions.length];
            for (int i = 0; i < expressions.length; ++i) {
                rv[i] = this.createExpressionVisitor(expressions[i]);
            }
        }
        return rv;
    }

    public ExpressionVisitor createExpressionVisitor(String expression) {
        return this.createExpressionInfo(expression).getExpression();
    }

    public ExpressionInfo createExpressionInfo(String expression) {
        return this.createExpressionInfo(expression, "__tc_default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionInfo createExpressionInfo(String expression, String namespace) {
        ExpressionInfo info;
        Map map = this.expressionInfoCache;
        synchronized (map) {
            info = (ExpressionInfo)this.expressionInfoCache.get(expression);
            if (info == null) {
                info = new ExpressionInfo(expression, namespace);
                this.expressionInfoCache.put(expression, info);
            }
        }
        return info;
    }

    public static String[] expressionPatterns2WithinExpressions(String[] expressions) {
        String[] rv = null;
        if (expressions == null) {
            rv = new String[]{};
        } else {
            rv = new String[expressions.length];
            for (int i = 0; i < expressions.length; ++i) {
                rv[i] = ExpressionHelper.expressionPattern2WithinExpression(expressions[i]);
            }
        }
        return rv;
    }

    public static String expressionPattern2WithinExpression(String expression) {
        return "within(" + expression + ")";
    }

    public static String expressionPattern2ExecutionExpression(String expression) {
        return "execution(" + expression + ")";
    }

    public ExpressionContext createWithinExpressionContext(ClassInfo classInfo) {
        ExpressionContext ctxt = new ExpressionContext(PointcutType.WITHIN, (ReflectionInfo)classInfo, (ReflectionInfo)classInfo);
        return ctxt;
    }

    public ExpressionContext createExecutionExpressionContext(MemberInfo methodInfo) {
        ExpressionContext ctxt = new ExpressionContext(PointcutType.EXECUTION, (ReflectionInfo)methodInfo, (ReflectionInfo)methodInfo);
        return ctxt;
    }
}

