/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode;

import com.tc.asm.Label;
import com.tc.asm.MethodVisitor;
import com.tc.asm.Opcodes;
import com.tc.asm.Type;
import com.tc.asm.commons.AdviceAdapter;
import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.reflect.FieldInfo;
import com.tc.aspectwerkz.reflect.MemberInfo;
import com.tc.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import com.tc.exception.TCInternalError;
import com.tc.object.bytecode.ByteCodeUtil;
import com.tc.object.bytecode.ClassAdapterBase;
import com.tc.object.bytecode.ExceptionTableOrderingMethodAdapter;
import com.tc.object.bytecode.InstrumentationSpec;
import com.tc.object.config.LockDefinition;
import com.tc.object.config.TransparencyClassSpec;
import com.tc.object.config.TransparencyCodeSpec;
import com.tc.object.locks.LockLevel;

public class TransparencyCodeAdapter
extends AdviceAdapter
implements Opcodes {
    private final boolean isAutolock;
    private final int autoLockType;
    private final InstrumentationSpec spec;
    private final MemberInfo memberInfo;
    private final boolean isConstructor;
    private final TransparencyCodeSpec codeSpec;
    private final Label labelZero = new Label();
    private boolean visitInit = false;
    private boolean logicalInitVisited = false;

    public TransparencyCodeAdapter(InstrumentationSpec spec, LockDefinition autoLockDefinition, MethodVisitor mv, MemberInfo memberInfo, String originalName) {
        super(new ExceptionTableOrderingMethodAdapter(mv), memberInfo.getModifiers(), originalName, memberInfo.getSignature());
        this.spec = spec;
        this.isAutolock = autoLockDefinition != null;
        this.autoLockType = this.isAutolock ? autoLockDefinition.getLockLevelAsInt() : -1;
        this.memberInfo = memberInfo;
        this.codeSpec = spec.getTransparencyClassSpec().getCodeSpec(memberInfo.getName(), memberInfo.getSignature(), this.isAutolock);
        this.isConstructor = "<init>".equals(originalName);
        if (!this.isConstructor) {
            this.visitInit = true;
        }
    }

    private int[] storeStackValuesToLocalVariables(String methodInsnDesc) {
        int i;
        Type[] types = Type.getArgumentTypes(methodInsnDesc);
        int[] localVariablesForMethodCall = new int[types.length];
        for (i = 0; i < types.length; ++i) {
            localVariablesForMethodCall[i] = this.newLocal(types[i]);
        }
        for (i = types.length - 1; i >= 0; --i) {
            super.visitVarInsn(types[i].getOpcode(54), localVariablesForMethodCall[i]);
        }
        return localVariablesForMethodCall;
    }

    private void loadLocalVariables(String methodInsnDesc, int[] localVariablesForMethodCall) {
        Type[] types = Type.getArgumentTypes(methodInsnDesc);
        for (int i = 0; i < types.length; ++i) {
            super.visitVarInsn(types[i].getOpcode(21), localVariablesForMethodCall[i]);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (this.spec.hasDelegatedToLogicalClass() && this.isConstructor) {
            this.logicalInitVisitMethodInsn(opcode, owner, name, desc);
        } else {
            this.basicVisitMethodInsn(opcode, owner, name, desc);
        }
    }

    private void logicalInitVisitMethodInsn(int opcode, String owner, String name, String desc) {
        String superClassNameSlashes = this.spec.getSuperClassNameSlashes();
        if (!this.logicalInitVisited && 183 == opcode && owner.equals(superClassNameSlashes) && "<init>".equals(name)) {
            this.logicalInitVisited = true;
            int[] localVariablesForMethodCall = this.storeStackValuesToLocalVariables(desc);
            this.loadLocalVariables(desc, localVariablesForMethodCall);
            super.visitMethodInsn(opcode, owner, name, desc);
            super.visitVarInsn(25, 0);
            super.visitTypeInsn(187, this.spec.getSuperClassNameSlashes());
            super.visitInsn(89);
            this.loadLocalVariables(desc, localVariablesForMethodCall);
            String delegateFieldName = ClassAdapterBase.getDelegateFieldName(superClassNameSlashes);
            super.visitMethodInsn(183, superClassNameSlashes, "<init>", desc);
            super.visitMethodInsn(183, this.spec.getClassNameSlashes(), ByteCodeUtil.fieldSetterMethod(delegateFieldName), "(L" + superClassNameSlashes + ";)V");
        } else {
            this.basicVisitMethodInsn(opcode, owner, name, desc);
        }
    }

    private void basicVisitMethodInsn(int opcode, String classname, String theMethodName, String desc) {
        if (this.handleSubclassOfLogicalClassMethodInsn(opcode, classname, theMethodName, desc)) {
            return;
        }
        if ("clone".equals(theMethodName) && this.handleCloneCall(opcode, classname, theMethodName, desc)) {
            return;
        }
        if (this.codeSpec.isArraycopyInstrumentationReq(classname, theMethodName)) {
            this.rewriteArraycopy();
        } else if (classname.equals("java/lang/Object")) {
            this.handleJavaLangObjectMethodCall(opcode, classname, theMethodName, desc);
        } else if (classname.equals("java/lang/String") && "intern".equals(theMethodName)) {
            super.visitMethodInsn(182, "java/lang/String", "__tc_intern", "()Ljava/lang/String;");
        } else {
            super.visitMethodInsn(opcode, classname, theMethodName, desc);
        }
    }

    private boolean handleSubclassOfLogicalClassMethodInsn(int opcode, String classname, String theMethodName, String desc) {
        if (!this.spec.hasDelegatedToLogicalClass()) {
            return false;
        }
        String logicalExtendingClassName = this.spec.getSuperClassNameSlashes();
        if (183 == opcode && !this.spec.getClassNameSlashes().equals(classname) && !"<init>".equals(theMethodName)) {
            this.spec.shouldProceedInstrumentation(this.memberInfo.getModifiers(), theMethodName, desc);
            int[] localVariablesForMethodCall = this.storeStackValuesToLocalVariables(desc);
            super.visitMethodInsn(183, this.spec.getClassNameSlashes(), ByteCodeUtil.fieldGetterMethod(ClassAdapterBase.getDelegateFieldName(logicalExtendingClassName)), "()L" + logicalExtendingClassName + ";");
            this.loadLocalVariables(desc, localVariablesForMethodCall);
            super.visitMethodInsn(182, logicalExtendingClassName, theMethodName, desc);
            return true;
        }
        return false;
    }

    private TransparencyClassSpec getTransparencyClassSpec() {
        return this.spec.getTransparencyClassSpec();
    }

    private void rewriteArraycopy() {
        this.callArrayManagerMethod("arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V");
    }

    private void handleJavaLangObjectMethodCall(int opcode, String classname, String theMethodName, String desc) {
        if (this.handleJavaLangObjectWaitNotifyCalls(opcode, classname, theMethodName, desc)) {
            return;
        }
        super.visitMethodInsn(opcode, classname, theMethodName, desc);
    }

    private boolean handleCloneCall(int opcode, String classname, String theMethodName, String desc) {
        if ("clone".equals(theMethodName) && "()Ljava/lang/Object;".equals(desc) && (classname.startsWith("[") || classname.equals("java/lang/Object"))) {
            Type objectType = Type.getObjectType("java/lang/Object");
            int refToBeCloned = this.newLocal(objectType);
            int ref1 = this.newLocal(objectType);
            int ref2 = this.newLocal(objectType);
            int ref3 = this.newLocal(objectType);
            super.visitVarInsn(58, refToBeCloned);
            Label l0 = new Label();
            Label l1 = new Label();
            Label l2 = new Label();
            super.visitTryCatchBlock(l0, l1, l2, null);
            Label l3 = new Label();
            super.visitTryCatchBlock(l2, l3, l2, null);
            super.visitVarInsn(25, refToBeCloned);
            super.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "lookupExistingOrNull", "(Ljava/lang/Object;)Lcom/tc/object/TCObject;");
            super.visitVarInsn(58, ref2);
            super.visitVarInsn(25, ref2);
            Label l8 = new Label();
            super.visitJumpInsn(198, l8);
            super.visitVarInsn(25, ref2);
            super.visitMethodInsn(185, "com/tc/object/TCObject", "getResolveLock", "()Ljava/lang/Object;");
            super.visitInsn(89);
            super.visitVarInsn(58, ref3);
            super.visitInsn(194);
            super.visitLabel(l0);
            super.visitVarInsn(25, ref2);
            super.visitMethodInsn(185, "com/tc/object/TCObject", "resolveAllReferences", "()V");
            super.visitVarInsn(25, refToBeCloned);
            super.visitVarInsn(25, refToBeCloned);
            super.visitMethodInsn(opcode, classname, theMethodName, desc);
            super.visitMethodInsn(184, "com/tc/object/bytecode/hook/impl/Util", "fixTCObjectReferenceOfClonedObject", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            super.visitVarInsn(58, ref1);
            super.visitVarInsn(25, ref3);
            super.visitInsn(195);
            super.visitLabel(l1);
            Label l12 = new Label();
            super.visitJumpInsn(167, l12);
            super.visitLabel(l2);
            super.visitVarInsn(25, ref3);
            super.visitInsn(195);
            super.visitLabel(l3);
            super.visitInsn(191);
            super.visitLabel(l8);
            super.visitVarInsn(25, refToBeCloned);
            super.visitMethodInsn(opcode, classname, theMethodName, desc);
            super.visitVarInsn(58, ref1);
            super.visitLabel(l12);
            super.visitVarInsn(25, ref1);
            return true;
        }
        return false;
    }

    private boolean handleJavaLangObjectWaitNotifyCalls(int opcode, String classname, String theMethodName, String desc) {
        if (this.spec.isLogical() || !this.codeSpec.isWaitNotifyInstrumentationReq()) {
            return false;
        }
        Type[] args = Type.getArgumentTypes(desc);
        if (theMethodName.equals("notify") || theMethodName.equals("notifyAll")) {
            if (args.length == 0) {
                if (theMethodName.endsWith("All")) {
                    this.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "objectNotifyAll", "(Ljava/lang/Object;)V");
                } else {
                    this.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "objectNotify", "(Ljava/lang/Object;)V");
                }
                return true;
            }
            throw new TCInternalError("Unexpected java.lang.Object method signature: " + theMethodName + " + " + desc);
        }
        if (theMethodName.equals("wait")) {
            switch (args.length) {
                case 0: {
                    this.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "objectWait", "(Ljava/lang/Object;)V");
                    return true;
                }
                case 1: {
                    if (args[0].equals(Type.LONG_TYPE)) {
                        this.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "objectWait", "(Ljava/lang/Object;J)V");
                        return true;
                    }
                    throw new TCInternalError("Unexpected java.lang.Object method signature: " + theMethodName + " + " + desc);
                }
                case 2: {
                    if (args[0].equals(Type.LONG_TYPE) && args[1].equals(Type.INT_TYPE)) {
                        this.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "objectWait", "(Ljava/lang/Object;JI)V");
                        return true;
                    }
                    throw new TCInternalError("Unexpected java.lang.Object method signature: " + theMethodName + " + " + desc);
                }
            }
            throw new TCInternalError("Unexpected java.lang.Object method signature: " + theMethodName + " + " + desc);
        }
        return false;
    }

    private void callTCBeginWithLocks(MethodVisitor c) {
        c.visitLabel(new Label());
        LockDefinition[] defs = this.getTransparencyClassSpec().lockDefinitionsFor(this.memberInfo);
        for (int i = 0; i < defs.length; ++i) {
            if (defs[i].isAutolock()) continue;
            this.callTCBeginWithLock(defs[i], c);
        }
    }

    private void callTCBeginWithLock(LockDefinition lock, MethodVisitor c) {
        c.visitLdcInsn(ByteCodeUtil.generateNamedLockName(lock.getLockName()));
        c.visitLdcInsn(new Integer(lock.getLockLevelAsInt()));
        c.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "beginLock", "(Ljava/lang/String;I)V");
    }

    private void callTCCommit(MethodVisitor c) {
        LockDefinition[] locks = this.getTransparencyClassSpec().lockDefinitionsFor(this.memberInfo);
        for (int i = 0; i < locks.length; ++i) {
            if (locks[i].isAutolock()) continue;
            c.visitLdcInsn(ByteCodeUtil.generateNamedLockName(locks[i].getLockName()));
            c.visitLdcInsn(new Integer(locks[i].getLockLevelAsInt()));
            c.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "commitLock", "(Ljava/lang/String;I)V");
        }
    }

    private void callMonitorEnterWithContextInfo() {
        super.visitLdcInsn(new Integer(this.autoLockType));
        this.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "instrumentationMonitorEnter", "(Ljava/lang/Object;I)V");
    }

    private void callMonitorExit() {
        super.visitLdcInsn(new Integer(this.autoLockType));
        this.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "instrumentationMonitorExit", "(Ljava/lang/Object;I)V");
    }

    private void visitInsnForReadLock(int opCode) {
        switch (opCode) {
            case 194: {
                super.visitInsn(89);
                super.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "isDsoMonitored", "(Ljava/lang/Object;)Z");
                Label l1 = new Label();
                super.visitJumpInsn(153, l1);
                this.callMonitorEnterWithContextInfo();
                Label l2 = new Label();
                super.visitJumpInsn(167, l2);
                super.visitLabel(l1);
                super.visitInsn(opCode);
                super.visitLabel(l2);
                return;
            }
            case 195: {
                super.visitInsn(89);
                super.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "isDsoMonitorEntered", "(Ljava/lang/Object;)Z");
                Label l3 = new Label();
                super.visitJumpInsn(153, l3);
                this.callMonitorExit();
                Label l4 = new Label();
                super.visitJumpInsn(167, l4);
                super.visitLabel(l3);
                super.visitInsn(opCode);
                super.visitLabel(l4);
                return;
            }
        }
    }

    public void visitInsn(int opCode) {
        if (this.isMonitorInstrumentationReq(opCode)) {
            switch (opCode) {
                case 194: {
                    if (this.isAutolock) {
                        if (this.autoLockType == LockLevel.READ.toInt()) {
                            this.visitInsnForReadLock(opCode);
                            return;
                        }
                        super.visitInsn(89);
                        this.callMonitorEnterWithContextInfo();
                        super.visitInsn(opCode);
                    } else {
                        super.visitInsn(opCode);
                    }
                    return;
                }
                case 195: {
                    if (this.isAutolock) {
                        if (this.autoLockType == LockLevel.READ.toInt()) {
                            this.visitInsnForReadLock(opCode);
                            return;
                        }
                        super.visitInsn(89);
                        super.visitInsn(opCode);
                        this.callMonitorExit();
                    } else {
                        super.visitInsn(opCode);
                    }
                    return;
                }
            }
        }
        if (this.isArrayOperatorInstrumentationReq(opCode)) {
            switch (opCode) {
                case 50: {
                    Label end = new Label();
                    Label notManaged = new Label();
                    Label lockedStart = new Label();
                    Label lockedEnd = new Label();
                    Label unlockException = new Label();
                    super.visitTryCatchBlock(lockedStart, lockedEnd, unlockException, null);
                    super.visitInsn(92);
                    super.visitInsn(87);
                    this.callArrayManagerMethod("getObject", "(Ljava/lang/Object;)Lcom/tc/object/TCObject;");
                    super.visitInsn(89);
                    super.visitJumpInsn(198, notManaged);
                    super.visitInsn(89);
                    super.visitMethodInsn(185, "com/tc/object/TCObject", "getResolveLock", "()Ljava/lang/Object;");
                    super.visitInsn(89);
                    int lockSlot = this.newLocal(Type.getType(Object.class));
                    this.mv.visitVarInsn(58, lockSlot);
                    super.visitInsn(194);
                    super.visitLabel(lockedStart);
                    super.visitInsn(92);
                    super.visitInsn(95);
                    super.visitMethodInsn(185, "com/tc/object/TCObject", "resolveArrayReference", "(I)V");
                    super.visitInsn(87);
                    super.visitInsn(opCode);
                    this.mv.visitVarInsn(25, lockSlot);
                    super.visitInsn(195);
                    super.visitLabel(lockedEnd);
                    super.visitJumpInsn(167, end);
                    super.visitLabel(unlockException);
                    this.mv.visitVarInsn(25, lockSlot);
                    super.visitInsn(195);
                    super.visitInsn(191);
                    super.visitLabel(notManaged);
                    super.visitInsn(87);
                    super.visitInsn(opCode);
                    super.visitLabel(end);
                    return;
                }
                case 83: {
                    this.callArrayManagerMethod("objectArrayChanged", "([Ljava/lang/Object;ILjava/lang/Object;)V");
                    return;
                }
                case 80: {
                    this.callArrayManagerMethod("longArrayChanged", "([JIJ)V");
                    return;
                }
                case 86: {
                    this.callArrayManagerMethod("shortArrayChanged", "([SIS)V");
                    return;
                }
                case 79: {
                    this.callArrayManagerMethod("intArrayChanged", "([III)V");
                    return;
                }
                case 82: {
                    this.callArrayManagerMethod("doubleArrayChanged", "([DID)V");
                    return;
                }
                case 81: {
                    this.callArrayManagerMethod("floatArrayChanged", "([FIF)V");
                    return;
                }
                case 84: {
                    this.callArrayManagerMethod("byteOrBooleanArrayChanged", "(Ljava/lang/Object;IB)V");
                    return;
                }
                case 85: {
                    this.callArrayManagerMethod("charArrayChanged", "([CIC)V");
                    return;
                }
            }
        }
        super.visitInsn(opCode);
    }

    private boolean isArrayOperatorInstrumentationReq(int opCode) {
        return (opCode == 50 || opCode == 83 || opCode == 80 || opCode == 86 || opCode == 79 || opCode == 82 || opCode == 81 || opCode == 84 || opCode == 85) && this.codeSpec.isArrayOperatorInstrumentationReq();
    }

    private boolean isMonitorInstrumentationReq(int opCode) {
        return (opCode == 194 || opCode == 195) && this.codeSpec.isMonitorInstrumentationReq();
    }

    private void callArrayManagerMethod(String name, String desc) {
        super.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", name, desc);
    }

    public void visitMaxs(int stack, int vars) {
        super.visitMaxs(stack, vars + 1);
    }

    public void visitFieldInsn(int opcode, String classname, String fieldName, String desc) {
        this.spec.shouldProceedInstrumentation(fieldName, desc);
        if (!(this.spec.needInstrumentFieldInsn() && this.visitInit && this.codeSpec.isFieldInstrumentationReq(fieldName))) {
            super.visitFieldInsn(opcode, classname, fieldName, desc);
            return;
        }
        if (this.spec.isPhysical()) {
            if (opcode == 180) {
                this.visitGetFieldInsn(classname, fieldName, desc);
                return;
            }
            if (opcode == 181) {
                this.visitSetFieldInsn(classname, fieldName, desc);
                return;
            }
            if (opcode == 179 && this.isRoot(classname, fieldName)) {
                String sDesc = "(" + desc + ")V";
                this.visitMethodInsn(184, classname, ByteCodeUtil.fieldSetterMethod(fieldName), sDesc);
                return;
            }
            if (opcode == 178 && this.isRoot(classname, fieldName)) {
                String gDesc = "()" + desc;
                this.visitMethodInsn(184, classname, ByteCodeUtil.fieldGetterMethod(fieldName), gDesc);
                return;
            }
            super.visitFieldInsn(opcode, classname, fieldName, desc);
        } else {
            super.visitFieldInsn(opcode, classname, fieldName, desc);
        }
    }

    private void visitSetFieldInsn(String classname, String fieldName, String desc) {
        boolean inClassHierarchy = this.spec.isInClassHierarchy(classname);
        if (this.spec.isClassPortable() && inClassHierarchy || this.isRoot(classname, fieldName)) {
            this.visitUncheckedSetFieldInsn(classname, fieldName, desc);
        } else if (this.codeSpec.isForceRawFieldAccess() || this.spec.isClassAdaptable() && inClassHierarchy) {
            this.visitSetFieldInsnOriginal(classname, fieldName, desc);
        } else {
            this.visitCheckedSetFieldInsn(classname, fieldName, desc);
        }
    }

    private void visitSetFieldInsnOriginal(String classname, String fieldName, String desc) {
        super.visitFieldInsn(181, classname, fieldName, desc);
    }

    private void visitUncheckedSetFieldInsn(String classname, String fieldName, String desc) {
        String sDesc = "(" + desc + ")V";
        this.visitMethodInsn(182, classname, ByteCodeUtil.fieldSetterMethod(fieldName), sDesc);
    }

    private void visitCheckedSetFieldInsn(String classname, String fieldName, String desc) {
        Type fieldType = Type.getType(desc);
        Type reference = Type.getType("Ljava/lang/Object;");
        String sDesc = "(" + desc + ")V";
        this.swap(reference, fieldType);
        super.visitInsn(89);
        Label l1 = new Label();
        super.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        this.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "isPhysicallyInstrumented", "(Ljava/lang/Class;)Z");
        super.visitJumpInsn(153, l1);
        this.swap(fieldType, reference);
        this.visitMethodInsn(182, classname, ByteCodeUtil.fieldSetterMethod(fieldName), sDesc);
        Label l2 = new Label();
        super.visitJumpInsn(167, l2);
        super.visitLabel(l1);
        this.swap(fieldType, reference);
        super.visitFieldInsn(181, classname, fieldName, desc);
        super.visitLabel(l2);
    }

    private void visitGetFieldInsn(String classname, String fieldName, String desc) {
        boolean inClassHierarchy = this.spec.isInClassHierarchy(classname);
        if (this.spec.isClassPortable() && inClassHierarchy || this.isRoot(classname, fieldName)) {
            this.visitUncheckedGetFieldInsn(classname, fieldName, desc);
        } else if (this.codeSpec.isForceRawFieldAccess() || this.spec.isClassAdaptable() && inClassHierarchy) {
            this.visitGetFieldInsnOriginal(classname, fieldName, desc);
        } else {
            this.visitCheckedGetFieldInsn(classname, fieldName, desc);
        }
    }

    private void visitGetFieldInsnOriginal(String classname, String fieldName, String desc) {
        super.visitFieldInsn(180, classname, fieldName, desc);
    }

    private void visitUncheckedGetFieldInsn(String classname, String fieldName, String desc) {
        String gDesc = "()" + desc;
        this.visitMethodInsn(182, classname, ByteCodeUtil.fieldGetterMethod(fieldName), gDesc);
    }

    private void visitCheckedGetFieldInsn(String classname, String fieldName, String desc) {
        String gDesc = "()" + desc;
        super.visitInsn(89);
        Label l1 = new Label();
        super.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        this.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "isPhysicallyInstrumented", "(Ljava/lang/Class;)Z");
        super.visitJumpInsn(153, l1);
        this.visitMethodInsn(182, classname, ByteCodeUtil.fieldGetterMethod(fieldName), gDesc);
        Label l2 = new Label();
        super.visitJumpInsn(167, l2);
        super.visitLabel(l1);
        super.visitFieldInsn(180, classname, fieldName, desc);
        super.visitLabel(l2);
    }

    private boolean isRoot(String classname, String fieldName) {
        FieldInfo[] fields;
        ClassInfo classInfo = AsmClassInfo.getClassInfo((String)classname.replace('/', '.'), (ClassLoader)this.spec.getCaller());
        for (FieldInfo fieldInfo : fields = classInfo.getFields()) {
            if (!fieldName.equals(fieldInfo.getName()) || !this.getTransparencyClassSpec().isRoot(fieldInfo)) continue;
            return true;
        }
        return false;
    }

    protected void onMethodEnter() {
        if (this.isConstructor) {
            this.visitInit = true;
            if (this.getTransparencyClassSpec().isLockMethod(this.memberInfo)) {
                this.callTCBeginWithLocks(this);
                super.visitLabel(this.labelZero);
            }
        }
    }

    protected void onMethodExit(int opcode) {
        if (this.isConstructor && this.getTransparencyClassSpec().isLockMethod(this.memberInfo)) {
            if (opcode == 177) {
                this.callTCCommit(this);
            } else if (opcode != 191) {
                throw new AssertionError((Object)("unexpected exit instruction: " + opcode));
            }
        }
    }

    public void visitEnd() {
        if (this.isConstructor && this.getTransparencyClassSpec().isLockMethod(this.memberInfo)) {
            Label labelEnd = new Label();
            super.visitLabel(labelEnd);
            super.visitTryCatchBlock(this.labelZero, labelEnd, labelEnd, null);
            int localVar = this.newLocal(Type.getObjectType("java/lang/Object"));
            super.visitVarInsn(58, localVar);
            this.callTCCommit(this.mv);
            super.visitVarInsn(25, localVar);
            this.mv.visitInsn(191);
        }
        super.visitEnd();
    }
}

