/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode;

import com.tc.asm.ClassVisitor;
import com.tc.asm.FieldVisitor;
import com.tc.asm.Label;
import com.tc.asm.MethodVisitor;
import com.tc.asm.Type;
import com.tc.aspectwerkz.exception.DefinitionException;
import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.reflect.FieldInfo;
import com.tc.aspectwerkz.reflect.MemberInfo;
import com.tc.aspectwerkz.reflect.MethodInfo;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.Portability;
import com.tc.object.bytecode.ByteCodeUtil;
import com.tc.object.bytecode.ClassAdapterBase;
import com.tc.object.bytecode.MethodAdapter;
import com.tc.object.bytecode.PhysicalClassAdapterLogger;
import com.tc.object.bytecode.TransparencyCodeAdapter;
import com.tc.object.config.ConfigLockLevel;
import com.tc.object.config.LockDefinition;
import com.tc.object.config.TransparencyClassSpec;
import com.tc.object.locks.LockLevel;
import com.tc.object.logging.InstrumentationLogger;
import com.tc.properties.TCPropertiesImpl;
import com.tc.text.Banner;
import com.tc.util.Assert;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

public class TransparencyClassAdapter
extends ClassAdapterBase {
    private static final TCLogger logger = TCLogging.getLogger(TransparencyClassAdapter.class);
    private static final boolean useFastFinalFields = TCPropertiesImpl.getProperties().getBoolean("instrumentation.finalField.fastRead");
    private final Set doNotInstrument = new HashSet();
    private final PhysicalClassAdapterLogger physicalClassLogger;
    private final InstrumentationLogger instrumentationLogger;
    private boolean supportMethodsCreated;

    public TransparencyClassAdapter(ClassInfo classInfo, TransparencyClassSpec spec, ClassVisitor cv, InstrumentationLogger instrumentationLogger, ClassLoader caller, Portability portability) {
        super(classInfo, spec, cv, caller, portability);
        this.instrumentationLogger = instrumentationLogger;
        this.physicalClassLogger = new PhysicalClassAdapterLogger(logger);
    }

    protected void basicVisit(int version, int access, String name, String signature, String superClassName, String[] interfaces) {
        try {
            logger.debug("ADAPTING CLASS: " + name);
            super.basicVisit(version, access, name, signature, superClassName, interfaces);
            if (!this.supportMethodsCreated) {
                this.supportMethodsCreated = true;
                this.getTransparencyClassSpec().createClassSupportMethods(this.cv);
            }
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
            throw e;
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private void handleInstrumentationException(Throwable e) {
        logger.fatal(e);
        logger.fatal("Calling System.exit(1)");
        System.exit(1);
    }

    private boolean isRoot(int access, String fieldName) {
        try {
            FieldInfo fieldInfo = this.spec.getFieldInfo(fieldName);
            boolean isRoot = fieldInfo == null ? false : this.getTransparencyClassSpec().isRootInThisClass(fieldInfo);
            boolean isTransient = this.getTransparencyClassSpec().isTransient(access, this.spec.getClassInfo(), fieldName);
            if (isTransient && isRoot && this.instrumentationLogger.getTransientRootWarning()) {
                this.instrumentationLogger.transientRootWarning(this.spec.getClassNameDots(), fieldName);
            }
            return isRoot;
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
            throw e;
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private String rootNameFor(String className, String fieldName) {
        try {
            return this.getTransparencyClassSpec().rootNameFor(this.spec.getFieldInfo(fieldName));
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
            throw e;
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    protected FieldVisitor basicVisitField(int access, String name, String desc, String signature, Object value) {
        try {
            if (this.spec.isClassPortable() && this.spec.isPhysical() && !ByteCodeUtil.isTCSynthetic(name) || this.spec.isClassAdaptable() && this.isRoot(access, name)) {
                this.generateGettersSetters(access, name, desc, Modifier.isStatic(access));
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.handleInstrumentationException(e);
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
        return this.cv.visitField(access, name, desc, signature, value);
    }

    private void generateGettersSetters(int fieldAccess, String name, String desc, boolean isStatic) {
        boolean isTransient = this.getTransparencyClassSpec().isTransient(fieldAccess, this.spec.getClassInfo(), name);
        boolean createPlainAccessors = isTransient && !isStatic;
        boolean createInstrumentedAccessors = !isTransient && !isStatic;
        boolean createRootAccessors = this.isRoot(fieldAccess, name);
        int methodAccess = fieldAccess & 0xFFFFFF7F;
        methodAccess &= 0xFFFFFFEF;
        methodAccess &= 0xFFFFFFBF;
        methodAccess |= 0x1000;
        if (createRootAccessors) {
            this.createRootGetter(methodAccess, name, desc);
        } else if (createInstrumentedAccessors) {
            if (!ByteCodeUtil.isPrimitive(Type.getType(desc))) {
                this.createInstrumentedGetter(methodAccess, fieldAccess, name, desc);
            } else {
                this.createPlainGetter(methodAccess, fieldAccess, name, desc);
            }
        } else if (createPlainAccessors) {
            this.createPlainGetter(methodAccess, fieldAccess, name, desc);
        }
        if (createInstrumentedAccessors || createRootAccessors) {
            this.createInstrumentedSetter(methodAccess, fieldAccess, name, desc);
        } else if (createPlainAccessors) {
            this.createPlainSetter(methodAccess, fieldAccess, name, desc);
        }
    }

    private boolean isPrimitive(Type t) {
        return ByteCodeUtil.isPrimitive(t);
    }

    private MethodVisitor ignoreMethodIfNeeded(int access, String name, String desc, String signature, String[] exceptions, MemberInfo memberInfo) {
        if ((name.startsWith("__tc_") || this.doNotInstrument.contains(name + desc) || this.getTransparencyClassSpec().doNotInstrument(name)) && !this.getTransparencyClassSpec().hasCustomMethodAdapter(memberInfo)) {
            this.physicalClassLogger.logVisitMethodIgnoring(name, desc);
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
        return null;
    }

    protected MethodVisitor basicVisitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String originalName = name;
        MethodVisitor mv = null;
        try {
            boolean isAutoReadLock;
            this.physicalClassLogger.logVisitMethodBegin(access, name, desc, signature, exceptions);
            MethodInfo memberInfo = this.getInstrumentationSpec().getMethodInfo(access, name, desc);
            mv = this.ignoreMethodIfNeeded(access, name, desc, signature, exceptions, (MemberInfo)memberInfo);
            if (mv != null) {
                return mv;
            }
            LockDefinition[] locks = this.getTransparencyClassSpec().lockDefinitionsFor((MemberInfo)memberInfo);
            LockDefinition ld = this.getTransparencyClassSpec().getAutoLockDefinition(locks);
            boolean isAutolock = ld != null;
            int lockLevel = -1;
            if (isAutolock) {
                lockLevel = ld.getLockLevelAsInt();
                if (this.instrumentationLogger.getLockInsertion()) {
                    this.instrumentationLogger.autolockInserted(this.spec.getClassNameDots(), name, desc, ld);
                }
            }
            boolean bl = isAutoReadLock = isAutolock && lockLevel == LockLevel.READ.toInt();
            if (this.isAutoSynchronized(ld) && !"<init>".equals(name)) {
                access |= 0x20;
            }
            boolean isLockMethod = isAutolock && Modifier.isSynchronized(access) && !Modifier.isStatic(access);
            this.physicalClassLogger.logVisitMethodCheckIsLockMethod();
            if (!isLockMethod || this.spec.isClassAdaptable()) {
                boolean bl2 = isLockMethod = this.getTransparencyClassSpec().getNonAutoLockDefinition(locks) != null;
            }
            if (isLockMethod && !"<init>".equals(name)) {
                this.physicalClassLogger.logVisitMethodCreateLockMethod(name);
                Assert.assertNotNull(locks);
                Assert.eval(locks.length > 0 || isLockMethod);
                this.createLockMethod(access, name, desc, signature, exceptions, locks, isAutoReadLock);
                this.logCustomerLockMethod(name, desc, locks);
                name = "__tc_wrapped_" + name;
                access |= 2;
                access &= 0xFFFFFFFE;
                access &= 0xFFFFFFFB;
                if (isAutoReadLock) {
                    access &= 0xFFFFFFDF;
                }
            } else {
                this.physicalClassLogger.logVisitMethodNotALockMethod(access, this.spec.getClassNameDots(), name, desc, exceptions);
            }
            if (this.getTransparencyClassSpec().hasCustomMethodAdapter((MemberInfo)memberInfo)) {
                MethodAdapter ma = this.getTransparencyClassSpec().customMethodAdapterFor(access, name, originalName, desc, signature, exceptions, this.instrumentationLogger, (MemberInfo)memberInfo);
                mv = ma.adapt(this.cv);
                if (!ma.doesOriginalNeedAdapting()) {
                    return mv;
                }
            }
            if (mv == null) {
                mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            }
            return mv == null ? null : new TransparencyCodeAdapter(this.spec, ld, mv, (MemberInfo)memberInfo, originalName);
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
            throw e;
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private boolean isAutoSynchronized(LockDefinition ld) {
        if (ld == null) {
            return false;
        }
        ConfigLockLevel lockLevel = ld.getLockLevel();
        return ConfigLockLevel.AUTO_SYNCHRONIZED_READ.equals(lockLevel) || ConfigLockLevel.AUTO_SYNCHRONIZED_WRITE.equals(lockLevel) || ConfigLockLevel.AUTO_SYNCHRONIZED_CONCURRENT.equals(lockLevel) || ConfigLockLevel.AUTO_SYNCHRONIZED_SYNCHRONOUS_WRITE.equals(lockLevel);
    }

    private void logCustomerLockMethod(String name, String desc, LockDefinition[] locks) {
        if (this.instrumentationLogger.getLockInsertion()) {
            this.instrumentationLogger.lockInserted(this.spec.getClassNameDots(), name, desc, locks);
        }
    }

    private void createLockMethod(int access, String name, String desc, String signature, String[] exceptions, LockDefinition[] locks, boolean skipLocalJVMLock) {
        try {
            this.physicalClassLogger.logCreateLockMethodBegin(access, name, desc, signature, exceptions, locks);
            this.doNotInstrument.add(name + desc);
            this.recreateMethod(access, name, desc, signature, exceptions, locks, skipLocalJVMLock);
            if (skipLocalJVMLock) {
                access |= 2;
                access &= 0xFFFFFFFE;
                this.createSyncMethod(access &= 0xFFFFFFFB, name, desc, signature, exceptions);
            }
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
            throw e;
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private String getTCSyncMethodName(String name) {
        return "__tc_wrapped_sync_" + name;
    }

    private void createSyncMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Type returnType = Type.getReturnType(desc);
        MethodVisitor mv = this.cv.visitMethod(access, this.getTCSyncMethodName(name), desc, signature, exceptions);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        this.callRenamedMethod(access & 0xFFFFFFDF, name, desc, mv);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitInsn(returnType.getOpcode(172));
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable("this", "L" + this.spec.getClassNameSlashes() + ";", null, l0, l2, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void recreateMethod(int access, String name, String desc, String signature, String[] exceptions, LockDefinition[] locks, boolean skipLocalJVMLock) {
        Type returnType = Type.getReturnType(desc);
        this.physicalClassLogger.logCreateLockMethodVoidBegin(access, name, desc, signature, exceptions, locks);
        MethodVisitor c = this.cv.visitMethod(access & 0xFFFFFFDF, name, desc, signature, exceptions);
        Label l1 = new Label();
        if (skipLocalJVMLock) {
            ByteCodeUtil.pushThis(c);
            c.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "isDsoMonitored", "(Ljava/lang/Object;)Z");
            c.visitJumpInsn(153, l1);
        }
        if (returnType.getSort() == 0) {
            this.addDsoLockMethodInsnVoid(access, name, desc, signature, exceptions, locks, c);
        } else {
            this.addDsoLockMethodInsnReturn(access, name, desc, signature, exceptions, locks, returnType, c);
        }
        if (skipLocalJVMLock) {
            c.visitLabel(l1);
            this.callRenamedMethod(access, "sync_" + name, desc, c);
            c.visitInsn(returnType.getOpcode(172));
        }
        c.visitMaxs(0, 0);
        c.visitEnd();
    }

    private int addBooleanLocalVariablesIfMoreThanOneLock(int access, String desc, LockDefinition[] locks, MethodVisitor c, int[] localBooleanVariables) {
        int nextLocalVariable = ByteCodeUtil.getFirstLocalVariableOffset(access, desc);
        if (locks.length > 1) {
            for (int i = 0; i < locks.length; ++i) {
                localBooleanVariables[i] = nextLocalVariable;
                ByteCodeUtil.pushDefaultValue(localBooleanVariables[i], c, Type.BOOLEAN_TYPE);
                nextLocalVariable += Type.BOOLEAN_TYPE.getSize();
            }
        }
        return nextLocalVariable;
    }

    private void startDsoLockTryBlock(int access, String name, String desc, LockDefinition[] locks, MethodVisitor c, int[] localBooleanVariables, Label startTryBlockLabel) {
        if (locks.length > 1) {
            c.visitLabel(startTryBlockLabel);
            this.callTCBeginWithLocks(access, name, desc, locks, c, localBooleanVariables);
        } else {
            this.callTCBeginWithLocks(access, name, desc, locks, c, localBooleanVariables);
            c.visitLabel(startTryBlockLabel);
        }
    }

    private void addDsoLockMethodInsnVoid(int access, String name, String desc, String signature, String[] exceptions, LockDefinition[] locks, MethodVisitor c) {
        int[] localBooleanVariables = new int[locks.length];
        int localVariableOffset = this.addBooleanLocalVariablesIfMoreThanOneLock(access, desc, locks, c, localBooleanVariables);
        try {
            Label l0 = new Label();
            this.startDsoLockTryBlock(access, name, desc, locks, c, localBooleanVariables, l0);
            this.callRenamedMethod(access, name, desc, c);
            Label l1 = new Label();
            c.visitJumpInsn(167, l1);
            Label l2 = new Label();
            c.visitLabel(l2);
            c.visitVarInsn(58, 1 + localVariableOffset);
            Label l3 = new Label();
            c.visitJumpInsn(168, l3);
            c.visitVarInsn(25, 1 + localVariableOffset);
            c.visitInsn(191);
            c.visitLabel(l3);
            c.visitVarInsn(58, 0 + localVariableOffset);
            this.callTCCommit(access, name, desc, locks, c, localBooleanVariables);
            c.visitVarInsn(169, 0 + localVariableOffset);
            c.visitLabel(l1);
            c.visitJumpInsn(168, l3);
            Label l4 = new Label();
            c.visitLabel(l4);
            c.visitInsn(177);
            c.visitTryCatchBlock(l0, l2, l2, null);
            c.visitTryCatchBlock(l1, l4, l2, null);
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private void handleInstrumentationException(RuntimeException e) {
        if (e instanceof DefinitionException) {
            logger.fatal(e.getLocalizedMessage());
        } else {
            logger.fatal(e);
        }
        e.printStackTrace(System.err);
        System.err.flush();
        String msg = "Error detected -- Calling System.exit(1)";
        Banner.errorBanner(msg);
        logger.fatal(msg);
        System.exit(1);
    }

    private void callRenamedMethod(int callingMethodModifier, String name, String desc, MethodVisitor c) {
        ByteCodeUtil.prepareStackForMethodCall(callingMethodModifier, desc, c);
        if (Modifier.isStatic(callingMethodModifier)) {
            c.visitMethodInsn(184, this.spec.getClassNameSlashes(), "__tc_wrapped_" + name, desc);
        } else {
            c.visitMethodInsn(183, this.spec.getClassNameSlashes(), "__tc_wrapped_" + name, desc);
        }
    }

    private void addDsoLockMethodInsnReturn(int access, String name, String desc, String signature, String[] exceptions, LockDefinition[] locks, Type returnType, MethodVisitor c) {
        int[] localBooleanVariables = new int[locks.length];
        int localVariableOffset = this.addBooleanLocalVariablesIfMoreThanOneLock(access, desc, locks, c, localBooleanVariables);
        try {
            Label l0 = new Label();
            this.startDsoLockTryBlock(access, name, desc, locks, c, localBooleanVariables, l0);
            this.callRenamedMethod(access, name, desc, c);
            c.visitVarInsn(returnType.getOpcode(54), 2 + localVariableOffset);
            Label l1 = new Label();
            c.visitJumpInsn(168, l1);
            Label l2 = new Label();
            c.visitLabel(l2);
            c.visitVarInsn(returnType.getOpcode(21), 2 + localVariableOffset);
            c.visitInsn(returnType.getOpcode(172));
            Label l3 = new Label();
            c.visitLabel(l3);
            c.visitVarInsn(58, 1 + localVariableOffset);
            c.visitJumpInsn(168, l1);
            c.visitVarInsn(25, 1 + localVariableOffset);
            c.visitInsn(191);
            c.visitLabel(l1);
            c.visitVarInsn(58, 0 + localVariableOffset);
            this.callTCCommit(access, name, desc, locks, c, localBooleanVariables);
            c.visitVarInsn(169, 0 + localVariableOffset);
            c.visitTryCatchBlock(l0, l2, l3, null);
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private void callTCBeginWithLocks(int access, String name, String desc, LockDefinition[] locks, MethodVisitor c, int[] localBooleanVariables) {
        this.physicalClassLogger.logCallTCBeginWithLocksStart(access, name, desc, locks, c);
        for (int i = 0; i < locks.length; ++i) {
            LockDefinition lock = locks[i];
            if (lock.isAutolock() && this.spec.isClassPortable()) {
                this.physicalClassLogger.logCallTCBeginWithLocksAutolock();
                if (Modifier.isSynchronized(access) && !Modifier.isStatic(access)) {
                    this.physicalClassLogger.logCallTCBeginWithLocksAutolockSynchronized(name, desc);
                    this.callTCMonitorEnter(access, locks[i], c);
                } else {
                    this.physicalClassLogger.logCallTCBeginWithLocksAutolockNotSynchronized(name, desc);
                }
            } else if (!lock.isAutolock()) {
                this.physicalClassLogger.logCallTCBeginWithLocksNoAutolock(lock);
                this.callTCBeginWithLock(lock, c);
            }
            if (locks.length <= 1) continue;
            c.visitInsn(4);
            c.visitVarInsn(54, localBooleanVariables[i]);
        }
    }

    private void callTCCommit(int access, String name, String desc, LockDefinition[] locks, MethodVisitor c, int[] localBooleanVariables) {
        this.physicalClassLogger.logCallTCCommitBegin(access, name, desc, locks, c);
        Label returnLabel = new Label();
        for (int i = 0; i < locks.length; ++i) {
            LockDefinition lock;
            if (locks.length > 1) {
                c.visitVarInsn(21, localBooleanVariables[i]);
                c.visitJumpInsn(153, returnLabel);
            }
            if ((lock = locks[i]).isAutolock() && this.spec.isClassPortable()) {
                if (!Modifier.isSynchronized(access) || Modifier.isStatic(access)) continue;
                this.callTCMonitorExit(access, lock, c);
                continue;
            }
            if (lock.isAutolock()) continue;
            c.visitLdcInsn(ByteCodeUtil.generateNamedLockName(lock.getLockName()));
            c.visitLdcInsn(new Integer(lock.getLockLevelAsInt()));
            c.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "commitLock", "(Ljava/lang/String;I)V");
        }
        c.visitLabel(returnLabel);
    }

    private void callTCCommitWithLockName(String lockName, int type, MethodVisitor mv) {
        mv.visitLdcInsn(lockName);
        mv.visitLdcInsn(new Integer(type));
        mv.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "commitLock", "(Ljava/lang/String;I)V");
    }

    private void callTCBeginWithLock(LockDefinition lock, MethodVisitor c) {
        c.visitLdcInsn(ByteCodeUtil.generateNamedLockName(lock.getLockName()));
        c.visitLdcInsn(new Integer(lock.getLockLevelAsInt()));
        c.visitLdcInsn(lock.getLockContextInfo());
        c.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "beginLock", "(Ljava/lang/String;ILjava/lang/String;)V");
    }

    private void callTCBeginWithLockName(String lockName, int lockLevel, MethodVisitor mv) {
        mv.visitLdcInsn(lockName);
        mv.visitLdcInsn(new Integer(lockLevel));
        mv.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "beginLock", "(Ljava/lang/String;I)V");
    }

    private void callVolatileBegin(String fieldName, int lockLevel, MethodVisitor mv) {
        this.getManaged(mv);
        mv.visitLdcInsn(fieldName);
        mv.visitIntInsn(16, lockLevel);
        mv.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "beginVolatile", "(Lcom/tc/object/TCObject;Ljava/lang/String;I)V");
    }

    private void callVolatileCommit(String fieldName, int lockLevel, MethodVisitor mv) {
        this.getManaged(mv);
        mv.visitLdcInsn(fieldName);
        mv.visitIntInsn(16, lockLevel);
        mv.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "commitVolatile", "(Lcom/tc/object/TCObject;Ljava/lang/String;I)V");
    }

    private void createPlainGetter(int methodAccess, int fieldAccess, String name, String desc) {
        boolean isVolatile = this.isVolatile(fieldAccess, name);
        String gDesc = "()" + desc;
        MethodVisitor gv = this.visitMethod(methodAccess, ByteCodeUtil.fieldGetterMethod(name), gDesc, null, null);
        Type t = Type.getType(desc);
        Label l4 = new Label();
        if (isVolatile) {
            this.getManaged(gv);
            gv.visitInsn(89);
            gv.visitVarInsn(58, 2);
            gv.visitJumpInsn(198, l4);
            Label l0 = new Label();
            Label l1 = new Label();
            Label l2 = new Label();
            gv.visitTryCatchBlock(l0, l1, l2, null);
            gv.visitLabel(l0);
            this.callVolatileBegin(this.spec.getClassNameDots() + "." + name, LockLevel.READ.toInt(), gv);
            Label l6 = new Label();
            gv.visitJumpInsn(168, l6);
            gv.visitLabel(l1);
            ByteCodeUtil.pushThis(gv);
            gv.visitFieldInsn(180, this.spec.getClassNameSlashes(), name, desc);
            gv.visitInsn(t.getOpcode(172));
            gv.visitLabel(l2);
            gv.visitVarInsn(58, 2);
            gv.visitJumpInsn(168, l6);
            gv.visitVarInsn(25, 2);
            gv.visitInsn(191);
            gv.visitLabel(l6);
            gv.visitVarInsn(58, 1);
            this.callVolatileCommit(this.spec.getClassNameDots() + "." + name, LockLevel.READ.toInt(), gv);
            gv.visitVarInsn(169, 1);
        }
        gv.visitLabel(l4);
        ByteCodeUtil.pushThis(gv);
        gv.visitFieldInsn(180, this.spec.getClassNameSlashes(), name, desc);
        gv.visitInsn(t.getOpcode(172));
        gv.visitMaxs(0, 0);
        gv.visitEnd();
    }

    private void checkReturnObjectType(String fieldName, String rootName, String targetType, int loadVariableNumber, Label matchLabel, MethodVisitor mv) {
        mv.visitVarInsn(25, loadVariableNumber);
        mv.visitTypeInsn(193, targetType);
        mv.visitJumpInsn(154, matchLabel);
        mv.visitTypeInsn(187, "java/lang/ClassCastException");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/lang/StringBuffer");
        mv.visitInsn(89);
        mv.visitLdcInsn("The field '");
        mv.visitMethodInsn(183, "java/lang/StringBuffer", "<init>", "(Ljava/lang/String;)V");
        mv.visitLdcInsn(fieldName);
        mv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        mv.visitLdcInsn("' with root name '");
        mv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        mv.visitLdcInsn(rootName);
        mv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        mv.visitLdcInsn("' cannot be assigned to a variable of type ");
        mv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        mv.visitLdcInsn(targetType);
        mv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        mv.visitLdcInsn(". This root has a type ");
        mv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        mv.visitVarInsn(25, loadVariableNumber);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        mv.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        mv.visitLdcInsn(". ");
        mv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        mv.visitLdcInsn("Perhaps you have the same root name assigned more than once to variables of different types.");
        mv.visitMethodInsn(182, "java/lang/StringBuffer", "append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        mv.visitMethodInsn(182, "java/lang/StringBuffer", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(183, "java/lang/ClassCastException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
    }

    private void createRootGetter(int methodAccess, String name, String desc) {
        Type t = Type.getType(desc);
        boolean isPrimitive = this.isPrimitive(t);
        boolean isDSOFinal = this.isRootDSOFinal(name);
        String rootName = this.rootNameFor(this.spec.getClassNameSlashes(), name);
        String targetType = isPrimitive ? ByteCodeUtil.sortToWrapperName(t.getSort()) : this.convertToCheckCastDesc(desc);
        boolean isStatic = Modifier.isStatic(methodAccess);
        Label l1 = new Label();
        Label l3 = new Label();
        Label l5 = new Label();
        Label l6 = new Label();
        Label l7 = new Label();
        Label l8 = new Label();
        try {
            MethodVisitor mv = this.cv.visitMethod(methodAccess, ByteCodeUtil.fieldGetterMethod(name), "()" + desc, null, null);
            if (isDSOFinal) {
                this.callGetFieldInsn(isStatic, name, desc, mv);
                if (isPrimitive) {
                    this.addPrimitiveTypeZeroCompare(mv, t, l1);
                } else {
                    mv.visitJumpInsn(199, l1);
                }
            }
            this.callTCBeginWithLockName(rootName, LockLevel.WRITE.toInt(), mv);
            mv.visitLabel(l3);
            mv.visitLdcInsn(rootName);
            mv.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "lookupRoot", "(Ljava/lang/String;)Ljava/lang/Object;");
            mv.visitVarInsn(58, 1);
            mv.visitVarInsn(25, 1);
            mv.visitJumpInsn(198, l5);
            this.checkReturnObjectType(name, rootName, targetType, 1, l6, mv);
            mv.visitLabel(l6);
            this.callPutFieldInsn(isStatic, t, 1, name, desc, mv);
            mv.visitJumpInsn(167, l5);
            mv.visitLabel(l7);
            mv.visitVarInsn(58, 3);
            mv.visitJumpInsn(168, l8);
            mv.visitVarInsn(25, 3);
            mv.visitInsn(191);
            mv.visitLabel(l8);
            mv.visitVarInsn(58, 2);
            this.callTCCommitWithLockName(rootName, LockLevel.WRITE.toInt(), mv);
            mv.visitVarInsn(169, 2);
            mv.visitLabel(l5);
            mv.visitJumpInsn(168, l8);
            mv.visitLabel(l1);
            this.callGetFieldInsn(isStatic, name, desc, mv);
            mv.visitInsn(t.getOpcode(172));
            mv.visitTryCatchBlock(l3, l7, l7, null);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private boolean isVolatile(int access, String fieldName) {
        return this.getTransparencyClassSpec().isVolatile(access, this.spec.getClassInfo(), fieldName);
    }

    private void createInstrumentedGetter(int methodAccess, int fieldAccess, String name, String desc) {
        Assert.eval(!this.getTransparencyClassSpec().isLogical());
        MethodVisitor gv = this.visitMethod(methodAccess, ByteCodeUtil.fieldGetterMethod(name), "()" + desc, null, null);
        if (useFastFinalFields && Modifier.isFinal(fieldAccess)) {
            this.createInstrumentedFinalGetter(gv, fieldAccess, name, desc);
        } else {
            this.createInstrumentedNonFinalGetter(gv, fieldAccess, name, desc);
        }
    }

    private void createInstrumentedNonFinalGetter(MethodVisitor gv, int fieldAccess, String name, String desc) {
        try {
            boolean THIS_SLOT = false;
            int RESOLVE_LOCK_SLOT = 2;
            int TC_OBJECT_SLOT = 3;
            boolean isVolatile = this.isVolatile(fieldAccess, name);
            Type fieldType = Type.getType(desc);
            Label syncBegin = new Label();
            Label syncEnd = new Label();
            Label notManaged = new Label();
            Label resolved = new Label();
            this.getManaged(gv);
            gv.visitInsn(89);
            gv.visitVarInsn(58, 3);
            gv.visitJumpInsn(198, notManaged);
            if (isVolatile) {
                this.callVolatileBegin(this.spec.getClassNameDots() + '.' + name, LockLevel.READ.toInt(), gv);
            }
            gv.visitVarInsn(25, 3);
            gv.visitMethodInsn(185, "com/tc/object/TCObject", "getResolveLock", "()Ljava/lang/Object;");
            gv.visitInsn(89);
            gv.visitVarInsn(58, 2);
            gv.visitInsn(194);
            gv.visitLabel(syncBegin);
            gv.visitVarInsn(25, 0);
            gv.visitFieldInsn(180, this.spec.getClassNameSlashes(), name, desc);
            gv.visitJumpInsn(199, resolved);
            gv.visitVarInsn(25, 3);
            gv.visitLdcInsn(this.spec.getClassNameDots() + '.' + name);
            gv.visitMethodInsn(185, "com/tc/object/TCObject", "resolveReference", "(Ljava/lang/String;)V");
            gv.visitLabel(resolved);
            gv.visitVarInsn(25, 0);
            gv.visitFieldInsn(180, this.spec.getClassNameSlashes(), name, desc);
            gv.visitVarInsn(25, 2);
            gv.visitInsn(195);
            if (isVolatile) {
                this.callVolatileCommit(this.spec.getClassNameDots() + "." + name, LockLevel.READ.toInt(), gv);
            }
            gv.visitInsn(fieldType.getOpcode(172));
            gv.visitLabel(syncEnd);
            gv.visitVarInsn(25, 2);
            gv.visitInsn(195);
            if (isVolatile) {
                this.callVolatileCommit(this.spec.getClassNameDots() + "." + name, LockLevel.READ.toInt(), gv);
            }
            gv.visitInsn(191);
            gv.visitLabel(notManaged);
            gv.visitVarInsn(25, 0);
            gv.visitFieldInsn(180, this.spec.getClassNameSlashes(), name, desc);
            gv.visitInsn(fieldType.getOpcode(172));
            gv.visitTryCatchBlock(syncBegin, syncEnd, syncEnd, null);
            gv.visitMaxs(0, 0);
            gv.visitEnd();
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private void createInstrumentedFinalGetter(MethodVisitor gv, int fieldAccess, String name, String desc) {
        try {
            boolean THIS_SLOT = false;
            Type fieldType = Type.getType(desc);
            Label regularGet = new Label();
            gv.visitVarInsn(25, 0);
            gv.visitFieldInsn(180, this.spec.getClassNameSlashes(), name, desc);
            gv.visitInsn(89);
            gv.visitJumpInsn(198, regularGet);
            gv.visitInsn(fieldType.getOpcode(172));
            gv.visitLabel(regularGet);
            gv.visitInsn(87);
            this.createInstrumentedNonFinalGetter(gv, fieldAccess, name, desc);
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private void getManaged(MethodVisitor mv) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, this.spec.getClassNameSlashes(), "__tc_managed", "()Lcom/tc/object/TCObject;");
    }

    private void createPlainSetter(int methodAccess, int fieldAccess, String name, String desc) {
        boolean isVolatile = this.isVolatile(fieldAccess, name);
        String sDesc = "(" + desc + ")V";
        MethodVisitor scv = this.cv.visitMethod(methodAccess, ByteCodeUtil.fieldSetterMethod(name), sDesc, null, null);
        Type t = Type.getType(desc);
        Label l4 = new Label();
        if (isVolatile) {
            this.getManaged(scv);
            scv.visitInsn(89);
            scv.visitVarInsn(58, 2);
            scv.visitJumpInsn(198, l4);
            Label l0 = new Label();
            Label l1 = new Label();
            Label l2 = new Label();
            scv.visitTryCatchBlock(l0, l1, l2, null);
            scv.visitLabel(l0);
            this.callVolatileBegin(this.spec.getClassNameDots() + "." + name, LockLevel.WRITE.toInt(), scv);
            Label l6 = new Label();
            scv.visitJumpInsn(168, l6);
            scv.visitLabel(l1);
            ByteCodeUtil.pushThis(scv);
            scv.visitVarInsn(t.getOpcode(21), 1);
            scv.visitFieldInsn(181, this.spec.getClassNameSlashes(), name, desc);
            scv.visitInsn(177);
            scv.visitLabel(l2);
            scv.visitVarInsn(58, 2);
            scv.visitJumpInsn(168, l6);
            scv.visitVarInsn(25, 2);
            scv.visitInsn(191);
            scv.visitLabel(l6);
            scv.visitVarInsn(58, 1);
            this.callVolatileCommit(this.spec.getClassNameDots() + "." + name, LockLevel.WRITE.toInt(), scv);
            scv.visitVarInsn(169, 1);
        }
        scv.visitLabel(l4);
        ByteCodeUtil.pushThis(scv);
        scv.visitVarInsn(t.getOpcode(21), 1);
        scv.visitFieldInsn(181, this.spec.getClassNameSlashes(), name, desc);
        scv.visitInsn(177);
        scv.visitMaxs(0, 0);
        scv.visitEnd();
    }

    private void createInstrumentedSetter(int methodAccess, int fieldAccess, String name, String desc) {
        try {
            Type t = Type.getType(desc);
            if (this.isRoot(methodAccess, name)) {
                this.createObjectSetter(methodAccess, fieldAccess, name, desc);
            } else if (!(t.getSort() != 10 && t.getSort() != 9 || this.isPrimitive(t))) {
                this.createObjectSetter(methodAccess, fieldAccess, name, desc);
            } else {
                this.createLiteralSetter(methodAccess, fieldAccess, name, desc);
            }
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private void createObjectSetter(int methodAccess, int fieldAccess, String name, String desc) {
        try {
            if (this.isRoot(methodAccess, name)) {
                boolean isStaticRoot = Modifier.isStatic(methodAccess);
                if (this.instrumentationLogger.getRootInsertion()) {
                    this.instrumentationLogger.rootInserted(this.spec.getClassNameDots(), name, desc, isStaticRoot);
                }
                this.createRootSetter(methodAccess, name, desc, isStaticRoot);
            } else {
                this.createObjectFieldSetter(methodAccess, fieldAccess, name, desc);
            }
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private boolean isRootDSOFinal(String name) {
        return this.spec.getTransparencyClassSpec().isRootDSOFinal(this.spec.getFieldInfo(name));
    }

    private void createRootSetter(int methodAccess, String name, String desc, boolean isStatic) {
        Type t = Type.getType(desc);
        boolean isPrimitive = this.isPrimitive(t);
        boolean isDSOFinal = this.isRootDSOFinal(name);
        try {
            int rootInstance;
            String sDesc = "(" + desc + ")V";
            String targetType = isPrimitive ? ByteCodeUtil.sortToWrapperName(t.getSort()) : this.convertToCheckCastDesc(desc);
            MethodVisitor scv = this.cv.visitMethod(methodAccess, ByteCodeUtil.fieldSetterMethod(name), sDesc, null, null);
            Label tryStart = new Label();
            Label end = new Label();
            Label normalExit = new Label();
            Label finallyStart = new Label();
            Label exceptionHandler = new Label();
            int n = rootInstance = isStatic ? 0 : 1;
            if (!isPrimitive) {
                scv.visitVarInsn(25, rootInstance);
                scv.visitJumpInsn(198, end);
            }
            String rootName = this.rootNameFor(this.spec.getClassNameSlashes(), name);
            this.callTCBeginWithLockName(rootName, LockLevel.WRITE.toInt(), scv);
            scv.visitLabel(tryStart);
            scv.visitLdcInsn(rootName);
            if (isPrimitive) {
                ByteCodeUtil.addTypeSpecificParameterLoad(scv, t, rootInstance);
            } else {
                scv.visitVarInsn(25, rootInstance);
            }
            if (isDSOFinal) {
                scv.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "lookupOrCreateRoot", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
            } else {
                scv.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "createOrReplaceRoot", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
            }
            int localVar = rootInstance + 1;
            scv.visitVarInsn(58, localVar);
            Label l0 = new Label();
            this.checkReturnObjectType(name, rootName, targetType, localVar, l0, scv);
            scv.visitLabel(l0);
            this.callPutFieldInsn(isStatic, t, localVar, name, desc, scv);
            scv.visitJumpInsn(167, normalExit);
            scv.visitLabel(exceptionHandler);
            scv.visitVarInsn(58, 3);
            scv.visitJumpInsn(168, finallyStart);
            scv.visitVarInsn(25, 3);
            scv.visitInsn(191);
            scv.visitLabel(finallyStart);
            scv.visitVarInsn(58, 2);
            this.callTCCommitWithLockName(rootName, LockLevel.WRITE.toInt(), scv);
            scv.visitVarInsn(169, 2);
            scv.visitLabel(normalExit);
            scv.visitJumpInsn(168, finallyStart);
            scv.visitLabel(end);
            scv.visitInsn(177);
            scv.visitTryCatchBlock(tryStart, exceptionHandler, exceptionHandler, null);
            scv.visitMaxs(0, 0);
            scv.visitEnd();
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private void callGetFieldInsn(boolean isStatic, String name, String desc, MethodVisitor mv) {
        int getInsn;
        int n = getInsn = isStatic ? 178 : 180;
        if (!isStatic) {
            ByteCodeUtil.pushThis(mv);
        }
        mv.visitFieldInsn(getInsn, this.spec.getClassNameSlashes(), name, desc);
    }

    private void callPutFieldInsn(boolean isStatic, Type targetType, int localVar, String name, String desc, MethodVisitor mv) {
        int putInsn;
        int n = putInsn = isStatic ? 179 : 181;
        if (!isStatic) {
            ByteCodeUtil.pushThis(mv);
        }
        mv.visitVarInsn(25, localVar);
        if (this.isPrimitive(targetType)) {
            mv.visitTypeInsn(192, ByteCodeUtil.sortToWrapperName(targetType.getSort()));
            mv.visitMethodInsn(182, ByteCodeUtil.sortToWrapperName(targetType.getSort()), ByteCodeUtil.sortToPrimitiveMethodName(targetType.getSort()), "()" + desc);
        } else {
            mv.visitTypeInsn(192, this.convertToCheckCastDesc(desc));
        }
        mv.visitFieldInsn(putInsn, this.spec.getClassNameSlashes(), name, desc);
    }

    private void generateCodeForVolatileTransactionBegin(Label l1, Label l2, Label l3, Label l4, String fieldName, int lockLevel, MethodVisitor scv) {
        scv.visitTryCatchBlock(l4, l1, l1, null);
        scv.visitTryCatchBlock(l2, l3, l1, null);
        scv.visitLabel(l4);
        this.callVolatileBegin(fieldName, lockLevel, scv);
    }

    private void generateCodeForVolativeTransactionCommit(Label l1, Label l2, MethodVisitor scv, int newVar1, int newVar2, String fieldName, int lockLevel) {
        scv.visitJumpInsn(167, l2);
        scv.visitLabel(l1);
        scv.visitVarInsn(58, newVar2);
        Label l5 = new Label();
        scv.visitJumpInsn(168, l5);
        scv.visitVarInsn(25, newVar2);
        scv.visitInsn(191);
        scv.visitLabel(l5);
        scv.visitVarInsn(58, newVar1);
        this.callVolatileCommit(fieldName, lockLevel, scv);
        scv.visitVarInsn(169, newVar1);
        scv.visitLabel(l2);
        scv.visitJumpInsn(168, l5);
    }

    private boolean isInjected(String fieldName) {
        return this.getTransparencyClassSpec().isInjectedField(fieldName);
    }

    private void createObjectFieldSetter(int methodAccess, int fieldAccess, String name, String desc) {
        try {
            boolean isVolatile = this.isVolatile(fieldAccess, name);
            Label l1 = new Label();
            Label l2 = new Label();
            Label l4 = new Label();
            String sDesc = "(" + desc + ")V";
            MethodVisitor scv = this.cv.visitMethod(methodAccess, ByteCodeUtil.fieldSetterMethod(name), sDesc, null, null);
            this.getManaged(scv);
            scv.visitInsn(89);
            scv.visitVarInsn(58, 2);
            Label labelMethodEnd = new Label();
            Label labelFieldNotYetInjected = new Label();
            if (this.isInjected(name)) {
                scv.visitVarInsn(25, 0);
                scv.visitFieldInsn(180, this.spec.getClassNameSlashes(), name, desc);
                scv.visitJumpInsn(198, labelFieldNotYetInjected);
                scv.visitInsn(87);
                scv.visitJumpInsn(167, labelMethodEnd);
                scv.visitLabel(labelFieldNotYetInjected);
            }
            Label labelArgumentIsNull = new Label();
            scv.visitJumpInsn(198, labelArgumentIsNull);
            if (isVolatile) {
                this.generateCodeForVolatileTransactionBegin(l1, l2, labelArgumentIsNull, l4, this.spec.getClassNameDots() + "." + name, LockLevel.WRITE.toInt(), scv);
            }
            scv.visitVarInsn(25, 2);
            scv.visitLdcInsn(this.spec.getClassNameDots());
            scv.visitLdcInsn(this.spec.getClassNameDots() + "." + name);
            scv.visitVarInsn(25, 1);
            scv.visitInsn(2);
            scv.visitMethodInsn(185, "com/tc/object/TCObject", "objectFieldChanged", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;I)V");
            if (isVolatile) {
                this.generateCodeForVolativeTransactionCommit(l1, l2, scv, 3, 4, this.spec.getClassNameDots() + "." + name, LockLevel.WRITE.toInt());
            }
            scv.visitLabel(labelArgumentIsNull);
            scv.visitVarInsn(25, 0);
            scv.visitVarInsn(25, 1);
            scv.visitFieldInsn(181, this.spec.getClassNameSlashes(), name, desc);
            scv.visitLabel(labelMethodEnd);
            scv.visitInsn(177);
            scv.visitMaxs(0, 0);
            scv.visitEnd();
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private void createLiteralSetter(int methodAccess, int fieldAccess, String name, String desc) {
        try {
            boolean isVolatile = this.isVolatile(fieldAccess, name);
            Label l1 = new Label();
            Label l2 = new Label();
            Label l4 = new Label();
            String sDesc = "(" + desc + ")V";
            Type t = Type.getType(desc);
            MethodVisitor mv = this.cv.visitMethod(methodAccess, ByteCodeUtil.fieldSetterMethod(name), sDesc, null, null);
            this.getManaged(mv);
            mv.visitInsn(89);
            mv.visitVarInsn(58, 1 + t.getSize());
            Label l0 = new Label();
            mv.visitJumpInsn(198, l0);
            if (isVolatile) {
                this.generateCodeForVolatileTransactionBegin(l1, l2, l0, l4, this.spec.getClassNameDots() + "." + name, LockLevel.WRITE.toInt(), mv);
            }
            mv.visitVarInsn(25, 1 + t.getSize());
            mv.visitLdcInsn(this.spec.getClassNameDots());
            mv.visitLdcInsn(this.spec.getClassNameDots() + "." + name);
            mv.visitVarInsn(t.getOpcode(21), 1);
            mv.visitInsn(2);
            String method = ByteCodeUtil.codeToName(desc) + "FieldChanged";
            mv.visitMethodInsn(185, "com/tc/object/TCObject", method, "(Ljava/lang/String;Ljava/lang/String;" + desc + "I)V");
            if (isVolatile) {
                this.generateCodeForVolativeTransactionCommit(l1, l2, mv, 2 + t.getSize(), 3 + t.getSize(), this.spec.getClassNameDots() + "." + name, LockLevel.WRITE.toInt());
            }
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(t.getOpcode(21), 1);
            mv.visitFieldInsn(181, this.spec.getClassNameSlashes(), name, desc);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        catch (RuntimeException e) {
            this.handleInstrumentationException(e);
        }
        catch (Error e) {
            this.handleInstrumentationException(e);
            throw e;
        }
    }

    private void callTCMonitorExit(int callingMethodModifier, LockDefinition def, MethodVisitor c) {
        Assert.eval("Can't call tc monitorenter from a static method.", !Modifier.isStatic(callingMethodModifier));
        ByteCodeUtil.pushThis(c);
        c.visitLdcInsn(new Integer(def.getLockLevelAsInt()));
        c.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "instrumentationMonitorExit", "(Ljava/lang/Object;I)V");
    }

    private void callTCMonitorEnter(int callingMethodModifier, LockDefinition def, MethodVisitor c) {
        Assert.eval("Can't call tc monitorexit from a static method.", !Modifier.isStatic(callingMethodModifier));
        ByteCodeUtil.pushThis(c);
        c.visitLdcInsn(new Integer(def.getLockLevelAsInt()));
        c.visitMethodInsn(184, "com/tc/object/bytecode/ManagerUtil", "instrumentationMonitorEnter", "(Ljava/lang/Object;I)V");
    }

    private void addPrimitiveTypeZeroCompare(MethodVisitor mv, Type type, Label notZeroLabel) {
        switch (type.getSort()) {
            case 7: {
                mv.visitInsn(9);
                mv.visitInsn(148);
                mv.visitJumpInsn(154, notZeroLabel);
                break;
            }
            case 8: {
                mv.visitInsn(14);
                mv.visitInsn(151);
                mv.visitJumpInsn(154, notZeroLabel);
                break;
            }
            case 6: {
                mv.visitInsn(11);
                mv.visitInsn(149);
                mv.visitJumpInsn(154, notZeroLabel);
                break;
            }
            default: {
                mv.visitJumpInsn(154, notZeroLabel);
            }
        }
    }
}

