/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode;

import com.tc.asm.MethodVisitor;
import com.tc.logging.TCLogger;
import com.tc.object.config.LockDefinition;
import org.apache.commons.lang.ArrayUtils;

public class PhysicalClassAdapterLogger {
    private final TCLogger logger;

    PhysicalClassAdapterLogger(TCLogger l) {
        this.logger = l;
    }

    void logVisitMethodCreateLockMethod(String name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Creating lock:" + name);
        }
    }

    void logVisitMethodNotALockMethod(int access, String ownerClass, String name, String desc, String[] exceptions) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("visitMethod(): Not a lock method: " + access + " " + ownerClass + "." + name + desc + " " + this.arrayToString(exceptions));
        }
    }

    void logVisitMethodBegin(int access, String name, String signature, String desc, String[] exceptions) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("visitMethod(" + access + ", " + name + ", " + desc + ", " + this.arrayToString(exceptions) + ", " + signature + ")");
        }
    }

    void logVisitMethodIgnoring(String name, String desc) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignoring:" + name + " desc:" + desc);
        }
    }

    void logVisitMethodCheckIsLockMethod() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Checking isLockMethod()");
        }
    }

    void logCallTCBeginWithLocksStart(int access, String name, String desc, LockDefinition[] locks, MethodVisitor c) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callTCBeginWithLocks(access=" + access + ", name=" + name + ", desc=" + desc + ", locks=" + this.arrayToString(locks) + ", c= " + c + ")");
        }
    }

    void logCallTCBeginWithLocksAutolock() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callTCBeginWithLocks(): lock is autolock.");
        }
    }

    void logCallTCBeginWithLocksAutolockSynchronized(String name, String desc) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callTCBeginWithLocks(): method is synchronized, calling __tcmonitorenter() for method " + name + "." + desc);
        }
    }

    void logCallTCBeginWithLocksAutolockNotSynchronized(String name, String desc) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callTCBeginWithLocks(): method is not synchronized, ignoring autolock for method " + name + "." + desc);
        }
    }

    void logCallTCBeginWithLocksNoAutolock(LockDefinition lock) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("calling callTCBeginWithLock() for lock " + lock);
        }
    }

    void logCreateLockMethodBegin(int access, String name, String signature, String desc, String[] exceptions, LockDefinition[] locks) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("createLockMethod(access=" + access + ", name=" + name + ", desc=" + desc + ", exceptions=" + this.arrayToString(exceptions) + ", " + signature + ", " + this.arrayToString(locks) + ")");
        }
    }

    void logCreateLockMethodVoidBegin(int access, String name, String signature, String desc, String[] exceptions, LockDefinition[] locks) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("createLockMethodVoid(access=" + access + ", name=" + name + ", desc=" + desc + ", exceptions=" + this.arrayToString(exceptions) + ", sig=" + signature + ", locks=" + this.arrayToString(locks));
        }
    }

    void logCallTCCommitBegin(int access, String name, String desc, LockDefinition[] locks, MethodVisitor c) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("callTCCommit(access=" + access + ", name=" + name + ", desc=" + desc + ", locks=" + this.arrayToString(locks) + ", c=" + c + ")");
        }
    }

    void logCreateLockMethodReturnBegin(int access, String name, String signature, String desc, String[] exceptions, LockDefinition[] locks) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("createLockMethodReturn(access=" + access + ", name=" + name + ", desc=" + desc + ", exceptions=" + this.arrayToString(exceptions) + ", signature=" + signature + ", locks=" + this.arrayToString(locks) + ")");
        }
    }

    private String arrayToString(Object obj) {
        return obj == null ? "null" : ArrayUtils.toString((Object)obj);
    }
}

