/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode;

import com.tc.exception.TCClassNotFoundException;
import com.tc.logging.TCLogger;
import com.tc.management.beans.sessions.SessionMonitor;
import com.tc.object.ObjectID;
import com.tc.object.TCObject;
import com.tc.object.bytecode.Manager;
import com.tc.object.bytecode.NullManager;
import com.tc.object.bytecode.OverridesHashCode;
import com.tc.object.bytecode.hook.impl.ArrayManager;
import com.tc.object.bytecode.hook.impl.ClassProcessorHelper;
import com.tc.object.loaders.NamedClassLoader;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockLevel;
import com.tc.properties.TCProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Date;

public class ManagerUtil {
    public static final String CLASS = "com/tc/object/bytecode/ManagerUtil";
    public static final String TYPE = "Lcom/tc/object/bytecode/ManagerUtil;";
    private static final Manager NULL_MANAGER = NullManager.getInstance();
    private static volatile boolean ENABLED = false;
    private static String SINGLETON_INIT_INFO;
    private static volatile Manager SINGLETON;

    public static void enable() {
        ENABLED = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableSingleton(Manager singleton) {
        if (ClassProcessorHelper.USE_GLOBAL_CONTEXT) {
            throw new AssertionError((Object)"global mode");
        }
        if (singleton == null) {
            throw new NullPointerException("null singleton");
        }
        Class<ManagerUtil> clazz = ManagerUtil.class;
        synchronized (ManagerUtil.class) {
            if (SINGLETON != null) {
                throw new IllegalStateException(SINGLETON_INIT_INFO);
            }
            SINGLETON = singleton;
            SINGLETON_INIT_INFO = ManagerUtil.captureInitInfo();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ManagerUtil.enable();
            return;
        }
    }

    private static String captureInitInfo() {
        StringWriter sw = new StringWriter();
        sw.append("The singleton instance was initialized at " + new Date() + " by thread [" + Thread.currentThread().getName() + "] with stack:\n");
        PrintWriter pw = new PrintWriter(sw);
        new Throwable().printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static Manager getManager() {
        if (!ENABLED) {
            return NULL_MANAGER;
        }
        if (ClassProcessorHelper.USE_GLOBAL_CONTEXT) {
            return GlobalManagerHolder.instance;
        }
        Manager rv = SINGLETON;
        if (rv != null) {
            return rv;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        rv = ClassProcessorHelper.getManager(loader);
        if (rv == null) {
            return NULL_MANAGER;
        }
        return rv;
    }

    public static TCLogger getLogger(String loggerName) {
        return ManagerUtil.getManager().getLogger(loggerName);
    }

    public static boolean isPhysicallyInstrumented(Class clazz) {
        return ManagerUtil.getManager().isPhysicallyInstrumented(clazz);
    }

    public static String getClientID() {
        return ManagerUtil.getManager().getClientID();
    }

    public static String getUUID() {
        return ManagerUtil.getManager().getUUID();
    }

    public static Object lookupOrCreateRoot(String name, Object object) {
        return ManagerUtil.getManager().lookupOrCreateRoot(name, object);
    }

    public static Object lookupOrCreateRootNoDepth(String name, Object obj) {
        return ManagerUtil.getManager().lookupOrCreateRootNoDepth(name, obj);
    }

    public static Object createOrReplaceRoot(String rootName, Object object) {
        return ManagerUtil.getManager().createOrReplaceRoot(rootName, object);
    }

    public static void beginVolatile(Object pojo, long fieldOffset, int type) {
        TCObject tcObject = ManagerUtil.lookupExistingOrNull(pojo);
        ManagerUtil.beginVolatile(tcObject, tcObject.getFieldNameByOffset(fieldOffset), type);
    }

    public static void commitVolatile(Object pojo, long fieldOffset, int type) {
        TCObject tcObject = ManagerUtil.lookupExistingOrNull(pojo);
        ManagerUtil.commitVolatile(tcObject, tcObject.getFieldNameByOffset(fieldOffset), type);
    }

    public static void beginVolatile(TCObject tcObject, String fieldName, int type) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(tcObject, fieldName);
        mgr.lock(lock, LockLevel.fromInt(type));
    }

    public static void beginLock(String lockID, int type) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(lockID);
        mgr.lock(lock, LockLevel.fromInt(type));
    }

    @Deprecated
    public static void beginLockWithoutTxn(String lockID, int type) {
        ManagerUtil.beginLock(lockID, type);
    }

    @Deprecated
    public static void beginLock(String lockID, int type, String contextInfo) {
        ManagerUtil.beginLock(lockID, type);
    }

    public static boolean tryBeginLock(String lockID, int type) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(lockID);
        return mgr.tryLock(lock, LockLevel.fromInt(type));
    }

    public static boolean tryBeginLock(String lockID, int type, long timeoutInNanos) throws InterruptedException {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(lockID);
        return mgr.tryLock(lock, LockLevel.fromInt(type), timeoutInNanos / 1000000L);
    }

    public static void commitVolatile(TCObject tcObject, String fieldName, int type) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(tcObject, fieldName);
        mgr.unlock(lock, LockLevel.fromInt(type));
    }

    public static void commitLock(String lockID, int type) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(lockID);
        mgr.unlock(lock, LockLevel.fromInt(type));
    }

    public static void pinLock(String lockID) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(lockID);
        mgr.pinLock(lock);
    }

    public static void unpinLock(String lockID) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(lockID);
        mgr.unpinLock(lock);
    }

    public static TCObject lookupExistingOrNull(Object pojo) {
        return ManagerUtil.getManager().lookupExistingOrNull(pojo);
    }

    public static void logicalInvoke(Object object, String methodName, Object[] params) {
        ManagerUtil.getManager().logicalInvoke(object, methodName, params);
    }

    public static void logicalInvokeWithTransaction(Object object, Object lockObject, String methodName, Object[] params) {
        ManagerUtil.getManager().logicalInvokeWithTransaction(object, lockObject, methodName, params);
    }

    public static void distributedMethodCallCommit() {
        ManagerUtil.getManager().distributedMethodCallCommit();
    }

    public static boolean prunedDistributedMethodCall(Object receiver, String method, Object[] params) {
        return ManagerUtil.getManager().distributedMethodCall(receiver, method, params, false);
    }

    public static boolean distributedMethodCall(Object receiver, String method, Object[] params) {
        return ManagerUtil.getManager().distributedMethodCall(receiver, method, params, true);
    }

    public static Object lookupRoot(String name) {
        return ManagerUtil.getManager().lookupRoot(name);
    }

    public static Object lookupObject(ObjectID id) {
        try {
            return ManagerUtil.getManager().lookupObject(id);
        }
        catch (ClassNotFoundException e) {
            throw new TCClassNotFoundException(e);
        }
    }

    public static void preFetchObject(ObjectID id) {
        ManagerUtil.getManager().preFetchObject(id);
    }

    public static Object lookupObjectWithParentContext(ObjectID id, ObjectID parentContext) {
        try {
            return ManagerUtil.getManager().lookupObject(id, parentContext);
        }
        catch (ClassNotFoundException e) {
            throw new TCClassNotFoundException(e);
        }
    }

    public static TCObject lookupOrCreate(Object obj) {
        return ManagerUtil.getManager().lookupOrCreate(obj);
    }

    public static void checkWriteAccess(Object context) {
        ManagerUtil.getManager().checkWriteAccess(context);
    }

    public static boolean isManaged(Object obj) {
        return ManagerUtil.getManager().isManaged(obj);
    }

    public static boolean isDsoMonitored(Object obj) {
        return ManagerUtil.getManager().isDsoMonitored(obj);
    }

    public static boolean isDsoMonitorEntered(Object obj) {
        return ManagerUtil.getManager().isDsoMonitorEntered(obj);
    }

    public static boolean isLogical(Object obj) {
        return ManagerUtil.getManager().isLogical(obj);
    }

    public static boolean isRoot(Field field) {
        return ManagerUtil.getManager().isRoot(field);
    }

    public static void objectNotify(Object obj) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        mgr.notify(lock, obj);
    }

    public static void objectNotifyAll(Object obj) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        mgr.notifyAll(lock, obj);
    }

    public static void objectWait(Object obj) throws InterruptedException {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        mgr.wait(lock, obj);
    }

    public static void objectWait(Object obj, long millis) throws InterruptedException {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        mgr.wait(lock, obj, millis);
    }

    public static void objectWait(Object obj, long millis, int nanos) throws InterruptedException {
        if (nanos >= 500000 || nanos != 0 && millis == 0L) {
            ++millis;
        }
        ManagerUtil.objectWait(obj, millis);
    }

    public static void monitorEnter(Object obj, int type) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        mgr.lock(lock, LockLevel.fromInt(type));
    }

    @Deprecated
    public static void monitorEnter(Object obj, int type, String contextInfo) {
        ManagerUtil.monitorEnter(obj, type);
    }

    public static void monitorExit(Object obj, int type) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        mgr.unlock(lock, LockLevel.fromInt(type));
    }

    @Deprecated
    public static void instrumentationMonitorEnter(Object obj, int type) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        mgr.monitorEnter(lock, LockLevel.fromInt(type));
    }

    @Deprecated
    public static void instrumentationMonitorExit(Object obj, int type) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        mgr.monitorExit(lock, LockLevel.fromInt(type));
    }

    public static boolean isLiteralInstance(Object obj) {
        return ManagerUtil.getManager().isLiteralInstance(obj);
    }

    public static int calculateDsoHashCode(Object obj) {
        return ManagerUtil.getManager().calculateDsoHashCode(obj);
    }

    public static boolean isLocked(Object obj, int lockLevel) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        return mgr.isLocked(lock, LockLevel.fromInt(lockLevel));
    }

    public static boolean tryMonitorEnter(Object obj, int type) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        return mgr.tryLock(lock, LockLevel.fromInt(type));
    }

    public static boolean tryMonitorEnter(Object obj, int type, long timeoutInNanos) throws InterruptedException {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        return mgr.tryLock(lock, LockLevel.fromInt(type), timeoutInNanos / 1000000L);
    }

    public static void monitorEnterInterruptibly(Object obj, int type) throws InterruptedException {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        mgr.lockInterruptibly(lock, LockLevel.fromInt(type));
    }

    public static int localHeldCount(Object obj, int lockLevel) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        return mgr.localHoldCount(lock, LockLevel.fromInt(lockLevel));
    }

    public static boolean isHeldByCurrentThread(Object obj, int lockLevel) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        return mgr.isLockedByCurrentThread(lock, LockLevel.fromInt(lockLevel));
    }

    public static boolean isLockHeldByCurrentThread(String lockId, int lockLevel) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(lockId);
        return mgr.isLockedByCurrentThread(lock, LockLevel.fromInt(lockLevel));
    }

    public static int queueLength(Object obj) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        return mgr.globalPendingCount(lock);
    }

    public static int waitLength(Object obj) {
        Manager mgr = ManagerUtil.getManager();
        LockID lock = mgr.generateLockIdentifier(obj);
        return mgr.globalWaitingCount(lock);
    }

    private ManagerUtil() {
    }

    public static Object get(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return ArrayManager.get(array, index);
    }

    public static void setImpl(Object array, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        ManagerUtil.set(array, index, value);
    }

    public static void set(Object array, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array instanceof Object[]) {
            Class<?> componentType = array.getClass().getComponentType();
            if (value != null && !componentType.isInstance(value)) {
                throw new IllegalArgumentException("Cannot assign an instance of type " + value.getClass().getName() + " to array with component type " + componentType.getName());
            }
            ArrayManager.objectArrayChanged((Object[])array, index, value);
        } else if (value instanceof Byte) {
            ManagerUtil.setByte(array, index, (Byte)value);
        } else if (value instanceof Short) {
            ManagerUtil.setShort(array, index, (Short)value);
        } else if (value instanceof Integer) {
            ManagerUtil.setInt(array, index, (Integer)value);
        } else if (value instanceof Long) {
            ManagerUtil.setLong(array, index, (Long)value);
        } else if (value instanceof Float) {
            ManagerUtil.setFloat(array, index, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            ManagerUtil.setDouble(array, index, (Double)value);
        } else if (value instanceof Character) {
            ManagerUtil.setChar(array, index, ((Character)value).charValue());
        } else if (value instanceof Boolean) {
            ManagerUtil.setBoolean(array, index, (Boolean)value);
        } else {
            throw new IllegalArgumentException("Not an array type: " + array.getClass().getName());
        }
    }

    public static void setBoolean(Object array, int index, boolean z) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array == null) {
            throw new NullPointerException();
        }
        if (!(array instanceof boolean[])) {
            throw new IllegalArgumentException();
        }
        byte b = z ? (byte)1 : 0;
        ArrayManager.byteOrBooleanArrayChanged(array, index, b);
    }

    public static void setByte(Object array, int index, byte b) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array instanceof byte[]) {
            ArrayManager.byteOrBooleanArrayChanged(array, index, b);
        } else {
            ManagerUtil.setShort(array, index, b);
        }
    }

    public static void setChar(Object array, int index, char c) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array instanceof char[]) {
            ArrayManager.charArrayChanged((char[])array, index, c);
        } else {
            ManagerUtil.setInt(array, index, c);
        }
    }

    public static void setShort(Object array, int index, short s) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array instanceof short[]) {
            ArrayManager.shortArrayChanged((short[])array, index, s);
        } else {
            ManagerUtil.setInt(array, index, s);
        }
    }

    public static void setInt(Object array, int index, int i) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array instanceof int[]) {
            ArrayManager.intArrayChanged((int[])array, index, i);
        } else {
            ManagerUtil.setLong(array, index, i);
        }
    }

    public static void setLong(Object array, int index, long l) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array instanceof long[]) {
            ArrayManager.longArrayChanged((long[])array, index, l);
        } else {
            ManagerUtil.setFloat(array, index, l);
        }
    }

    public static void setFloat(Object array, int index, float f) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array == null) {
            throw new NullPointerException();
        }
        if (array instanceof float[]) {
            ArrayManager.floatArrayChanged((float[])array, index, f);
        } else {
            ManagerUtil.setDouble(array, index, f);
        }
    }

    public static void setDouble(Object array, int index, double d) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array == null) {
            throw new NullPointerException();
        }
        if (!(array instanceof double[])) {
            throw new IllegalArgumentException();
        }
        ArrayManager.doubleArrayChanged((double[])array, index, d);
    }

    public static void objectArrayChanged(Object[] array, int index, Object value) {
        ArrayManager.objectArrayChanged(array, index, value);
    }

    public static void shortArrayChanged(short[] array, int index, short value) {
        ArrayManager.shortArrayChanged(array, index, value);
    }

    public static void longArrayChanged(long[] array, int index, long value) {
        ArrayManager.longArrayChanged(array, index, value);
    }

    public static void intArrayChanged(int[] array, int index, int value) {
        ArrayManager.intArrayChanged(array, index, value);
    }

    public static void floatArrayChanged(float[] array, int index, float value) {
        ArrayManager.floatArrayChanged(array, index, value);
    }

    public static void doubleArrayChanged(double[] array, int index, double value) {
        ArrayManager.doubleArrayChanged(array, index, value);
    }

    public static void charArrayChanged(char[] array, int index, char value) {
        ArrayManager.charArrayChanged(array, index, value);
    }

    public static void byteOrBooleanArrayChanged(Object array, int index, byte value) {
        ArrayManager.byteOrBooleanArrayChanged(array, index, value);
    }

    public static void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        ArrayManager.arraycopy(src, srcPos, dest, destPos, length);
    }

    public static TCObject getObject(Object array) {
        return ArrayManager.getObject(array);
    }

    public static void charArrayCopy(char[] src, int srcPos, char[] dest, int destPos, int length, TCObject tco) {
        ArrayManager.charArrayCopy(src, srcPos, dest, destPos, length, tco);
    }

    public static void register(Object array, TCObject obj) {
        ArrayManager.register(array, obj);
    }

    public static SessionMonitor getHttpSessionMonitor() {
        return ManagerUtil.getManager().getHttpSessionMonitor();
    }

    public static TCProperties getTCProperties() {
        return ManagerUtil.getManager().getTCProperties();
    }

    public static int getSessionLockType(String appName) {
        return ClassProcessorHelper.getSessionLockType(appName);
    }

    public static boolean isApplicationSessionLocked(String appName) {
        return ClassProcessorHelper.isApplicationSessionLocked(appName);
    }

    public static boolean isFieldPortableByOffset(Object pojo, long fieldOffset) {
        return ManagerUtil.getManager().isFieldPortableByOffset(pojo, fieldOffset);
    }

    public static boolean overridesHashCode(Object obj) {
        if (obj instanceof OverridesHashCode) {
            return true;
        }
        return ManagerUtil.getManager().overridesHashCode(obj);
    }

    public static void registerNamedLoader(NamedClassLoader loader, String webAppName) {
        ManagerUtil.getManager().registerNamedLoader(loader, webAppName);
    }

    static {
        SINGLETON = null;
    }

    private static class GlobalManagerHolder {
        static final Manager instance = ClassProcessorHelper.getGlobalManager();

        private GlobalManagerHolder() {
        }
    }
}

