/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode;

import com.tc.asm.ClassAdapter;
import com.tc.asm.ClassVisitor;
import com.tc.asm.Label;
import com.tc.asm.MethodAdapter;
import com.tc.asm.MethodVisitor;
import com.tc.asm.Opcodes;
import com.tc.object.bytecode.ByteCodeUtil;

public class LogicalClassSerializationAdapter
implements Opcodes {
    public static final String SERIALIZATION_OVERRIDE_METHOD_NAME = "__tc_isSerializationOverride";
    public static final String SERIALIZATION_OVERRIDE_METHOD_DESC = "()Z";
    public static final String WRITE_OBJECT_SIGNATURE = "writeObject(Ljava/io/ObjectOutputStream;)V";
    public static final String READ_OBJECT_SIGNATURE = "readObject(Ljava/io/ObjectInputStream;)V";

    public static void addCheckSerializationOverrideMethod(ClassVisitor cv, boolean returnValue) {
        MethodVisitor mv = cv.visitMethod(4, SERIALIZATION_OVERRIDE_METHOD_NAME, SERIALIZATION_OVERRIDE_METHOD_DESC, null, null);
        mv.visitCode();
        if (returnValue) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitInsn(172);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public static void addDelegateFieldWriteObjectCode(MethodVisitor mv, String classNameSlashes, String logicalExtendingClassName, String delegateFieldName) {
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, classNameSlashes, ByteCodeUtil.fieldGetterMethod(delegateFieldName), "()L" + logicalExtendingClassName + ";");
        mv.visitMethodInsn(182, "java/io/ObjectOutputStream", "writeObject", "(Ljava/lang/Object;)V");
    }

    public static void addDelegateFieldReadObjectCode(MethodVisitor mv, String classNameSlashes, String logicalExtendingClassName, String delegateFieldName) {
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "java/io/ObjectInputStream", "readObject", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, logicalExtendingClassName);
        mv.visitMethodInsn(183, classNameSlashes, ByteCodeUtil.fieldSetterMethod(delegateFieldName), "(L" + logicalExtendingClassName + ";)V");
    }

    public static class LogicalClassSerializationClassAdapter
    extends ClassAdapter
    implements Opcodes {
        private final String classNameSlashes;

        public LogicalClassSerializationClassAdapter(ClassVisitor cv, String className) {
            super(cv);
            this.classNameSlashes = className.replace('.', '/');
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String methodDesc = name + desc;
            if (LogicalClassSerializationAdapter.WRITE_OBJECT_SIGNATURE.equals(methodDesc) || LogicalClassSerializationAdapter.READ_OBJECT_SIGNATURE.equals(methodDesc)) {
                return new LogicalClassSerializationMethodAdapter(super.visitMethod(access, name, desc, signature, exceptions), this.classNameSlashes);
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            LogicalClassSerializationAdapter.addCheckSerializationOverrideMethod(this.cv, false);
            super.visitEnd();
        }
    }

    public static class LogicalSubclassSerializationMethodAdapter
    extends MethodAdapter
    implements Opcodes {
        private final String methodSignature;
        private final String classNameSlashes;
        private final String logicalExtendingClassName;
        private final String delegateFieldName;

        public LogicalSubclassSerializationMethodAdapter(MethodVisitor mv, String methodSignature, String classNameSlashes, String logicalExtendingClassName, String delegateFieldName) {
            super(mv);
            this.methodSignature = methodSignature;
            this.classNameSlashes = classNameSlashes;
            this.logicalExtendingClassName = logicalExtendingClassName;
            this.delegateFieldName = delegateFieldName;
        }

        public void visitCode() {
            super.visitCode();
            if (LogicalClassSerializationAdapter.WRITE_OBJECT_SIGNATURE.equals(this.methodSignature)) {
                LogicalClassSerializationAdapter.addDelegateFieldWriteObjectCode(this.mv, this.classNameSlashes, this.logicalExtendingClassName, this.delegateFieldName);
            } else if (LogicalClassSerializationAdapter.READ_OBJECT_SIGNATURE.equals(this.methodSignature)) {
                LogicalClassSerializationAdapter.addDelegateFieldReadObjectCode(this.mv, this.classNameSlashes, this.logicalExtendingClassName, this.delegateFieldName);
            }
        }
    }

    public static class LogicalClassSerializationMethodAdapter
    extends MethodAdapter
    implements Opcodes {
        private final String classNameSlashes;

        public LogicalClassSerializationMethodAdapter(MethodVisitor mv, String classNameSlashes) {
            super(mv);
            this.classNameSlashes = classNameSlashes;
        }

        public void visitCode() {
            super.visitCode();
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(182, this.classNameSlashes, LogicalClassSerializationAdapter.SERIALIZATION_OVERRIDE_METHOD_NAME, LogicalClassSerializationAdapter.SERIALIZATION_OVERRIDE_METHOD_DESC);
            Label l1 = new Label();
            this.mv.visitJumpInsn(153, l1);
            this.mv.visitInsn(177);
            this.visitLabel(l1);
        }
    }
}

