/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode;

import com.tc.asm.Type;
import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.reflect.ConstructorInfo;
import com.tc.aspectwerkz.reflect.FieldInfo;
import com.tc.aspectwerkz.reflect.MethodInfo;
import com.tc.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import com.tc.aspectwerkz.reflect.impl.java.JavaClassInfo;
import com.tc.backport175.bytecode.AnnotationElement;
import com.tc.exception.TCLogicalSubclassNotPortableException;
import com.tc.object.LiteralValues;
import com.tc.object.Portability;
import com.tc.object.bytecode.ByteCodeUtil;
import com.tc.object.config.TransparencyClassSpec;
import com.tc.object.config.TransparencyClassSpecUtil;
import com.tc.util.Assert;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class InstrumentationSpec {
    public static final byte IS_NOT_NEEDED = 4;
    public static final byte IS_NEEDED = 5;
    private byte instrumentationAction = 1;
    private byte managedMethods = (byte)4;
    private byte valuesGetterMethod = (byte)4;
    private byte valuesSetterMethod = (byte)4;
    private byte managedValuesGetterMethod = (byte)4;
    private byte managedValuesSetterMethod = (byte)4;
    private byte managedField = (byte)4;
    private byte delegateLogicalField = (byte)4;
    private byte writeObjectSerializedMethod = (byte)4;
    private byte readObjectSerializedMethod = (byte)4;
    private String classNameSlashes;
    private String superNameSlashes;
    private String classNameDots;
    private String superNameDots;
    private boolean isInterface;
    private ParentClassInfo parentClassInfo;
    private boolean classHierarchyInitialized = false;
    private int classAccess;
    private String classSignature;
    private String[] classInterfaces;
    private int classVersion;
    private boolean hasVisitedField;
    private boolean isSubclassOfLogicalClass;
    private TransparencyClassSpec superClassSpec;
    private final ClassInfo classInfo;
    private final Map fieldInfoMap;
    private final TransparencyClassSpec spec;
    private final Set classHierarchy;
    private final Map shouldOverrideMethods;
    private final Set logicalExtendingMethodSpec;
    private final Set logicalExtendingFieldSpec;
    private final ClassLoader caller;

    InstrumentationSpec(ClassInfo classInfo, TransparencyClassSpec spec, ClassLoader caller) {
        this.classInfo = classInfo;
        this.spec = spec;
        this.caller = caller;
        this.classHierarchy = new HashSet();
        this.shouldOverrideMethods = new HashMap();
        this.logicalExtendingMethodSpec = new HashSet();
        this.logicalExtendingFieldSpec = new HashSet();
        this.fieldInfoMap = this.buildFieldInfoMap();
    }

    ClassLoader getCaller() {
        return this.caller;
    }

    private Map buildFieldInfoMap() {
        HashMap<String, FieldInfo> rv = new HashMap<String, FieldInfo>();
        FieldInfo[] fields = this.getClassInfo().getFields();
        for (int i = 0; i < fields.length; ++i) {
            FieldInfo fieldInfo = fields[i];
            FieldInfo prev = rv.put(fieldInfo.getName(), fieldInfo);
            if (prev != null) {
                throw new AssertionError((Object)("replaced mapping for " + fieldInfo.getName() + " in class " + this.getClassInfo().getName()));
            }
        }
        return rv;
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    void initialize(int version, int access, String name, String signature, String superName, String[] interfaces, Portability portability) {
        this.classNameSlashes = name;
        this.superNameSlashes = superName;
        this.classNameDots = name.replace('/', '.');
        this.superNameDots = superName.replace('/', '.');
        this.classHierarchy.add(this.classNameSlashes);
        this.classHierarchy.add(this.superNameSlashes);
        this.classAccess = access;
        this.classSignature = signature;
        this.classInterfaces = interfaces;
        this.classVersion = version;
        this.decideOnInstrumentationAction(portability);
        this.handleSubclassOfLogicalClass(access, this.classNameDots, this.superNameDots);
    }

    private boolean isArray(String className) {
        return LiteralValues.valueForClassName(className) == LiteralValues.ARRAY;
    }

    private void handleSubclassOfLogicalClass(int access, String className, String superName) {
        if (this.isLogical()) {
            return;
        }
        if (this.isArray(className)) {
            return;
        }
        if (TransparencyClassSpecUtil.ignoreChecks(className)) {
            return;
        }
        if (TransparencyClassSpecUtil.ignoreChecks(superName)) {
            return;
        }
        this.superClassSpec = this.spec.getClassSpec(superName);
        if (this.superClassSpec != null && this.superClassSpec.isLogical()) {
            this.isSubclassOfLogicalClass = true;
        }
    }

    public int getClassVersion() {
        return this.classVersion;
    }

    public int getClassAccess() {
        return this.classAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClassHierarchy() {
        String superClassName = this.superNameSlashes.replace('/', '.');
        try {
            for (Class<?> superClazz = Class.forName(superClassName, false, this.classInfo.getClassLoader()).getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                String superName = superClazz.getName();
                this.classHierarchy.add(superName.replace('.', '/'));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            this.classHierarchyInitialized = true;
        }
    }

    String getClassNameSlashes() {
        return this.classNameSlashes;
    }

    String getClassNameDots() {
        return this.classNameDots;
    }

    String getSuperClassNameSlashes() {
        return this.superNameSlashes;
    }

    String getSuperClassNameDots() {
        return this.superNameDots;
    }

    String[] getClassInterfaces() {
        return this.classInterfaces;
    }

    String getClassSignature() {
        return this.classSignature;
    }

    void decideOnInstrumentationAction(Portability portability) {
        Assert.assertNotNull(this.classNameSlashes);
        Assert.assertNotNull(this.superNameSlashes);
        this.isInterface = Modifier.isInterface(this.classAccess);
        this.instrumentationAction = this.isInterface ? (byte)1 : (this.spec.getInstrumentationAction() == 3 ? (byte)3 : (this.spec.getInstrumentationAction() == 2 ? (byte)2 : (this.spec.isLogical() || this.spec.ignoreChecks() ? (byte)3 : (this.superClassChecks(portability) ? (byte)2 : (byte)3))));
        this.decideOnInstrumentationsToDo(portability);
    }

    private void decideOnInstrumentationsToDo(Portability portability) {
        if (this.instrumentationAction == 3) {
            if (!this.isLogical()) {
                this.valuesGetterMethod = (byte)5;
                this.valuesSetterMethod = (byte)5;
                this.managedValuesGetterMethod = (byte)5;
                this.managedValuesSetterMethod = (byte)5;
            }
            this.managedMethods = this.managedField = this.isNeedManagedField(portability);
        }
    }

    private byte isNeedManagedField(Portability portability) {
        if (this.isSubclassOfLogicalClass) {
            return 4;
        }
        ClassInfo superClassInfo = this.classInfo.getSuperclass();
        if (portability.isInstrumentationNotNeeded(superClassInfo.getName())) {
            return 5;
        }
        if (!this.spec.hasPhysicallyPortableSpecs(superClassInfo)) {
            return 5;
        }
        if (this.spec.isLogical()) {
            return 5;
        }
        return 4;
    }

    private boolean superClassChecks(Portability portability) {
        Class<?> superClazz;
        String superClassName = this.superNameSlashes.replace('/', '.');
        if (portability.isInstrumentationNotNeeded(superClassName)) {
            return false;
        }
        try {
            superClazz = Class.forName(superClassName, false, this.classInfo.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return !portability.isPortableClass(superClazz);
    }

    boolean isInClassHierarchy(String classname) {
        boolean inClassHierarchy = this.classHierarchy.contains(classname);
        if (inClassHierarchy || this.classHierarchyInitialized) {
            return inClassHierarchy;
        }
        this.initClassHierarchy();
        return this.classHierarchy.contains(classname);
    }

    boolean isClassNotAdaptable() {
        return this.instrumentationAction == 1;
    }

    boolean isClassAdaptable() {
        return this.instrumentationAction == 2;
    }

    boolean isClassPortable() {
        return this.instrumentationAction == 3;
    }

    boolean isSubclassofLogicalClass() {
        return this.isSubclassOfLogicalClass;
    }

    void moveToLogicalIfNecessary() {
        if (this.isSubclassOfLogicalClass && !this.hasVisitedField) {
            this.spec.moveToLogical(this.superClassSpec);
        }
    }

    boolean hasDelegatedToLogicalClass() {
        return this.needDelegateField();
    }

    boolean needDelegateField() {
        return this.delegateLogicalField == 5;
    }

    boolean isWriteObjectMethodNeeded() {
        return this.writeObjectSerializedMethod == 5;
    }

    boolean isReadObjectMethodNeeded() {
        return this.readObjectSerializedMethod == 5;
    }

    void handleSubclassOfLogicalClassWithFieldsIfNecessary(int access, String fieldName) {
        if (ByteCodeUtil.isSynthetic(access) || Modifier.isStatic(access) || this.spec.isTransient(access, this.classInfo, fieldName)) {
            return;
        }
        if (this.isSubclassOfLogicalClass && !this.hasVisitedField) {
            this.hasVisitedField = true;
            try {
                String methodDesc;
                int modifier;
                String methodName;
                Method m;
                int i;
                Class<?> superClazz = Class.forName(this.superNameDots, false, this.classInfo.getClassLoader());
                Method[] methods = superClazz.getMethods();
                for (i = 0; i < methods.length; ++i) {
                    m = methods[i];
                    methodName = m.getName();
                    modifier = m.getModifiers();
                    if (!this.shouldVisitMethod(modifier, methodName) || Modifier.isFinal(modifier) || Modifier.isStatic(modifier)) continue;
                    methodDesc = Type.getMethodDescriptor(m);
                    this.shouldOverrideMethods.put(methodName + methodDesc, m);
                }
                methods = superClazz.getDeclaredMethods();
                for (i = 0; i < methods.length; ++i) {
                    m = methods[i];
                    methodName = m.getName();
                    modifier = m.getModifiers();
                    if (!this.shouldVisitMethod(modifier, methodName) || Modifier.isFinal(modifier) || !Modifier.isProtected(modifier)) continue;
                    methodDesc = Type.getMethodDescriptor(m);
                    this.logicalExtendingMethodSpec.add(methodName + methodDesc);
                }
                Field[] fields = superClazz.getDeclaredFields();
                for (int i2 = 0; i2 < fields.length; ++i2) {
                    Field f = fields[i2];
                    String fName = f.getName();
                    int modifier2 = f.getModifiers();
                    if (!this.shouldVisitField(fName) || Modifier.isFinal(modifier2) || Modifier.isPrivate(modifier2)) continue;
                    String fieldDesc = Type.getDescriptor(f.getType());
                    this.logicalExtendingFieldSpec.add(fName + fieldDesc);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            this.delegateLogicalField = (byte)5;
            this.writeObjectSerializedMethod = (byte)5;
            this.readObjectSerializedMethod = (byte)5;
        }
    }

    void recordExistingFields(String name, String desc, String signature) {
        if (ByteCodeUtil.isParent(name)) {
            Assert.assertNull(this.parentClassInfo);
            this.parentClassInfo = new ParentClassInfo(name, desc);
        }
    }

    void recordExistingMethods(String name, String desc, String signature) {
        if ("readObject(Ljava/io/ObjectInputStream;)V".equals(name + desc)) {
            this.readObjectSerializedMethod = (byte)4;
        } else if ("writeObject(Ljava/io/ObjectOutputStream;)V".equals(name + desc)) {
            this.writeObjectSerializedMethod = (byte)4;
        }
        this.shouldOverrideMethods.remove(name + desc);
    }

    boolean shouldVisitField(String name) {
        return !name.startsWith("$__tc_");
    }

    boolean shouldVisitMethod(int methodAccess, String name) {
        if (name.startsWith("__tc_")) {
            return false;
        }
        return !Modifier.isAbstract(methodAccess) && !Modifier.isNative(methodAccess);
    }

    boolean isManagedMethodsNeeded() {
        return this.managedMethods == 5;
    }

    boolean isValuesGetterMethodNeeded() {
        return this.valuesGetterMethod == 5;
    }

    boolean isValuesSetterMethodNeeded() {
        return this.valuesSetterMethod == 5;
    }

    boolean isManagedValuesGetterMethodNeeded() {
        return this.managedValuesGetterMethod == 5;
    }

    boolean isManagedValuesSetterMethodNeeded() {
        return this.managedValuesSetterMethod == 5;
    }

    boolean isManagedFieldNeeded() {
        return this.managedField == 5;
    }

    TransparencyClassSpec getTransparencyClassSpec() {
        return this.spec;
    }

    TransparencyClassSpec getSuperclassTransparencyClassSpec() {
        return this.spec.getClassSpec(this.superNameDots);
    }

    boolean isLogical() {
        return this.spec.isLogical();
    }

    boolean needInstrumentFieldInsn() {
        return !this.spec.isLogical() && (!this.isSubclassOfLogicalClass || this.hasVisitedField);
    }

    void shouldProceedInstrumentation(int access, String name, String desc) {
        if (this.isSubclassOfLogicalClass && this.shouldVisitMethod(access, name) && this.logicalExtendingMethodSpec.contains(name + desc)) {
            throw new TCLogicalSubclassNotPortableException(this.classNameDots, this.superNameDots);
        }
    }

    void shouldProceedInstrumentation(String fieldName, String fieldDesc) {
        if (this.isSubclassOfLogicalClass && this.shouldVisitField(fieldName) && this.logicalExtendingFieldSpec.contains(fieldName + fieldDesc)) {
            throw new TCLogicalSubclassNotPortableException(this.classNameDots, this.superNameDots);
        }
    }

    boolean isPhysical() {
        return this.spec.isPhysical();
    }

    Collection getShouldOverrideMethods() {
        return this.shouldOverrideMethods.values();
    }

    boolean isInner() {
        return this.parentClassInfo != null;
    }

    String getParentClassType() {
        Assert.assertTrue(this.isInner());
        return this.parentClassInfo.getType();
    }

    String getParentClassFieldName() {
        Assert.assertTrue(this.isInner());
        return this.parentClassInfo.getFieldName();
    }

    public MethodInfo getMethodInfo(int access, String name, String desc) {
        if (!"<init>".equals(name)) {
            MethodInfo[] methods = this.classInfo.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                MethodInfo methodInfo = methods[i];
                if (!methodInfo.getName().equals(name) || !methodInfo.getSignature().equals(desc)) continue;
                return methodInfo;
            }
        } else {
            ConstructorInfo[] constructors = this.classInfo.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                ConstructorInfo info = constructors[i];
                if (!info.getName().equals(name) || !info.getSignature().equals(desc)) continue;
                return new ConstructorInfoWrapper(info);
            }
            name = "__INIT__";
        }
        return new StubMethodInfo(name, desc, access, this.classInfo);
    }

    public FieldInfo getFieldInfo(String fieldName) {
        return (FieldInfo)this.fieldInfoMap.get(fieldName);
    }

    public class ConstructorInfoWrapper
    implements MethodInfo {
        private final ConstructorInfo constructorInfo;

        public ConstructorInfoWrapper(ConstructorInfo constructorInfo) {
            this.constructorInfo = constructorInfo;
        }

        public String getName() {
            return "__INIT__";
        }

        public int getModifiers() {
            return this.constructorInfo.getModifiers();
        }

        public ClassInfo[] getParameterTypes() {
            return this.constructorInfo.getParameterTypes();
        }

        public String getSignature() {
            return this.constructorInfo.getSignature();
        }

        public String getGenericsSignature() {
            return this.constructorInfo.getGenericsSignature();
        }

        public ClassInfo[] getExceptionTypes() {
            return this.constructorInfo.getExceptionTypes();
        }

        public AnnotationElement.Annotation[] getAnnotations() {
            return this.constructorInfo.getAnnotations();
        }

        public ClassInfo getDeclaringType() {
            return this.constructorInfo.getDeclaringType();
        }

        public String[] getParameterNames() {
            return new String[0];
        }

        public ClassInfo getReturnType() {
            return JavaClassInfo.getClassInfo(Void.TYPE);
        }
    }

    public class StubConstructorInfo
    implements ConstructorInfo {
        private final String name;
        private final String desc;
        private final int access;
        private final ClassInfo declaringClassInfo;

        private StubConstructorInfo(String name, String desc, int access, ClassInfo classInfo) {
            this.name = name;
            this.desc = desc;
            this.access = access;
            this.declaringClassInfo = classInfo;
        }

        public ClassInfo[] getExceptionTypes() {
            return new ClassInfo[0];
        }

        public ClassInfo[] getParameterTypes() {
            Type[] types = Type.getArgumentTypes(this.desc);
            ClassInfo[] parameterTypes = new ClassInfo[types.length];
            for (int i = 0; i < types.length; ++i) {
                parameterTypes[i] = AsmClassInfo.getClassInfo((String)types[i].getClassName(), (ClassLoader)this.declaringClassInfo.getClassLoader());
            }
            return parameterTypes;
        }

        public ClassInfo getDeclaringType() {
            return this.declaringClassInfo;
        }

        public AnnotationElement.Annotation[] getAnnotations() {
            return new AnnotationElement.Annotation[0];
        }

        public String getGenericsSignature() {
            return null;
        }

        public int getModifiers() {
            return this.access;
        }

        public String getName() {
            return this.name;
        }

        public String getSignature() {
            return this.desc;
        }
    }

    private static final class StubMethodInfo
    implements MethodInfo {
        private final String name;
        private final String desc;
        private final int access;
        private final ClassInfo declaringClassInfo;

        private StubMethodInfo(String name, String desc, int access, ClassInfo classInfo) {
            this.name = name;
            this.desc = desc;
            this.access = access;
            this.declaringClassInfo = classInfo;
        }

        public ClassInfo[] getExceptionTypes() {
            return new ClassInfo[0];
        }

        public String[] getParameterNames() {
            return new String[0];
        }

        public ClassInfo[] getParameterTypes() {
            Type[] types = Type.getArgumentTypes(this.desc);
            ClassInfo[] parameterTypes = new ClassInfo[types.length];
            for (int i = 0; i < types.length; ++i) {
                parameterTypes[i] = AsmClassInfo.getClassInfo((String)types[i].getClassName(), (ClassLoader)this.declaringClassInfo.getClassLoader());
            }
            return parameterTypes;
        }

        public ClassInfo getReturnType() {
            Type type = Type.getReturnType(this.desc);
            return AsmClassInfo.getClassInfo((String)type.getClassName(), (ClassLoader)this.declaringClassInfo.getClassLoader());
        }

        public ClassInfo getDeclaringType() {
            return this.declaringClassInfo;
        }

        public AnnotationElement.Annotation[] getAnnotations() {
            return new AnnotationElement.Annotation[0];
        }

        public String getGenericsSignature() {
            return null;
        }

        public int getModifiers() {
            return this.access;
        }

        public String getName() {
            return this.name;
        }

        public String getSignature() {
            return this.desc;
        }
    }

    private static class ParentClassInfo {
        private final String type;
        private final String fieldName;

        ParentClassInfo(String fieldName, String type) {
            this.fieldName = fieldName;
            this.type = type;
        }

        String getFieldName() {
            return this.fieldName;
        }

        String getType() {
            return this.type;
        }
    }
}

