/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode;

import com.tc.asm.Label;
import com.tc.asm.MethodAdapter;
import com.tc.asm.MethodVisitor;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExceptionTableOrderingMethodAdapter
extends MethodAdapter {
    private static final TCLogger LOGGER = TCLogging.getLogger(ExceptionTableOrderingMethodAdapter.class);
    private final List handlers = new ArrayList();
    private boolean visitMaxs = false;
    private int stack;
    private int locals;

    public ExceptionTableOrderingMethodAdapter(MethodVisitor mv) {
        super(mv);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.handlers.add(new Handler(start, end, handler, type, this.handlers.size()));
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.visitMaxs = true;
        this.stack = maxStack;
        this.locals = maxLocals;
    }

    public void visitEnd() {
        Collections.sort(this.handlers);
        for (Handler h : this.handlers) {
            h.accept(this.mv);
        }
        if (this.visitMaxs) {
            super.visitMaxs(this.stack, this.locals);
        }
        super.visitEnd();
    }

    private static class Handler
    implements Comparable {
        private final Label start;
        private final Label end;
        private final Label handler;
        private final String desc;
        private final int index;

        public Handler(Label start, Label end, Label handler, String type, int index) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.desc = type;
            this.index = index;
        }

        void accept(MethodVisitor mv) {
            mv.visitTryCatchBlock(this.start, this.end, this.handler, this.desc);
        }

        public int hashCode() {
            try {
                return 7 * this.start.getOffset() ^ 11 * this.end.getOffset() ^ 13 * this.handler.getOffset() ^ (this.desc == null ? 0 : 17 * this.desc.hashCode());
            }
            catch (IllegalStateException e) {
                return 7 * this.start.hashCode() ^ 11 * this.end.hashCode() ^ 13 * this.handler.hashCode() ^ (this.desc == null ? 0 : 17 * this.desc.hashCode());
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof Handler)) {
                return false;
            }
            Handler h = (Handler)o;
            try {
                return this.start.getOffset() == h.start.getOffset() && this.end.getOffset() == h.end.getOffset() && this.handler.getOffset() == h.handler.getOffset() && (this.desc == null ? this.desc == h.desc : this.desc.equals(h.desc));
            }
            catch (IllegalStateException e) {
                return this.start == h.start && this.end == h.end && this.handler == h.handler && (this.desc == null ? this.desc == h.desc : this.desc.equals(h.desc));
            }
        }

        public int compareTo(Object o) {
            Handler h0 = this;
            Handler h1 = (Handler)o;
            try {
                int crossDeltaOne = h0.start.getOffset() - h1.end.getOffset();
                int crossDeltaTwo = h0.end.getOffset() - h1.start.getOffset();
                if (crossDeltaOne >= 0) {
                    return 1;
                }
                if (crossDeltaTwo <= 0) {
                    return -1;
                }
                if (crossDeltaOne < 0 && crossDeltaTwo > 0) {
                    int h1Size;
                    int h0Size = h0.end.getOffset() - h0.start.getOffset();
                    if (h0Size == (h1Size = h1.end.getOffset() - h1.start.getOffset())) {
                        return h0.index - h1.index;
                    }
                    return h0Size - h1Size;
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Not all handler labels were visited, reverting to the visited order (comparing " + h0 + " and " + h1 + ")");
                return h0.index - h1.index;
            }
            LOGGER.warn("Exception Handler Ranges Not Language Compliant: " + h0 + " and " + h1);
            return h0.index - h1.index;
        }

        public String toString() {
            try {
                return "Exception Handler : Catches " + (this.desc == null ? "<finally>" : this.desc) + " @ [" + this.start.getOffset() + ".." + this.end.getOffset() + "] => " + this.handler.getOffset();
            }
            catch (IllegalStateException e) {
                return "Exception Handler : Catches " + (this.desc == null ? "<finally>" : this.desc) + " @ [" + this.start + ".." + this.end + "] => " + this.handler;
            }
        }
    }
}

