/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.bytecode;

import com.tc.asm.ClassAdapter;
import com.tc.asm.ClassVisitor;
import com.tc.asm.FieldVisitor;
import com.tc.asm.Label;
import com.tc.asm.MethodVisitor;
import com.tc.asm.Opcodes;
import com.tc.asm.Type;
import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.reflect.FieldInfo;
import com.tc.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import com.tc.object.Portability;
import com.tc.object.bytecode.ByteCodeUtil;
import com.tc.object.bytecode.InstrumentationSpec;
import com.tc.object.bytecode.LogicalClassSerializationAdapter;
import com.tc.object.bytecode.Manageable;
import com.tc.object.bytecode.TransparentAccess;
import com.tc.object.config.TransparencyClassSpec;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class ClassAdapterBase
extends ClassAdapter
implements Opcodes {
    public static final String MANAGED_FIELD_NAME = "$__tc_MANAGED";
    public static final String MANAGED_FIELD_TYPE = "Lcom/tc/object/TCObject;";
    public static final String MANAGED_METHOD = "__tc_managed";
    public static final String IS_MANAGED_METHOD = "__tc_isManaged";
    public static final String IS_MANAGED_DESCRIPTION = "()Z";
    public static final String VALUES_GETTER = "__tc_getallfields";
    public static final String VALUES_GETTER_DESCRIPTION = "(Ljava/util/Map;)V";
    public static final String VALUES_SETTER = "__tc_setfield";
    public static final String VALUES_SETTER_DESCRIPTION = "(Ljava/lang/String;Ljava/lang/Object;)V";
    public static final String MANAGED_VALUES_GETTER = "__tc_getmanagedfield";
    public static final String MANAGED_VALUES_GETTER_DESCRIPTION = "(Ljava/lang/String;)Ljava/lang/Object;";
    public static final String MANAGED_VALUES_SETTER = "__tc_setmanagedfield";
    private static final String LOGICAL_TYPE_DELEGATE_FIELD_NAME_PREFIX = "__delegate_tc_";
    private static final int LOGICAL_TYPE_DELEGATE_FIELD_MODIFIER = 130;
    private static final Set ALWAYS_REWRITE_IF_PRESENT = ClassAdapterBase.getAlwaysRewrite();
    private final Map fields = new HashMap();
    protected final InstrumentationSpec spec;
    private final Portability portability;
    private boolean hasVisitedDelegateField = false;

    public static String getDelegateFieldName(String logicalExtendingClassName) {
        return LOGICAL_TYPE_DELEGATE_FIELD_NAME_PREFIX + logicalExtendingClassName.replace('.', '_').replace('/', '_').replace('$', '_');
    }

    private static Set getAlwaysRewrite() {
        HashSet s = new HashSet();
        s.addAll(ClassAdapterBase.getInterfaceMethodDescriptions(Manageable.class));
        s.addAll(ClassAdapterBase.getInterfaceMethodDescriptions(TransparentAccess.class));
        return Collections.unmodifiableSet(s);
    }

    public static boolean isDelegateFieldName(String fieldName) {
        return fieldName.startsWith(LOGICAL_TYPE_DELEGATE_FIELD_NAME_PREFIX);
    }

    protected TransparencyClassSpec getTransparencyClassSpec() {
        return this.spec.getTransparencyClassSpec();
    }

    protected InstrumentationSpec getInstrumentationSpec() {
        return this.spec;
    }

    private boolean isRoot(String fieldName) {
        FieldInfo fieldInfo = this.getInstrumentationSpec().getFieldInfo(fieldName);
        if (fieldInfo == null) {
            return false;
        }
        return this.getTransparencyClassSpec().isRootInThisClass(fieldInfo);
    }

    public ClassAdapterBase(ClassInfo classInfo, TransparencyClassSpec spec2, ClassVisitor delegate, ClassLoader caller, Portability p) {
        super(delegate);
        this.portability = p;
        this.spec = new InstrumentationSpec(classInfo, spec2, caller);
    }

    public final void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.spec.initialize(version, access, name, signature, superName, interfaces, this.portability);
        if (this.spec.isClassNotAdaptable()) {
            super.visit(version, access, name, signature, superName, interfaces);
            return;
        }
        if (this.spec.isClassPortable()) {
            interfaces = this.getNewInterfacesForPortableObject(interfaces);
        }
        this.basicVisit(version, access, name, signature, superName, interfaces);
    }

    private void visitDelegateFieldIfNecessary() {
        if (!this.hasVisitedDelegateField) {
            this.hasVisitedDelegateField = true;
            String superClassNameSlashes = this.spec.getSuperClassNameSlashes();
            String delegateFieldName = ClassAdapterBase.getDelegateFieldName(superClassNameSlashes);
            String delegateFieldType = "L" + superClassNameSlashes + ";";
            this.visitField(130, delegateFieldName, delegateFieldType, null, null);
        }
    }

    private String[] getNewInterfacesForPortableObject(String[] interfaces) {
        LinkedHashSet<String> ifaces = new LinkedHashSet<String>(Arrays.asList(interfaces));
        if (!ifaces.contains("com/tc/object/bytecode/Manageable")) {
            ifaces.add("com/tc/object/bytecode/Manageable");
        }
        if (!this.spec.isLogical() && !ifaces.contains("com/tc/object/bytecode/TransparentAccess")) {
            ifaces.add("com/tc/object/bytecode/TransparentAccess");
        }
        return ifaces.toArray(interfaces);
    }

    public final FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.spec.handleSubclassOfLogicalClassWithFieldsIfNecessary(access, name);
        if (this.spec.needDelegateField()) {
            this.visitDelegateFieldIfNecessary();
        }
        if (MANAGED_FIELD_NAME.equals(name)) {
            return null;
        }
        this.spec.recordExistingFields(name, desc, signature);
        if (this.spec.isClassNotAdaptable() || name.startsWith("$__tc_")) {
            return super.visitField(access, name, desc, signature, value);
        }
        if (!Modifier.isStatic(access)) {
            this.fields.put(name, desc);
        }
        return this.basicVisitField(access, name, desc, signature, value);
    }

    public final MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv;
        this.spec.shouldProceedInstrumentation(access, name, desc);
        if (this.spec.isClassNotAdaptable()) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (ALWAYS_REWRITE_IF_PRESENT.contains(name + desc)) {
            return null;
        }
        this.spec.recordExistingMethods(name, desc, signature);
        if (this.spec.shouldVisitMethod(access, name)) {
            mv = this.basicVisitMethod(access, name, desc, signature, exceptions);
            if (this.spec.hasDelegatedToLogicalClass()) {
                String logicalExtendingClassName = this.spec.getSuperClassNameSlashes();
                mv = new LogicalClassSerializationAdapter.LogicalSubclassSerializationMethodAdapter(mv, name + desc, this.spec.getClassNameSlashes(), logicalExtendingClassName, ClassAdapterBase.getDelegateFieldName(logicalExtendingClassName));
            }
        } else {
            mv = super.visitMethod(access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private void revisitLogicalSubclassDefinition() {
        this.spec.moveToLogicalIfNecessary();
        String[] interfaces = this.spec.getClassInterfaces();
        interfaces = this.getNewInterfacesForPortableObject(interfaces);
        this.basicVisit(this.spec.getClassVersion(), this.spec.getClassAccess(), this.spec.getClassNameSlashes(), this.spec.getClassSignature(), this.spec.getSuperClassNameSlashes(), interfaces);
    }

    public final void visitEnd() {
        if (this.spec.isClassNotAdaptable()) {
            super.visitEnd();
            return;
        }
        if (this.spec.isSubclassofLogicalClass()) {
            this.revisitLogicalSubclassDefinition();
        }
        this.addOverridenLogicalMethods();
        this.addRetrieveValuesMethod();
        this.addSetValueMethod();
        this.addRetrieveManagedValueMethod();
        this.addSetManagedValueMethod();
        if (this.spec.isManagedFieldNeeded()) {
            this.addCachedManagedMethods();
            super.visitField(4290, MANAGED_FIELD_NAME, MANAGED_FIELD_TYPE, null, null);
        }
        this.basicVisitEnd();
    }

    private void addOverridenLogicalMethods() {
        Collection needToOverrideMethods = this.spec.getShouldOverrideMethods();
        for (Method m : needToOverrideMethods) {
            String methodName;
            int modifier = m.getModifiers();
            if (!this.spec.shouldVisitMethod(modifier, methodName = m.getName()) || Modifier.isFinal(modifier)) continue;
            String methodDesc = Type.getMethodDescriptor(m);
            Type returnType = Type.getReturnType(m);
            Class<?>[] exceptionTypes = m.getExceptionTypes();
            String[] exceptions = new String[exceptionTypes.length];
            for (int j = 0; j < exceptionTypes.length; ++j) {
                exceptions[j] = Type.getInternalName(exceptionTypes[j]);
            }
            String logicalExtendingClassName = this.spec.getSuperClassNameSlashes();
            MethodVisitor mv = this.cv.visitMethod(modifier & 0xFFFFFBFF, methodName, methodDesc, null, exceptions);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, this.spec.getClassNameSlashes(), ByteCodeUtil.fieldGetterMethod(ClassAdapterBase.getDelegateFieldName(logicalExtendingClassName)), "()L" + logicalExtendingClassName + ";");
            ByteCodeUtil.pushMethodArguments(1, methodDesc, mv);
            mv.visitMethodInsn(182, logicalExtendingClassName, methodName, methodDesc);
            mv.visitInsn(returnType.getOpcode(172));
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        if (this.spec.hasDelegatedToLogicalClass()) {
            this.addReadObjectMethod();
            this.addWriteObjectMethod();
            this.addSerializationOverrideMethod();
        }
    }

    private void addSerializationOverrideMethod() {
        LogicalClassSerializationAdapter.addCheckSerializationOverrideMethod(this.cv, true);
    }

    private void addWriteObjectMethod() {
        if (!this.spec.isWriteObjectMethodNeeded()) {
            return;
        }
        String logicalExtendingClassName = this.spec.getSuperClassNameSlashes();
        MethodVisitor mv = this.cv.visitMethod(2, "writeObject", "(Ljava/io/ObjectOutputStream;)V", null, new String[]{"java/io/IOException"});
        mv.visitCode();
        LogicalClassSerializationAdapter.addDelegateFieldWriteObjectCode(mv, this.spec.getClassNameSlashes(), logicalExtendingClassName, ClassAdapterBase.getDelegateFieldName(logicalExtendingClassName));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addReadObjectMethod() {
        if (!this.spec.isReadObjectMethodNeeded()) {
            return;
        }
        String logicalExtendingClassName = this.spec.getSuperClassNameSlashes();
        MethodVisitor mv = this.cv.visitMethod(2, "readObject", "(Ljava/io/ObjectInputStream;)V", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        mv.visitCode();
        LogicalClassSerializationAdapter.addDelegateFieldReadObjectCode(mv, this.spec.getClassNameSlashes(), logicalExtendingClassName, ClassAdapterBase.getDelegateFieldName(logicalExtendingClassName));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addCachedManagedMethods() {
        if (this.spec.isManagedMethodsNeeded()) {
            MethodVisitor mv = super.visitMethod(4097, MANAGED_METHOD, "()Lcom/tc/object/TCObject;", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.spec.getClassNameSlashes(), MANAGED_FIELD_NAME, MANAGED_FIELD_TYPE);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = super.visitMethod(4097, MANAGED_METHOD, "(Lcom/tc/object/TCObject;)V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, this.spec.getClassNameSlashes(), MANAGED_FIELD_NAME, MANAGED_FIELD_TYPE);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = super.visitMethod(4097, IS_MANAGED_METHOD, IS_MANAGED_DESCRIPTION, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.spec.getClassNameSlashes(), MANAGED_FIELD_NAME, MANAGED_FIELD_TYPE);
            Label l1 = new Label();
            mv.visitJumpInsn(198, l1);
            mv.visitInsn(4);
            mv.visitInsn(172);
            mv.visitLabel(l1);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
    }

    private void addRetrieveValuesMethod() {
        if (this.spec.isValuesGetterMethodNeeded()) {
            MethodVisitor mv = super.visitMethod(4097, VALUES_GETTER, VALUES_GETTER_DESCRIPTION, null, null);
            if (!this.portability.isInstrumentationNotNeeded(this.spec.getSuperClassNameDots()) && this.getTransparencyClassSpec().hasPhysicallyPortableSpecs(AsmClassInfo.getClassInfo((String)this.spec.getSuperClassNameDots(), (ClassLoader)this.spec.getClassInfo().getClassLoader()))) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(183, this.spec.getSuperClassNameSlashes(), VALUES_GETTER, VALUES_GETTER_DESCRIPTION);
            }
            for (String fieldName : this.fields.keySet()) {
                String fieldDescription = (String)this.fields.get(fieldName);
                mv.visitVarInsn(25, 1);
                mv.visitLdcInsn(this.spec.getClassNameDots() + "." + fieldName);
                this.addValueToStackForField(mv, fieldName, fieldDescription);
                mv.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                mv.visitInsn(87);
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void addRetrieveManagedValueMethod() {
        if (this.spec.isManagedValuesGetterMethodNeeded()) {
            MethodVisitor mv = super.visitMethod(4097, MANAGED_VALUES_GETTER, MANAGED_VALUES_GETTER_DESCRIPTION, null, null);
            for (String fieldName : this.fields.keySet()) {
                String fieldDescription = (String)this.fields.get(fieldName);
                mv.visitVarInsn(25, 1);
                mv.visitLdcInsn(this.spec.getClassNameDots() + "." + fieldName);
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                Label l1 = new Label();
                mv.visitJumpInsn(153, l1);
                if (ByteCodeUtil.isSynthetic(fieldName)) {
                    this.addValueToStackForField(mv, fieldName, fieldDescription);
                } else {
                    this.addManagedValueToStackForField(mv, fieldName, fieldDescription);
                }
                mv.visitInsn(176);
                mv.visitLabel(l1);
            }
            if (!this.portability.isInstrumentationNotNeeded(this.spec.getSuperClassNameDots()) && this.getTransparencyClassSpec().hasPhysicallyPortableSpecs(AsmClassInfo.getClassInfo((String)this.spec.getSuperClassNameDots(), (ClassLoader)this.spec.getClassInfo().getClassLoader()))) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(183, this.spec.getSuperClassNameSlashes(), MANAGED_VALUES_GETTER, MANAGED_VALUES_GETTER_DESCRIPTION);
            } else {
                mv.visitInsn(1);
            }
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void addSetValueMethod() {
        if (this.spec.isValuesSetterMethodNeeded()) {
            MethodVisitor mv = super.visitMethod(4097, VALUES_SETTER, VALUES_SETTER_DESCRIPTION, null, null);
            Label l1 = new Label();
            for (String fieldName : this.fields.keySet()) {
                if (ByteCodeUtil.isTCSynthetic(fieldName)) continue;
                String fieldDescription = (String)this.fields.get(fieldName);
                Type t = Type.getType(fieldDescription);
                mv.visitVarInsn(25, 1);
                mv.visitLdcInsn(this.spec.getClassNameDots() + "." + fieldName);
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                Label l2 = new Label();
                mv.visitJumpInsn(153, l2);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 2);
                if (t.getSort() != 10 && t.getSort() != 9) {
                    mv.visitTypeInsn(192, ByteCodeUtil.sortToWrapperName(t.getSort()));
                    mv.visitMethodInsn(182, ByteCodeUtil.sortToWrapperName(t.getSort()), ByteCodeUtil.sortToPrimitiveMethodName(t.getSort()), "()" + fieldDescription);
                } else {
                    mv.visitTypeInsn(192, this.convertToCheckCastDesc(fieldDescription));
                }
                mv.visitFieldInsn(181, this.spec.getClassNameSlashes(), fieldName, fieldDescription);
                mv.visitJumpInsn(167, l1);
                mv.visitLabel(l2);
            }
            if (!this.portability.isInstrumentationNotNeeded(this.spec.getSuperClassNameDots()) && this.getTransparencyClassSpec().hasPhysicallyPortableSpecs(AsmClassInfo.getClassInfo((String)this.spec.getSuperClassNameDots(), (ClassLoader)this.spec.getClassInfo().getClassLoader()))) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(183, this.spec.getSuperClassNameSlashes(), VALUES_SETTER, VALUES_SETTER_DESCRIPTION);
            }
            mv.visitLabel(l1);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void addSetManagedValueMethod() {
        if (this.spec.isManagedValuesSetterMethodNeeded()) {
            MethodVisitor mv = super.visitMethod(4097, MANAGED_VALUES_SETTER, VALUES_SETTER_DESCRIPTION, null, null);
            Label l1 = new Label();
            for (String fieldName : this.fields.keySet()) {
                if (ByteCodeUtil.isSynthetic(fieldName)) continue;
                String fieldDescription = (String)this.fields.get(fieldName);
                Type t = Type.getType(fieldDescription);
                mv.visitVarInsn(25, 1);
                mv.visitLdcInsn(this.spec.getClassNameDots() + "." + fieldName);
                mv.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                Label l2 = new Label();
                mv.visitJumpInsn(153, l2);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 2);
                if (t.getSort() != 10 && t.getSort() != 9) {
                    mv.visitTypeInsn(192, ByteCodeUtil.sortToWrapperName(t.getSort()));
                    mv.visitMethodInsn(182, ByteCodeUtil.sortToWrapperName(t.getSort()), ByteCodeUtil.sortToPrimitiveMethodName(t.getSort()), "()" + fieldDescription);
                } else {
                    mv.visitTypeInsn(192, this.convertToCheckCastDesc(fieldDescription));
                }
                mv.visitMethodInsn(182, this.spec.getClassNameSlashes(), ByteCodeUtil.fieldSetterMethod(fieldName), "(" + fieldDescription + ")V");
                mv.visitJumpInsn(167, l1);
                mv.visitLabel(l2);
            }
            if (!this.portability.isInstrumentationNotNeeded(this.spec.getSuperClassNameDots()) && this.getTransparencyClassSpec().hasPhysicallyPortableSpecs(AsmClassInfo.getClassInfo((String)this.spec.getSuperClassNameDots(), (ClassLoader)this.spec.getClassInfo().getClassLoader()))) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(183, this.spec.getSuperClassNameSlashes(), MANAGED_VALUES_SETTER, VALUES_SETTER_DESCRIPTION);
            }
            mv.visitLabel(l1);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    protected String convertToCheckCastDesc(String desc) {
        if (desc.startsWith("[")) {
            return desc;
        }
        return desc.substring(1, desc.length() - 1);
    }

    private void addValueToStackForField(MethodVisitor mv, String fieldName, String fieldDescription) {
        Type t = Type.getType(fieldDescription);
        if (t.getSort() == 10 || t.getSort() == 9) {
            ByteCodeUtil.pushThis(mv);
            mv.visitFieldInsn(180, this.spec.getClassNameSlashes(), fieldName, fieldDescription);
        } else {
            mv.visitTypeInsn(187, ByteCodeUtil.sortToWrapperName(t.getSort()));
            mv.visitInsn(89);
            ByteCodeUtil.pushThis(mv);
            mv.visitFieldInsn(180, this.spec.getClassNameSlashes(), fieldName, fieldDescription);
            mv.visitMethodInsn(183, ByteCodeUtil.sortToWrapperName(t.getSort()), "<init>", "(" + fieldDescription + ")V");
        }
    }

    private void addManagedValueToStackForField(MethodVisitor mv, String fieldName, String fieldDescription) {
        Type t = Type.getType(fieldDescription);
        if (t.getSort() == 10 || t.getSort() == 9) {
            ByteCodeUtil.pushThis(mv);
            mv.visitMethodInsn(183, this.spec.getClassNameSlashes(), ByteCodeUtil.fieldGetterMethod(fieldName), "()" + fieldDescription);
        } else {
            mv.visitTypeInsn(187, ByteCodeUtil.sortToWrapperName(t.getSort()));
            mv.visitInsn(89);
            ByteCodeUtil.pushThis(mv);
            if (this.isRoot(fieldName)) {
                mv.visitMethodInsn(183, this.spec.getClassNameSlashes(), ByteCodeUtil.fieldGetterMethod(fieldName), "()" + fieldDescription);
            } else {
                mv.visitFieldInsn(180, this.spec.getClassNameSlashes(), fieldName, fieldDescription);
            }
            mv.visitMethodInsn(183, ByteCodeUtil.sortToWrapperName(t.getSort()), "<init>", "(" + fieldDescription + ")V");
        }
    }

    protected void basicVisit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cv.visit(version, access, name, signature, superName, interfaces);
    }

    protected FieldVisitor basicVisitField(int access, String name, String desc, String signature, Object value) {
        return this.cv.visitField(access, name, desc, signature, value);
    }

    protected MethodVisitor basicVisitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return this.cv.visitMethod(access, name, desc, signature, exceptions);
    }

    protected void basicVisitEnd() {
        this.cv.visitEnd();
    }

    private static Collection getInterfaceMethodDescriptions(Class iface) {
        HashSet<String> rv = new HashSet<String>();
        Method[] methods = iface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            rv.add(method.getName() + Type.getMethodDescriptor(method));
        }
        return rv;
    }
}

