/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.appevent;

import com.tc.util.NonPortableReason;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class NonPortableObjectState
implements Serializable {
    private String label;
    private String fieldName;
    private String typeName;
    private boolean isPortable;
    private boolean isTransient;
    private boolean neverPortable;
    private boolean isPreInstrumented;
    private boolean isRepeated;
    private boolean isSystemType;
    private boolean isNull;
    private String explaination;
    private NonPortableReason nonPortableReason;
    private List requiredBootTypes;
    private List requiredIncludeTypes;

    public NonPortableObjectState() {
        this(null, null, null, false, false, false, false, false, false, false);
    }

    public NonPortableObjectState(String label, String fieldName, String typeName, boolean isPortable, boolean isTransient, boolean neverPortable, boolean isPreInstrumented, boolean isRepeated, boolean isSystemType, boolean isNull) {
        this.label = label;
        this.fieldName = fieldName;
        this.typeName = typeName;
        this.isPortable = isPortable;
        this.isTransient = isTransient;
        this.neverPortable = neverPortable;
        this.isPreInstrumented = isPreInstrumented;
        this.isRepeated = isRepeated;
        this.isSystemType = isSystemType;
        this.isNull = isNull;
    }

    public void setExplaination(String explaination) {
        this.explaination = explaination;
    }

    public String getExplaination() {
        return this.explaination;
    }

    public void setNonPortableReason(NonPortableReason nonPortableReason) {
        this.nonPortableReason = nonPortableReason;
        this.requiredBootTypes = new ArrayList(nonPortableReason.getErroneousBootJarSuperClasses());
        if (this.isRequiredBootJarType()) {
            this.requiredBootTypes.add(this.getTypeName());
        }
        this.requiredIncludeTypes = new ArrayList(nonPortableReason.getErroneousSuperClasses());
        if (this.isRequiredIncludeType()) {
            this.requiredIncludeTypes.add(this.getTypeName());
        }
    }

    public NonPortableReason getNonPortableReason() {
        return this.nonPortableReason;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean isPortable() {
        return this.isPortable;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isNeverPortable() {
        return this.neverPortable;
    }

    public boolean isPreInstrumented() {
        return this.isPreInstrumented;
    }

    public boolean isSystemType() {
        return this.isSystemType;
    }

    public boolean isRepeated() {
        return this.isRepeated;
    }

    public boolean isNull() {
        return this.isNull;
    }

    public List getRequiredBootTypes() {
        return this.requiredBootTypes;
    }

    public List getRequiredIncludeTypes() {
        return this.requiredIncludeTypes;
    }

    public List getNonPortableBaseTypes() {
        return this.nonPortableReason != null ? this.nonPortableReason.getErroneousSuperClasses() : null;
    }

    public boolean extendsLogicallyManagedType() {
        if (this.nonPortableReason != null) {
            return this.nonPortableReason.getReason() == 3;
        }
        return false;
    }

    public boolean isRequiredBootJarType() {
        if (this.nonPortableReason != null) {
            return this.nonPortableReason.getReason() == 4;
        }
        return false;
    }

    public boolean isRequiredIncludeType() {
        if (this.nonPortableReason != null) {
            return this.nonPortableReason.getReason() == 5;
        }
        return false;
    }

    public String summary() {
        StringBuffer sb = new StringBuffer();
        String l = this.getLabel();
        if (l == null) {
            return "NonPortableTreeRoot";
        }
        sb.append(l);
        if (this.isNeverPortable()) {
            sb.append(" Never portable");
        } else {
            sb.append(this.isPortable() ? " portable" : " not portable");
        }
        if (this.isTransient()) {
            sb.append(", transient");
        }
        if (this.isPreInstrumented()) {
            sb.append(", pre-instrumented");
        }
        if (this.isRepeated()) {
            sb.append(", repeated");
        }
        if (this.isSystemType()) {
            sb.append(", system type");
        }
        return sb.toString();
    }
}

