/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.lock.stats;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import java.io.IOException;
import java.io.Serializable;

public class LockStats
implements TCSerializable,
Serializable {
    private static final int NON_SET_TIME_MILLIS = -1;
    private long totalRecordedNumberOfPendingRequests;
    private long numOfLockRequested;
    private long numOfLockHopRequests;
    private long totalWaitTimeToAwardedInMillis;
    private long numOfLockAwarded;
    private long totalRecordedHeldTimeInMillis;
    private long totalRecordedReleases;
    private long avgHeldTimeInMillis = -1L;
    private long avgWaitTimeToAwardInMillis = -1L;
    private long totalNestedDepth;

    public void aggregateStatistics(long pendingRequests, long lockRequested, long lockHopRequests, long lockAwarded, long timeToAwardedInMillis, long heldTimeInMillis, long numOfReleases) {
        this.totalRecordedNumberOfPendingRequests += pendingRequests;
        this.numOfLockRequested += lockRequested;
        this.numOfLockHopRequests += lockHopRequests;
        this.numOfLockAwarded += lockAwarded;
        this.totalWaitTimeToAwardedInMillis += timeToAwardedInMillis;
        this.totalRecordedHeldTimeInMillis += heldTimeInMillis;
        this.totalRecordedReleases += numOfReleases;
        this.avgHeldTimeInMillis = this.getAvgHeldTimeInMillis();
        this.avgWaitTimeToAwardInMillis = this.getAvgWaitTimeToAwardInMillis();
    }

    public void clear() {
        this.totalRecordedNumberOfPendingRequests = 0L;
        this.numOfLockRequested = 0L;
        this.numOfLockHopRequests = 0L;
        this.numOfLockAwarded = 0L;
        this.totalWaitTimeToAwardedInMillis = 0L;
        this.totalRecordedHeldTimeInMillis = 0L;
        this.totalRecordedReleases = 0L;
        this.avgHeldTimeInMillis = -1L;
        this.avgWaitTimeToAwardInMillis = -1L;
    }

    public void recordLockRequested(int numberOfPendingRequests) {
        ++this.numOfLockRequested;
        this.totalRecordedNumberOfPendingRequests += (long)numberOfPendingRequests;
    }

    public void recordLockHopRequested() {
        ++this.numOfLockHopRequests;
    }

    public void recordLockAwarded(long waitTimeInMillis, int nestedLockDepth) {
        ++this.numOfLockAwarded;
        this.totalWaitTimeToAwardedInMillis += waitTimeInMillis;
        this.totalNestedDepth += (long)nestedLockDepth;
        this.getAvgWaitTimeToAwardInMillis();
    }

    public void aggregateLockWaitTime(long waitTimeInMillis) {
        this.totalWaitTimeToAwardedInMillis += waitTimeInMillis;
    }

    public void recordLockRejected() {
    }

    public void recordLockReleased(long heldTimeInMillis) {
        this.totalRecordedHeldTimeInMillis += heldTimeInMillis;
        ++this.totalRecordedReleases;
        this.getAvgHeldTimeInMillis();
    }

    public long getNumOfLockAwarded() {
        return this.numOfLockAwarded;
    }

    public long getNumOfLockHopRequests() {
        return this.numOfLockHopRequests;
    }

    public long getNumOfLockRequested() {
        return this.numOfLockRequested;
    }

    public long getNumOfLockReleased() {
        return this.totalRecordedReleases;
    }

    public long getNumOfLockPendingRequested() {
        return this.totalRecordedNumberOfPendingRequests;
    }

    public long getTotalRecordedHeldTimeInMillis() {
        return this.totalRecordedHeldTimeInMillis;
    }

    public long getTotalRecordedReleases() {
        return this.totalRecordedReleases;
    }

    public long getTotalWaitTimeToAwardedInMillis() {
        return this.totalWaitTimeToAwardedInMillis;
    }

    public void aggregateAvgHeldTimeInMillis(long totalHeldTimeInMillis, long numOfReleases) {
        this.avgHeldTimeInMillis = -1L;
        totalHeldTimeInMillis += this.totalRecordedHeldTimeInMillis;
        if ((numOfReleases += this.totalRecordedReleases) > 0L) {
            this.avgHeldTimeInMillis = totalHeldTimeInMillis / numOfReleases;
        }
    }

    public long getAvgHeldTimeInMillis() {
        this.aggregateAvgHeldTimeInMillis(0L, 0L);
        return this.avgHeldTimeInMillis;
    }

    public long getAvgWaitTimeToAwardInMillis() {
        this.aggregateAvgWaitTimeInMillis(0L, 0L);
        return this.avgWaitTimeToAwardInMillis;
    }

    public long getAvgNestedLockDepth() {
        if (this.numOfLockAwarded == 0L) {
            return 0L;
        }
        return this.totalNestedDepth / this.numOfLockAwarded;
    }

    public long getAvgNumberOfPendingRequests() {
        if (this.numOfLockRequested == 0L) {
            return 0L;
        }
        return this.totalRecordedNumberOfPendingRequests / this.numOfLockRequested;
    }

    public void aggregateAvgWaitTimeInMillis(long totalWaitTimeInMillis, long numOfAwarded) {
        this.avgWaitTimeToAwardInMillis = -1L;
        totalWaitTimeInMillis += this.totalWaitTimeToAwardedInMillis;
        if ((numOfAwarded += this.numOfLockAwarded) > 0L) {
            this.avgWaitTimeToAwardInMillis = totalWaitTimeInMillis / numOfAwarded;
        }
    }

    public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        this.totalRecordedNumberOfPendingRequests = serialInput.readLong();
        this.numOfLockRequested = serialInput.readLong();
        this.numOfLockHopRequests = serialInput.readLong();
        this.totalWaitTimeToAwardedInMillis = serialInput.readLong();
        this.numOfLockAwarded = serialInput.readLong();
        this.totalRecordedHeldTimeInMillis = serialInput.readLong();
        this.totalRecordedReleases = serialInput.readLong();
        this.avgHeldTimeInMillis = serialInput.readLong();
        this.avgWaitTimeToAwardInMillis = serialInput.readLong();
        this.totalNestedDepth = serialInput.readLong();
        return this;
    }

    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeLong(this.totalRecordedNumberOfPendingRequests);
        serialOutput.writeLong(this.numOfLockRequested);
        serialOutput.writeLong(this.numOfLockHopRequests);
        serialOutput.writeLong(this.totalWaitTimeToAwardedInMillis);
        serialOutput.writeLong(this.numOfLockAwarded);
        serialOutput.writeLong(this.totalRecordedHeldTimeInMillis);
        serialOutput.writeLong(this.totalRecordedReleases);
        serialOutput.writeLong(this.avgHeldTimeInMillis);
        serialOutput.writeLong(this.avgWaitTimeToAwardInMillis);
        serialOutput.writeLong(this.totalNestedDepth);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("numOfPendingRequests: ");
        sb.append(this.totalRecordedNumberOfPendingRequests);
        sb.append(", numOfLockRequested: ");
        sb.append(this.numOfLockRequested);
        sb.append(", numOfLockHopRequests: ");
        sb.append(this.numOfLockHopRequests);
        sb.append(", numOfLockAwarded: ");
        sb.append(this.numOfLockAwarded);
        sb.append(", totalRecordedReleases: ");
        sb.append(this.totalRecordedReleases);
        sb.append(", avgHeldTimeInMillis: ");
        sb.append(this.avgHeldTimeInMillis);
        sb.append(", avgWaitTimeToAwardInMillis: ");
        sb.append(this.avgWaitTimeToAwardInMillis);
        sb.append(", avgNestedDepth: ");
        sb.append(this.getAvgNestedLockDepth());
        return sb.toString();
    }
}

