/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.beans.object;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.AbstractTerracottaMBean;
import com.tc.management.beans.object.ObjectManagementMonitorMBean;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.management.NotCompliantMBeanException;

public class ObjectManagementMonitor
extends AbstractTerracottaMBean
implements ObjectManagementMonitorMBean {
    private static final TCLogger logger = TCLogging.getLogger(ObjectManagementMonitor.class);
    private volatile GCComptroller gcController;
    private final GCRunner gcRunner = new GCRunner(){
        private boolean isRunning = false;

        public void run() {
            this.setRunningState();
            ObjectManagementMonitor.this.gcController.startGC();
            this.setStopState();
        }

        private synchronized void setRunningState() {
            if (this.isRunning) {
                logger.warn("Cannot run DGC because DGC is already running.");
                return;
            }
            this.isRunning = true;
            logger.info("Running DGC.");
        }

        private synchronized void setStopState() {
            if (!this.isRunning) {
                logger.warn("Cannot stop DGC because DGC is not running.");
                return;
            }
            this.isRunning = false;
            logger.info("DGC finished.");
        }

        public synchronized boolean isGCRunning() {
            return this.isRunning;
        }
    };
    private ObjectIdsFetcher objectIdsFetcher;

    public ObjectManagementMonitor() throws NotCompliantMBeanException {
        super(ObjectManagementMonitorMBean.class, false);
    }

    public boolean isGCRunning() {
        return this.gcRunner.isGCRunning();
    }

    public synchronized boolean runGC() {
        if (!this.isEnabled()) {
            logger.warn("Cannot run DGC because mBean is not enabled.");
        }
        if (this.gcController == null) {
            throw new RuntimeException("Failure: see log for more information");
        }
        if (!this.gcController.isGCStarted()) {
            logger.warn("Cannot run DGC externally because this server is in PASSIVE state and DGC is disabled.");
        }
        if (this.gcController.isGCDisabled()) {
            throw new UnsupportedOperationException("Cannot run DGC externally because PASSIVE server(s) are currently synching state with this ACTIVE server and DGC is disabled.");
        }
        if (this.isGCRunning()) {
            logger.warn("Cannot run DGC because DGC is already running.");
        }
        if (!this.gcController.isGCStarted()) {
            logger.warn("Cannot run DGC externally because this server is in PASSIVE state and DGC is disabled.");
            return false;
        }
        if (this.gcController.isGCDisabled()) {
            logger.warn("Cannot run DGC externally because PASSIVE server(s) are currently synching state with this ACTIVE server and DGC is disabled.");
            return false;
        }
        if (this.isGCRunning()) {
            logger.warn("Cannot run DGC because DGC is already running.");
            return false;
        }
        Thread gcRunnerThread = new Thread(this.gcRunner);
        gcRunnerThread.setName("DGCRunnerThread");
        gcRunnerThread.start();
        return true;
    }

    public synchronized void reset() {
    }

    public void registerGCController(GCComptroller controller) {
        if (this.isEnabled()) {
            if (this.gcController != null) {
                logger.warn("Registering new dgc-controller while one already registered. Old : " + this.gcController);
            }
            this.gcController = controller;
        }
    }

    public void registerObjectIdFetcher(ObjectIdsFetcher fetcher) {
        this.objectIdsFetcher = fetcher;
    }

    public SortedSet getAllObjectIds() {
        Set set = this.objectIdsFetcher.getAllObjectIds();
        TreeSet treeSet = new TreeSet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            treeSet.add(iter.next());
        }
        return treeSet;
    }

    static interface GCRunner
    extends Runnable {
        public boolean isGCRunning();
    }

    public static interface ObjectIdsFetcher {
        public Set getAllObjectIds();
    }

    public static interface GCComptroller {
        public void startGC();

        public boolean isGCDisabled();

        public boolean isGCStarted();
    }
}

