/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.ConnectException;
import java.text.MessageFormat;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class JMXConnectorProxy
implements JMXConnector {
    private final String m_host;
    private final int m_port;
    private final Map m_env;
    private JMXServiceURL m_serviceURL;
    private JMXConnector m_connector;
    private final JMXConnector m_connectorProxy;
    public static final String JMXMP_URI_PATTERN = "service:jmx:jmxmp://{0}:{1}";
    public static final String JMXRMI_URI_PATTERN = "service:jmx:rmi:///jndi/rmi://{0}:{1}/jmxrmi";

    public JMXConnectorProxy(String host, int port, Map env) {
        this.m_host = host;
        this.m_port = port;
        this.m_env = env;
        this.m_connectorProxy = this.getConnectorProxy();
    }

    public JMXConnectorProxy(String host, int port) {
        this(host, port, null);
    }

    private JMXConnector getConnectorProxy() {
        JMXConnector connector = (JMXConnector)Proxy.newProxyInstance(JMXConnector.class.getClassLoader(), new Class[]{JMXConnector.class}, (InvocationHandler)new ConnectorInvocationHandler());
        return connector;
    }

    static boolean isConnectException(IOException ioe) {
        for (Throwable t = ioe; t != null; t = t.getCause()) {
            if (!(t instanceof ConnectException)) continue;
            return true;
        }
        return false;
    }

    private void determineConnector() throws Exception {
        JMXServiceURL url = new JMXServiceURL(JMXConnectorProxy.getSecureJMXConnectorURL(this.m_host, this.m_port));
        try {
            this.m_connector = JMXConnectorFactory.connect(url, this.m_env);
            this.m_serviceURL = url;
        }
        catch (IOException ioe) {
            if (JMXConnectorProxy.isConnectException(ioe)) {
                throw ioe;
            }
            url = new JMXServiceURL(JMXConnectorProxy.getJMXConnectorURL(this.m_host, this.m_port));
            this.m_connector = JMXConnectorFactory.connect(url, this.m_env);
            this.m_serviceURL = url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testForDsoPort() {
        HttpClient client = new HttpClient();
        String url = MessageFormat.format("http://{0}:{1}/config", this.m_host, Integer.toString(this.m_port));
        GetMethod get = new GetMethod(url);
        try {
            int status = client.executeMethod((HttpMethod)get);
            if (status == 200) {
                throw new RuntimeException("Please specify the JMX port, not the DSO port");
            }
        }
        catch (IOException ioe) {
        }
        finally {
            get.releaseConnection();
        }
    }

    private void ensureConnector() throws Exception {
        if (this.m_connector == null) {
            this.testForDsoPort();
            this.determineConnector();
        }
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public JMXServiceURL getServiceURL() {
        return this.m_serviceURL;
    }

    public static String getJMXConnectorURL(String host, int port) {
        return MessageFormat.format(JMXMP_URI_PATTERN, host, port + "");
    }

    public static String getSecureJMXConnectorURL(String host, int port) {
        return MessageFormat.format(JMXRMI_URI_PATTERN, host, port + "");
    }

    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object data) {
        this.m_connectorProxy.addConnectionNotificationListener(listener, filter, data);
    }

    public void close() throws IOException {
        this.m_connectorProxy.close();
    }

    public void connect() throws IOException {
        this.m_connectorProxy.connect();
    }

    public void connect(Map env) throws IOException {
        this.m_connectorProxy.connect(env);
    }

    public String getConnectionId() throws IOException {
        return this.m_connectorProxy.getConnectionId();
    }

    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.m_connectorProxy.getMBeanServerConnection();
    }

    public MBeanServerConnection getMBeanServerConnection(Subject subject) throws IOException {
        return this.m_connectorProxy.getMBeanServerConnection(subject);
    }

    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.m_connectorProxy.removeConnectionNotificationListener(listener);
    }

    public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object data) throws ListenerNotFoundException {
        this.m_connectorProxy.removeConnectionNotificationListener(listener, filter, data);
    }

    public String toString() {
        return this.m_host + ":" + this.m_port;
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    class ConnectorInvocationHandler
    implements InvocationHandler {
        ConnectorInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            JMXConnectorProxy.this.ensureConnector();
            try {
                Class<?> c = JMXConnectorProxy.this.m_connector.getClass();
                Method m = c.getMethod(method.getName(), method.getParameterTypes());
                return m.invoke((Object)JMXConnectorProxy.this.m_connector, args);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause != null) {
                    throw cause;
                }
                throw ite;
            }
        }
    }
}

