/*
 * Decompiled with CFR 0.152.
 */
package com.tc.logging;

import com.tc.logging.BufferingAppender;
import com.tc.logging.CustomerLogging;
import com.tc.logging.DelegatingAppender;
import com.tc.logging.Log4JAppenderToTCAppender;
import com.tc.logging.Log4jSafeInit;
import com.tc.logging.TCAppender;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLoggerImpl;
import com.tc.logging.TCRollingFileAppender;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.ProductInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.varia.NullAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCLogging {
    private static final int MAX_BUFFERED_LOG_MESSAGES = 10000;
    private static final String TERRACOTTA_L1_LOG_FILE_NAME = "terracotta-client.log";
    private static final String TERRACOTTA_L2_LOG_FILE_NAME = "terracotta-server.log";
    private static final String TERRACOTTA_GENERIC_LOG_FILE_NAME = "terracotta-generic.log";
    private static final String LOCK_FILE_NAME = ".terracotta-logging.lock";
    private static final String[] INTERNAL_LOGGER_NAMESPACES = new String[]{"com.tc", "com.terracottatech", "org.terracotta"};
    private static final String CUSTOMER_LOGGER_NAMESPACE = "com.terracottatech";
    private static final String CUSTOMER_LOGGER_NAMESPACE_WITH_DOT = "com.terracottatech.";
    private static final String CONSOLE_LOGGER_NAME = "com.terracottatech.console";
    public static final String DUMP_LOGGER_NAME = "com.tc.dumper.dump";
    private static final String LOGGING_PROPERTIES_SECTION = "logging";
    private static final String MAX_LOG_FILE_SIZE_PROPERTY = "maxLogFileSize";
    private static final int DEFAULT_MAX_LOG_FILE_SIZE = 512;
    private static final String MAX_BACKUPS_PROPERTY = "maxBackups";
    private static final int DEFAULT_MAX_BACKUPS = 20;
    private static final String LOG4J_PROPERTIES_FILENAME = ".tc.dev.log4j.properties";
    private static final String CONSOLE_PATTERN = "%d %p - %m%n";
    public static final String DUMP_PATTERN = "[dump] %m%n";
    private static final String CONSOLE_PATTERN_DEVELOPMENT = "%d [%t] %p %c - %m%n";
    private static final String CONSOLE_LOGGING_ONLY_PATTERN = "[TC] %d %p - %m%n";
    public static final String FILE_AND_JMX_PATTERN = "%d [%t] %p %c - %m%n";
    private static TCLogger console;
    private static Appender consoleAppender;
    private static DelegatingAppender delegateFileAppender;
    private static DelegatingAppender delegateBufferingAppender;
    private static boolean buffering;
    private static Logger[] allLoggers;
    private static File currentLoggingDirectory;
    private static FileLock currentLoggingDirectoryFileLock;
    private static boolean lockingDisabled;
    public static final int PROCESS_TYPE_GENERIC = 0;
    public static final int PROCESS_TYPE_L1 = 1;
    public static final int PROCESS_TYPE_L2 = 2;

    public static TCLogger getLogger(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return TCLogging.getLogger(clazz.getName());
    }

    public static TCLogger getLogger(String name) {
        if (name == null) {
            throw new NullPointerException("Logger cannot be null");
        }
        boolean allowedName = false;
        for (String namespace : INTERNAL_LOGGER_NAMESPACES) {
            String withDot = namespace + ".";
            if (!name.startsWith(withDot)) continue;
            allowedName = true;
            break;
        }
        if (!allowedName) {
            throw new IllegalArgumentException("Logger name (" + name + ") not in valid namespace: " + Arrays.asList(INTERNAL_LOGGER_NAMESPACES));
        }
        return new TCLoggerImpl(name);
    }

    public static TCLogger getTestingLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        return new TCLoggerImpl(name);
    }

    public static TCLogger getTestingLogger(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return TCLogging.getTestingLogger(clazz.getName());
    }

    static TCLogger getCustomerLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        name = CUSTOMER_LOGGER_NAMESPACE_WITH_DOT + name;
        if (CONSOLE_LOGGER_NAME.equals(name)) {
            throw new IllegalArgumentException("Illegal name: " + name);
        }
        return new TCLoggerImpl(name);
    }

    static TCLogger getConsoleLogger() {
        return console;
    }

    private static void reportLoggingError(Exception e) {
        TCLogging.reportLoggingError(null, e);
    }

    private static void reportLoggingError(String message, Exception e) {
        String newLine = System.getProperty("line.separator");
        StringBuffer errorMsg = new StringBuffer(newLine);
        if (message != null) {
            errorMsg.append("WARN: ").append(message).append(newLine);
        }
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            errorMsg.append(sw.toString());
        }
        System.err.println(errorMsg.toString());
    }

    private static boolean developmentConfiguration() {
        try {
            Properties devLoggingProperties = new Properties();
            File[] devLoggingLocations = new File[]{new File(System.getProperty("user.home"), LOG4J_PROPERTIES_FILENAME), new File(System.getProperty("user.dir"), LOG4J_PROPERTIES_FILENAME)};
            boolean devLog4JPropsFilePresent = false;
            for (int pos = 0; pos < devLoggingLocations.length; ++pos) {
                File propFile = devLoggingLocations[pos];
                if (!propFile.isFile() || !propFile.canRead()) continue;
                devLog4JPropsFilePresent = true;
                devLoggingProperties.load(new FileInputStream(propFile));
            }
            if (devLog4JPropsFilePresent) {
                Logger.getRootLogger().setLevel(Level.INFO);
                PropertyConfigurator.configure((Properties)devLoggingProperties);
                return true;
            }
        }
        catch (Exception e) {
            TCLogging.reportLoggingError(e);
        }
        return false;
    }

    public static synchronized void disableLocking() {
        lockingDisabled = true;
        if (currentLoggingDirectoryFileLock != null) {
            try {
                currentLoggingDirectoryFileLock.release();
                currentLoggingDirectoryFileLock = null;
            }
            catch (IOException ioe) {
                throw Assert.failure("Unable to release file lock?", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogDirectory(File theDirectory, int processType) {
        Assert.assertNotNull(theDirectory);
        if (theDirectory.getName().trim().equalsIgnoreCase("stdout:") || theDirectory.getName().trim().equalsIgnoreCase("stderr:")) {
            if (currentLoggingDirectory != null && currentLoggingDirectory.getName().trim().equalsIgnoreCase(theDirectory.getName())) {
                return;
            }
            delegateFileAppender.setDelegate((Appender)new NullAppender());
            consoleAppender.setLayout((Layout)new PatternLayout(CONSOLE_LOGGING_ONLY_PATTERN));
            Logger.getRootLogger().addAppender(consoleAppender);
            if (buffering) {
                BufferingAppender realBufferingAppender = (BufferingAppender)delegateBufferingAppender.setDelegate((Appender)new NullAppender());
                realBufferingAppender.stopAndSendContentsTo(consoleAppender);
                realBufferingAppender.close();
                buffering = false;
            }
            boolean stdout = theDirectory.getName().trim().equalsIgnoreCase("stdout:");
            TCLogging.getConsoleLogger().info("All logging information now output to standard " + (stdout ? "output" : "error") + ".");
            return;
        }
        Class<TCLogging> stdout = TCLogging.class;
        synchronized (TCLogging.class) {
            String logFileName;
            if (currentLoggingDirectory != null) {
                try {
                    if (theDirectory.getCanonicalPath().equals(currentLoggingDirectory.getCanonicalPath())) {
                        // ** MonitorExit[stdout] (shouldn't be in output)
                        return;
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            // ** MonitorExit[stdout] (shouldn't be in output)
            try {
                FileUtils.forceMkdir((File)theDirectory);
            }
            catch (IOException ioe) {
                TCLogging.reportLoggingError("We can't create the directory '" + theDirectory.getAbsolutePath() + "' that you specified for your logs.", ioe);
                return;
            }
            if (!theDirectory.canWrite()) {
                TCLogging.reportLoggingError("The log directory, '" + theDirectory.getAbsolutePath() + "', can't be written to.", null);
                return;
            }
            FileLock thisDirectoryLock = null;
            if (!lockingDisabled) {
                File lockFile = new File(theDirectory, LOCK_FILE_NAME);
                try {
                    if (!lockFile.exists()) {
                        lockFile.createNewFile();
                    }
                    Assert.eval(lockFile.exists());
                    FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();
                    thisDirectoryLock = channel.tryLock();
                    if (thisDirectoryLock == null) {
                        TCLogging.reportLoggingError("The log directory, '" + theDirectory.getAbsolutePath() + "', is already in use by another " + "Terracotta process. Logging will proceed to the console only.", null);
                        return;
                    }
                }
                catch (OverlappingFileLockException ofle) {
                }
                catch (IOException ioe) {
                    TCLogging.reportLoggingError("We can't lock the file '" + lockFile.getAbsolutePath() + "', to make sure that only one " + "Terracotta process is using this directory for logging. This may be a permission " + "issue, or some unexpected error. Logging will proceed to the console only.", ioe);
                    return;
                }
            }
            switch (processType) {
                case 1: {
                    logFileName = TERRACOTTA_L1_LOG_FILE_NAME;
                    break;
                }
                case 2: {
                    logFileName = TERRACOTTA_L2_LOG_FILE_NAME;
                    break;
                }
                case 0: {
                    logFileName = TERRACOTTA_GENERIC_LOG_FILE_NAME;
                    break;
                }
                default: {
                    throw Assert.failure("Unknown process type: " + processType);
                }
            }
            String logFilePath = new File(theDirectory, logFileName).getAbsolutePath();
            Class<TCLogging> clazz = TCLogging.class;
            synchronized (TCLogging.class) {
                try {
                    TCProperties props = TCPropertiesImpl.getProperties().getPropertiesFor(LOGGING_PROPERTIES_SECTION);
                    TCRollingFileAppender newFileAppender = new TCRollingFileAppender((Layout)new PatternLayout("%d [%t] %p %c - %m%n"), logFilePath, true);
                    newFileAppender.setName("file appender");
                    int maxLogFileSize = props.getInt(MAX_LOG_FILE_SIZE_PROPERTY, 512);
                    newFileAppender.setMaxFileSize(maxLogFileSize + "MB");
                    newFileAppender.setMaxBackupIndex(props.getInt(MAX_BACKUPS_PROPERTY, 20));
                    newFileAppender.rollOver();
                    Appender oldFileAppender = delegateFileAppender.setDelegate((Appender)newFileAppender);
                    if (oldFileAppender != null) {
                        oldFileAppender.close();
                    }
                    if (buffering) {
                        BufferingAppender realBufferingAppender = (BufferingAppender)delegateBufferingAppender.setDelegate((Appender)new NullAppender());
                        realBufferingAppender.stopAndSendContentsTo(delegateFileAppender);
                        realBufferingAppender.close();
                        buffering = false;
                    }
                    currentLoggingDirectory = theDirectory;
                    if (currentLoggingDirectoryFileLock != null) {
                        currentLoggingDirectoryFileLock.release();
                    }
                    currentLoggingDirectoryFileLock = thisDirectoryLock;
                }
                catch (IOException ioe) {
                    TCLogging.reportLoggingError("We were unable to switch the logging system to log to '" + logFilePath + "'.", ioe);
                }
                TCLogging.getConsoleLogger().info("Log file: '" + logFilePath + "'.");
                TCLogging.writeSystemProperties();
                return;
            }
        }
    }

    public static TCLogger getDumpLogger() {
        TCLoggerImpl loggerTemp = new TCLoggerImpl(DUMP_LOGGER_NAME);
        boolean isDev = TCLogging.developmentConfiguration();
        if (isDev) {
            loggerTemp.getLogger().setAdditivity(false);
            ConsoleAppender consoleAppenderTemp = new ConsoleAppender((Layout)new PatternLayout(DUMP_PATTERN));
            loggerTemp.getLogger().addAppender((Appender)consoleAppenderTemp);
        }
        return loggerTemp;
    }

    public static Log4JAppenderToTCAppender addAppender(String loggerName, TCAppender appender) {
        Log4JAppenderToTCAppender wrappedAppender = new Log4JAppenderToTCAppender(appender);
        new TCLoggerImpl(loggerName).getLogger().addAppender((Appender)wrappedAppender);
        return wrappedAppender;
    }

    public static void removeAppender(String loggerName, Log4JAppenderToTCAppender appender) {
        new TCLoggerImpl(loggerName).getLogger().removeAppender((Appender)appender);
    }

    private static Logger[] createAllLoggerList(List<Logger> internalLoggers, Logger customerLogger) {
        ArrayList<Logger> loggers = new ArrayList<Logger>();
        loggers.addAll(internalLoggers);
        loggers.add(customerLogger);
        return loggers.toArray(new Logger[0]);
    }

    public static void addToAllLoggers(Appender appender) {
        for (int i = 0; i < allLoggers.length; ++i) {
            allLoggers[i].addAppender(appender);
        }
    }

    private static void writeVersion() {
        ProductInfo info = ProductInfo.getInstance();
        TCLogger consoleLogger = CustomerLogging.getConsoleLogger();
        String longProductString = info.toLongString();
        consoleLogger.info(longProductString);
        if (info.isPatched()) {
            String longPatchString = info.toLongPatchString();
            consoleLogger.info(longPatchString);
        }
    }

    private static void writeSystemProperties() {
        try {
            Properties properties = System.getProperties();
            int maxKeyLength = 1;
            ArrayList<String> keys = new ArrayList<String>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object objKey = entry.getKey();
                Object objValue = entry.getValue();
                if (!(objKey instanceof String) || !(objValue instanceof String)) continue;
                String key = (String)objKey;
                keys.add(key);
                maxKeyLength = Math.max(maxKeyLength, key.length());
            }
            String nl = System.getProperty("line.separator");
            StringBuffer data = new StringBuffer();
            data.append("All Java System Properties for this Terracotta instance:");
            data.append(nl);
            data.append("========================================================================");
            data.append(nl);
            Object[] sortedKeys = keys.toArray(new String[keys.size()]);
            Arrays.sort(sortedKeys);
            for (int i = 0; i < sortedKeys.length; ++i) {
                Object key = sortedKeys[i];
                data.append(StringUtils.rightPad((String)key, (int)maxKeyLength));
                data.append(": ");
                data.append(properties.get(key));
                data.append(nl);
            }
            data.append("========================================================================");
            TCLogging.getLogger(TCLogging.class).info(data.toString());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void closeFileAppender() {
        if (delegateFileAppender != null) {
            delegateFileAppender.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        currentLoggingDirectoryFileLock = null;
        lockingDisabled = false;
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(TCLogging.class.getClassLoader());
        Log4jSafeInit.init();
        try {
            currentLoggingDirectory = null;
            Logger jettyLogger = Logger.getLogger((String)"org.mortbay");
            jettyLogger.setLevel(Level.OFF);
            ArrayList<Logger> internalLoggers = new ArrayList<Logger>();
            for (String nameSpace : INTERNAL_LOGGER_NAMESPACES) {
                internalLoggers.add(Logger.getLogger((String)nameSpace));
            }
            Logger customerLogger = Logger.getLogger((String)CUSTOMER_LOGGER_NAMESPACE);
            Logger consoleLogger = Logger.getLogger((String)CONSOLE_LOGGER_NAME);
            allLoggers = TCLogging.createAllLoggerList(internalLoggers, customerLogger);
            console = new TCLoggerImpl(CONSOLE_LOGGER_NAME);
            for (Logger internalLogger : internalLoggers) {
                internalLogger.setLevel(Level.INFO);
            }
            customerLogger.setLevel(Level.INFO);
            consoleLogger.setLevel(Level.INFO);
            boolean isDev = TCLogging.developmentConfiguration();
            consoleAppender = new ConsoleAppender((Layout)new PatternLayout(CONSOLE_PATTERN), "System.err");
            if (!isDev) {
                consoleLogger.addAppender(consoleAppender);
            } else {
                consoleAppender.setLayout((Layout)new PatternLayout("%d [%t] %p %c - %m%n"));
                Logger.getRootLogger().addAppender(consoleAppender);
            }
            delegateFileAppender = new DelegatingAppender((Appender)new NullAppender());
            TCLogging.addToAllLoggers(delegateFileAppender);
            BufferingAppender realBufferingAppender = new BufferingAppender(10000);
            realBufferingAppender.setName("buffering appender");
            delegateBufferingAppender = new DelegatingAppender((Appender)realBufferingAppender);
            TCLogging.addToAllLoggers(delegateBufferingAppender);
            buffering = true;
            if (!isDev) {
                CustomerLogging.getGenericCustomerLogger().info("New logging session started.");
            }
            TCLogging.writeVersion();
        }
        catch (Exception e) {
            TCLogging.reportLoggingError(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }
}

