/*
 * Decompiled with CFR 0.152.
 */
package com.tc.logging;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class BufferingAppender
extends AppenderSkeleton {
    private final BoundedBuffer buffer;
    private boolean on;

    public BufferingAppender(int maxCapacity) {
        this.buffer = new BoundedBuffer(maxCapacity);
        this.on = true;
    }

    protected synchronized void append(LoggingEvent event) {
        if (this.on) {
            try {
                this.buffer.offer((Object)event, 0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAndSendContentsTo(Appender otherAppender) {
        BufferingAppender bufferingAppender = this;
        synchronized (bufferingAppender) {
            this.on = false;
        }
        while (true) {
            try {
                LoggingEvent event;
                while ((event = (LoggingEvent)this.buffer.poll(0L)) != null) {
                    otherAppender.doAppend(event);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

