/*
 * Decompiled with CFR 0.152.
 */
package com.tc.license.util;

import com.tc.license.util.Base64;
import com.tc.license.util.Signer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.io.IOUtils;

public class TerracottaSigner
implements Signer {
    private static final String LICENSE_PUBLIC_KEY_RESOURCE_NAME = "license-public-key.x509";

    public String sign(byte[] content, File privateKeyFile) {
        if (privateKeyFile == null) {
            throw new IllegalStateException("Private key file is needed to sign");
        }
        Signature signature = TerracottaSigner.prepareSignSignature(privateKeyFile);
        try {
            signature.update(content);
            byte[] signatureData = signature.sign();
            return Base64.encodeBytes(signatureData);
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean verify(byte[] content, String signatureString) {
        Signature signature = TerracottaSigner.prepareVerifySignature();
        try {
            signature.update(content);
            return signature.verify(Base64.decode(signatureString));
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    private static Signature prepareVerifySignature() {
        Signature signature;
        InputStream in = TerracottaSigner.class.getResourceAsStream(LICENSE_PUBLIC_KEY_RESOURCE_NAME);
        if (in == null) {
            throw new RuntimeException("Can't find public key: license-public-key.x509");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)baos);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(baos.toByteArray());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(publicKey);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return signature;
    }

    private static Signature prepareSignSignature(File keyFile) {
        Signature signature;
        if (keyFile == null || !keyFile.exists()) {
            throw new IllegalArgumentException("Private key file doesn't exist or unknown");
        }
        FileInputStream keyInputStream = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            keyInputStream = new FileInputStream(keyFile);
            IOUtils.copy((InputStream)keyInputStream, (OutputStream)baos);
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(baos.toByteArray());
            KeyFactory factory = KeyFactory.getInstance("DSA");
            PrivateKey privateKey = factory.generatePrivate(privateKeySpec);
            signature = Signature.getInstance("SHA1withDSA");
            signature.initSign(privateKey);
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(keyInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)keyInputStream);
        return signature;
    }
}

