/*
 * Decompiled with CFR 0.152.
 */
package com.tc.license.util;

import com.tc.license.Capability;
import com.tc.license.util.LicenseField;
import com.tc.license.util.TerracottaLicenseField;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.yamlbeans.YamlException;
import net.sourceforge.yamlbeans.YamlReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseDescriptor {
    private static final String DESCRIPTOR_RESOURCE = "license-descriptor.yml";
    private final Map descriptor;
    private final Map descriptionMap;

    public LicenseDescriptor() {
        this(DESCRIPTOR_RESOURCE);
    }

    public LicenseDescriptor(String descriptorResource) {
        InputStream in = LicenseDescriptor.class.getResourceAsStream(descriptorResource);
        if (in == null) {
            throw new RuntimeException("Descriptor resource not found: " + descriptorResource);
        }
        YamlReader reader = new YamlReader((Reader)new InputStreamReader(in));
        try {
            this.descriptor = (Map)reader.read();
        }
        catch (YamlException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        this.descriptionMap = (Map)LicenseDescriptor.get(this.descriptor, "Enterprise License Description");
    }

    public EnumSet<Capability> getLicensedCapabilities(String product) {
        Map licensedProducts = (Map)LicenseDescriptor.get(this.descriptor, "Licensed products");
        List values = (List)LicenseDescriptor.get(licensedProducts, product);
        return this.convertToCapabilitySet(values);
    }

    public EnumSet<Capability> getEnterpriseCapabilities() {
        List values = (List)LicenseDescriptor.get(this.descriptor, "Enterprise capabilities");
        return this.convertToCapabilitySet(values);
    }

    public EnumSet<Capability> getOpenSourceCapabilities() {
        List values = (List)LicenseDescriptor.get(this.descriptor, "Opensource capabilities");
        return this.convertToCapabilitySet(values);
    }

    public Map getDescriptionMap() {
        return this.descriptionMap;
    }

    public LicenseField createField(String fieldName) {
        Map fieldMap = (Map)LicenseDescriptor.get(this.descriptionMap, fieldName);
        String type = (String)LicenseDescriptor.get(fieldMap, "type");
        String pattern = (String)fieldMap.get("pattern");
        boolean required = Boolean.valueOf((String)LicenseDescriptor.get(fieldMap, "required"));
        Map range = (Map)fieldMap.get("range");
        return new TerracottaLicenseField(fieldName, type, pattern, required, range);
    }

    public List<LicenseField> getFields() {
        ArrayList<LicenseField> list = new ArrayList<LicenseField>();
        Set fieldNames = this.descriptionMap.keySet();
        for (String fieldName : fieldNames) {
            LicenseField field = this.createField(fieldName);
            list.add(field);
        }
        return list;
    }

    private static Object get(Map map, String key) {
        Object value = map.get(key);
        if (value != null) {
            return value;
        }
        throw new RuntimeException("Field " + key + " couldn't be found in resource: " + DESCRIPTOR_RESOURCE);
    }

    private EnumSet<Capability> convertToCapabilitySet(List values) {
        EnumSet<Capability> result = EnumSet.noneOf(Capability.class);
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Capability c = Capability.parse((String)it.next());
            result.add(c);
        }
        return result;
    }
}

