/*
 * Decompiled with CFR 0.152.
 */
package com.tc.license;

import com.tc.license.Capabilities;
import com.tc.license.Capability;
import com.tc.license.EnterpriseLicense;
import com.tc.license.OpenSourceLicense;
import com.tc.license.util.LicenseDescriptor;
import com.tc.license.util.LicenseException;
import com.tc.license.util.LicenseField;
import java.util.Date;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseFactory {
    private static final LicenseDescriptor descriptor = new LicenseDescriptor();

    public static EnterpriseLicense createEnterpriseLicense(String licenseType, String licenseNumber, String licensee, String product, String maxClients, String expirationDate) throws LicenseException {
        LicenseField productField = LicenseFactory.createField("Product", product);
        EnumSet<Capability> licensedCapabilities = descriptor.getLicensedCapabilities((String)productField.getValue());
        return LicenseFactory.createLicense(licenseType, licenseNumber, licensee, product, maxClients, expirationDate, licensedCapabilities);
    }

    public static EnterpriseLicense createEnterpriseLicense(String licenseType, String licenseNumber, String licensee, String product, String maxClients, String expirationDate, String licensedCapabilities) throws LicenseException {
        return LicenseFactory.createLicense(licenseType, licenseNumber, licensee, product, maxClients, expirationDate, Capability.toSet(licensedCapabilities));
    }

    public static OpenSourceLicense createOpenSourceLicense() {
        Capabilities openSourceCapabilities = new Capabilities(descriptor.getLicensedCapabilities("ES"), descriptor.getOpenSourceCapabilities());
        return new OpenSourceLicense(openSourceCapabilities);
    }

    private static EnterpriseLicense createLicense(String type, String number, String licensee, String product, String maxClients, String expirationDate, EnumSet<Capability> licensedCapabilities) throws LicenseException {
        LicenseField typeField = LicenseFactory.createField("License type", type);
        LicenseField numberField = LicenseFactory.createField("License number", number);
        LicenseField licenseeField = LicenseFactory.createField("Licensee", licensee);
        LicenseField maxClientField = LicenseFactory.createField("Max clients", maxClients);
        LicenseField productField = LicenseFactory.createField("Product", product);
        LicenseField expiredDateField = LicenseFactory.createField("Expiration date", expirationDate);
        Capabilities capabilities = new Capabilities(licensedCapabilities, new LicenseDescriptor().getEnterpriseCapabilities());
        EnterpriseLicense license = new EnterpriseLicense((String)typeField.getValue(), (String)numberField.getValue(), (String)licenseeField.getValue(), (String)productField.getValue(), (Integer)maxClientField.getValue(), (Date)expiredDateField.getValue(), capabilities);
        return license;
    }

    private static LicenseField createField(String name, String value) throws LicenseException {
        LicenseField field = descriptor.createField(name);
        field.setRawValue(value);
        return field;
    }
}

