/*
 * Decompiled with CFR 0.152.
 */
package com.tc.exception;

import com.tc.exception.ExceptionHelper;
import java.util.LinkedList;
import java.util.List;

public class ExceptionHelperImpl
implements ExceptionHelper {
    private final List helpers = new LinkedList();
    private final ExceptionHelper nullHelper = new NullExceptionHelper();

    public boolean accepts(Throwable t) {
        return true;
    }

    public void addHelper(ExceptionHelper helper) {
        this.helpers.add(helper);
    }

    public Throwable getProximateCause(Throwable t) {
        return this.getHelperFor(t).getProximateCause(t);
    }

    public Throwable getUltimateCause(Throwable t) {
        Throwable rv = this.getProximateCause(t);
        while (rv != this.getProximateCause(rv)) {
            rv = this.getProximateCause(rv);
        }
        return rv;
    }

    private ExceptionHelper getHelperFor(Throwable t) {
        for (ExceptionHelper helper : this.helpers) {
            if (!helper.accepts(t)) continue;
            return helper;
        }
        return this.nullHelper;
    }

    private static final class NullExceptionHelper
    implements ExceptionHelper {
        private NullExceptionHelper() {
        }

        public boolean accepts(Throwable t) {
            return true;
        }

        public Throwable getProximateCause(Throwable t) {
            return t;
        }

        public Throwable getUltimateCause(Throwable t) {
            return t;
        }
    }
}

