/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.beanfactory.BeanWithErrors;
import com.tc.config.schema.beanfactory.ConfigBeanFactory;
import com.tc.config.schema.defaults.FromSchemaDefaultValueProvider;
import com.tc.config.schema.dynamic.ParameterSubstituter;
import com.tc.config.schema.repository.ApplicationsRepository;
import com.tc.config.schema.repository.MutableBeanRepository;
import com.tc.config.schema.setup.ConfigurationCreator;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.sources.ConfigurationSource;
import com.tc.config.schema.setup.sources.FileConfigurationSource;
import com.tc.config.schema.setup.sources.ResourceConfigurationSource;
import com.tc.config.schema.setup.sources.ServerConfigurationSource;
import com.tc.config.schema.setup.sources.URLConfigurationSource;
import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.util.Assert;
import com.terracottatech.config.Server;
import com.terracottatech.config.Servers;
import com.terracottatech.config.TcConfigDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;
import org.xml.sax.SAXException;

public class StandardXMLFileConfigurationCreator
implements ConfigurationCreator {
    private static final TCLogger consoleLogger = CustomerLogging.getConsoleLogger();
    private static final long GET_CONFIGURATION_TOTAL_TIMEOUT = 300000L;
    private static final long GET_CONFIGURATION_ONE_SOURCE_TIMEOUT = 30000L;
    private static final long MIN_RETRY_TIMEOUT = 5000L;
    private final String configurationSpec;
    private final File defaultDirectory;
    private final ConfigBeanFactory beanFactory;
    private final TCLogger logger;
    private String configDescription;
    private boolean loadedFromTrustedSource;
    private File directoryLoadedFrom;
    private String rawConfigText;
    private static final Pattern SERVER_PATTERN = Pattern.compile("(.*):(.*)", 2);
    private static final Pattern RESOURCE_PATTERN = Pattern.compile("resource://(.*)", 2);
    private static final Pattern URL_PATTERN = Pattern.compile("[A-Za-z][A-Za-z]+://.*");
    private static final String WILDCARD_IP = "0.0.0.0";

    public StandardXMLFileConfigurationCreator(String configurationSpec, File defaultDirectory, ConfigBeanFactory beanFactory) {
        this(TCLogging.getLogger(StandardXMLFileConfigurationCreator.class), configurationSpec, defaultDirectory, beanFactory);
    }

    public StandardXMLFileConfigurationCreator(TCLogger logger, String configurationSpec, File defaultDirectory, ConfigBeanFactory beanFactory) {
        Assert.assertNotBlank(configurationSpec);
        Assert.assertNotNull(defaultDirectory);
        Assert.assertNotNull(beanFactory);
        this.logger = logger;
        this.configurationSpec = configurationSpec;
        this.defaultDirectory = defaultDirectory;
        this.beanFactory = beanFactory;
        this.configDescription = null;
    }

    private ConfigurationSource[] createConfigurationSources() throws ConfigurationSetupException {
        String[] components = this.configurationSpec.split(",");
        ConfigurationSource[] out = new ConfigurationSource[components.length];
        for (int i = 0; i < components.length; ++i) {
            String thisComponent = components[i];
            ConfigurationSource source = this.attemptToCreateServerSource(thisComponent);
            if (source == null) {
                source = this.attemptToCreateResourceSource(thisComponent);
            }
            if (source == null) {
                source = this.attemptToCreateURLSource(thisComponent);
            }
            if (source == null) {
                source = this.attemptToCreateFileSource(thisComponent);
            }
            if (source == null) {
                throw new ConfigurationSetupException("The location '" + thisComponent + "' is not in any recognized format -- it doesn't " + "seem to be a server, resource, URL, or file.");
            }
            out[i] = source;
        }
        return out;
    }

    private ConfigurationSource attemptToCreateServerSource(String text) {
        Matcher matcher = SERVER_PATTERN.matcher(text);
        if (matcher.matches()) {
            String host = matcher.group(1);
            String portText = matcher.group(2);
            try {
                return new ServerConfigurationSource(host, Integer.parseInt(portText));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private ConfigurationSource attemptToCreateResourceSource(String text) {
        Matcher matcher = RESOURCE_PATTERN.matcher(text);
        if (matcher.matches()) {
            return new ResourceConfigurationSource(matcher.group(1), this.getClass());
        }
        return null;
    }

    private ConfigurationSource attemptToCreateFileSource(String text) {
        return new FileConfigurationSource(text, this.defaultDirectory);
    }

    private ConfigurationSource attemptToCreateURLSource(String text) {
        Matcher matcher = URL_PATTERN.matcher(text);
        if (matcher.matches()) {
            return new URLConfigurationSource(text);
        }
        return null;
    }

    public void createConfigurationIntoRepositories(MutableBeanRepository l1BeanRepository, MutableBeanRepository l2sBeanRepository, MutableBeanRepository systemBeanRepository, MutableBeanRepository tcPropertiesRepository, ApplicationsRepository applicationsRepository) throws ConfigurationSetupException {
        Assert.assertNotNull(l1BeanRepository);
        Assert.assertNotNull(l2sBeanRepository);
        Assert.assertNotNull(systemBeanRepository);
        Assert.assertNotNull(tcPropertiesRepository);
        Assert.assertNotNull(applicationsRepository);
        ConfigurationSource[] sources = this.createConfigurationSources();
        long startTime = System.currentTimeMillis();
        ConfigurationSource[] remainingSources = new ConfigurationSource[sources.length];
        ConfigurationSource loadedSource = null;
        System.arraycopy(sources, 0, remainingSources, 0, sources.length);
        long lastLoopStartTime = 0L;
        int iteration = 0;
        InputStream out = null;
        boolean trustedSource = false;
        String descrip = null;
        while (iteration == 0 || System.currentTimeMillis() - startTime < 300000L) {
            this.sleepIfNecessaryToAvoidPoundingSources(lastLoopStartTime);
            lastLoopStartTime = System.currentTimeMillis();
            for (int i = 0; i < remainingSources.length; ++i) {
                if (remainingSources[i] == null || (out = this.trySource(remainingSources, i)) == null) continue;
                loadedSource = remainingSources[i];
                trustedSource = loadedSource.isTrusted();
                descrip = loadedSource.toString();
                break;
            }
            if (out != null) break;
            ++iteration;
            boolean haveSources = false;
            for (int i = 0; i < remainingSources.length; ++i) {
                haveSources = haveSources || remainingSources[i] != null;
            }
            if (haveSources) continue;
            break;
        }
        if (out == null) {
            this.configurationFetchFailed(sources, startTime);
        }
        this.loadConfigurationData(out, trustedSource, descrip, l1BeanRepository, l2sBeanRepository, systemBeanRepository, tcPropertiesRepository, applicationsRepository);
        consoleLogger.info("Configuration loaded from the " + descrip + ".");
    }

    private void configurationFetchFailed(ConfigurationSource[] sources, long startTime) throws ConfigurationSetupException {
        String text = "Could not fetch configuration data from ";
        text = sources.length > 1 ? text + "" + sources.length + " different configuration sources" : text + "the " + sources[0];
        text = text + ". ";
        if (sources.length > 1) {
            text = text + " The sources we tried are: ";
            for (int i = 0; i < sources.length; ++i) {
                if (i > 0) {
                    text = text + ", ";
                }
                if (i == sources.length - 1) {
                    text = text + "and ";
                }
                text = text + "the " + sources[i].toString();
            }
            text = text + ". ";
        }
        if (System.currentTimeMillis() - startTime >= 300000L) {
            text = text + " Fetch attempt duration: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds.";
        }
        text = text + "\n\nTo correct this problem specify a valid configuration location using the ";
        text = text + "-f/--config command-line options.";
        consoleLogger.error(text);
        throw new ConfigurationSetupException(text);
    }

    private InputStream trySource(ConfigurationSource[] remainingSources, int i) {
        InputStream out = null;
        try {
            this.logger.info("Attempting to load configuration from the " + remainingSources[i] + "...");
            out = remainingSources[i].getInputStream(30000L);
            this.directoryLoadedFrom = remainingSources[i].directoryLoadedFrom();
        }
        catch (ConfigurationSetupException cse) {
            String text = "We couldn't load configuration data from the " + remainingSources[i];
            text = text + "; this error is permanent, so this source will not be retried.";
            if (remainingSources.length > 1) {
                text = text + " Skipping this source and going to the next one.";
            }
            text = text + " (Error: " + cse.getLocalizedMessage() + ".)";
            consoleLogger.warn(text);
            remainingSources[i] = null;
        }
        catch (IOException ioe) {
            String text = "We couldn't load configuration data from the " + remainingSources[i];
            if (remainingSources.length > 1) {
                text = text + "; this error is temporary, so this source will be retried later if configuration can't be loaded elsewhere. ";
                text = text + "Skipping this source and going to the next one.";
            } else {
                text = text + "; retrying.";
            }
            text = text + " (Error: " + ioe.getLocalizedMessage() + ".)";
            consoleLogger.warn(text);
        }
        return out;
    }

    private void sleepIfNecessaryToAvoidPoundingSources(long lastLoopStartTime) {
        long delay = 5000L - (System.currentTimeMillis() - lastLoopStartTime);
        if (delay > 0L) {
            try {
                this.logger.info("Waiting " + delay + " ms until we try to get configuration data again...");
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    private void logCopyOfConfig(InputStream in, String descrip) throws IOException {
        StringWriter sw = new StringWriter();
        CopyUtils.copy((InputStream)in, (Writer)sw);
        this.rawConfigText = sw.toString();
        this.logger.info("Successfully loaded configuration from the " + descrip + ". Config is:\n\n" + this.rawConfigText);
    }

    private void loadConfigurationData(InputStream in, boolean trustedSource, String descrip, MutableBeanRepository clientBeanRepository, MutableBeanRepository serversBeanRepository, MutableBeanRepository systemBeanRepository, MutableBeanRepository tcPropertiesRepository, ApplicationsRepository applicationsRepository) throws ConfigurationSetupException {
        try {
            this.loadedFromTrustedSource = trustedSource;
            this.configDescription = descrip;
            ByteArrayOutputStream dataCopy = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)dataCopy);
            in.close();
            this.logCopyOfConfig(new ByteArrayInputStream(dataCopy.toByteArray()), descrip);
            ByteArrayInputStream copyIn = new ByteArrayInputStream(dataCopy.toByteArray());
            BeanWithErrors beanWithErrors = this.beanFactory.createBean(copyIn, descrip);
            if (beanWithErrors.errors() != null && beanWithErrors.errors().length > 0) {
                this.logger.debug("Configuration didn't parse; it had " + beanWithErrors.errors().length + " error(s).");
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < beanWithErrors.errors().length; ++i) {
                    XmlError error = beanWithErrors.errors()[i];
                    buf.append("  [" + i + "]: Line " + error.getLine() + ", column " + error.getColumn() + ": " + error.getMessage() + "\n");
                    if (error.getMessage().indexOf("spring") <= -1) continue;
                    buf.append("  The Spring configuration in your Terracotta configuration file is not valid. Clustering Spring no longer requires special configuration. For more information, see http://www.terracotta.org/spring.\n");
                }
                throw new ConfigurationSetupException("The configuration data in the " + descrip + " does not obey the " + "Terracotta schema:\n" + buf);
            }
            this.logger.debug("Configuration is valid.");
            TcConfigDocument.TcConfig config = ((TcConfigDocument)beanWithErrors.bean()).getTcConfig();
            Servers servers = config.getServers();
            if (servers == null) {
                servers = Servers.Factory.newInstance();
                Server[] serverArray = new Server[]{Server.Factory.newInstance()};
                servers.setServerArray(serverArray);
                config.setServers(servers);
                servers = config.getServers();
            }
            if (servers != null) {
                for (int i = 0; i < servers.sizeOfServerArray(); ++i) {
                    Server server = servers.getServerArray(i);
                    if (!server.isSetHost() || server.getHost().trim().length() == 0) {
                        if (!server.isSetName()) {
                            server.setHost("%i");
                        } else {
                            server.setHost(server.getName());
                        }
                    }
                    if (!server.isSetName() || server.getName().trim().length() == 0) {
                        FromSchemaDefaultValueProvider defaultValueProvider;
                        int dsoPort = server.getDsoPort();
                        if (dsoPort == 0 && (defaultValueProvider = new FromSchemaDefaultValueProvider()).hasDefault(server.schemaType(), "dso-port")) {
                            XmlInteger defaultValue = (XmlInteger)defaultValueProvider.defaultFor(server.schemaType(), "dso-port");
                            dsoPort = defaultValue.getBigIntegerValue().intValue();
                        }
                        server.setName(server.getHost() + (dsoPort > 0 ? ":" + dsoPort : ""));
                    }
                    if (!server.isSetBind() || server.getBind().trim().length() == 0) {
                        server.setBind(WILDCARD_IP);
                    }
                    server.setHost(ParameterSubstituter.substitute(server.getHost()));
                    server.setName(ParameterSubstituter.substitute(server.getName()));
                    server.setBind(ParameterSubstituter.substitute(server.getBind()));
                }
            }
            clientBeanRepository.setBean((XmlObject)config.getClients(), descrip);
            serversBeanRepository.setBean((XmlObject)config.getServers(), descrip);
            systemBeanRepository.setBean((XmlObject)config.getSystem(), descrip);
            tcPropertiesRepository.setBean((XmlObject)config.getTcProperties(), descrip);
            if (config.isSetApplication()) {
                applicationsRepository.repositoryFor("default").setBean((XmlObject)config.getApplication(), descrip);
            }
        }
        catch (IOException ioe) {
            throw new ConfigurationSetupException("We were unable to read configuration data from the " + descrip + ": " + ioe.getLocalizedMessage(), ioe);
        }
        catch (SAXException saxe) {
            throw new ConfigurationSetupException("The configuration data in the " + descrip + " is not well-formed XML: " + saxe.getLocalizedMessage(), saxe);
        }
        catch (ParserConfigurationException pce) {
            throw Assert.failure("The XML parser can't be configured correctly; this should not happen.", pce);
        }
        catch (XmlException xmle) {
            throw new ConfigurationSetupException("The configuration data in the " + descrip + " does not obey the " + "Terracotta schema: " + xmle.getLocalizedMessage(), xmle);
        }
    }

    public File directoryConfigurationLoadedFrom() {
        return this.directoryLoadedFrom;
    }

    public boolean loadedFromTrustedSource() {
        return this.loadedFromTrustedSource;
    }

    public String rawConfigText() {
        return this.rawConfigText;
    }

    public String describeSources() {
        if (this.configDescription == null) {
            return "The configuration specified by '" + this.configurationSpec + "'";
        }
        return this.configDescription;
    }
}

