/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.IllegalConfigurationChangeHandler;
import com.tc.config.schema.setup.BaseTVSConfigurationSetupManagerFactory;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L1TVSConfigurationSetupManager;
import com.tc.config.schema.setup.L2TVSConfigurationSetupManager;
import com.tc.config.schema.setup.StandardL1TVSConfigurationSetupManager;
import com.tc.config.schema.setup.StandardL2TVSConfigurationSetupManager;
import com.tc.config.schema.setup.StandardXMLFileConfigurationCreator;
import com.tc.logging.TCLogger;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;

public class StandardTVSConfigurationSetupManagerFactory
extends BaseTVSConfigurationSetupManagerFactory {
    private static final String CONFIG_SPEC_ARGUMENT_NAME = "config";
    public static final String CONFIG_SPEC_ARGUMENT_WORD = "--config";
    public static final String SERVER_NAME_ARGUMENT_WORD = "-n";
    private static final String L2_NAME_PROPERTY_NAME = "tc.server.name";
    public static final String DEFAULT_CONFIG_SPEC = "tc-config.xml";
    public static final String DEFAULT_CONFIG_PATH = "default-config.xml";
    public static final String DEFAULT_CONFIG_URI = "resource:///" + StandardTVSConfigurationSetupManagerFactory.class.getPackage().getName().replace('.', '/') + "/" + "default-config.xml";
    private final String defaultL2Identifier;
    private final String configSpec;
    private final File cwd;

    public StandardTVSConfigurationSetupManagerFactory(boolean isForL2, IllegalConfigurationChangeHandler illegalChangeHandler) throws ConfigurationSetupException {
        this((String[])null, isForL2, illegalChangeHandler);
    }

    public StandardTVSConfigurationSetupManagerFactory(String[] args, boolean isForL2, IllegalConfigurationChangeHandler illegalChangeHandler) throws ConfigurationSetupException {
        this(StandardTVSConfigurationSetupManagerFactory.parseDefaultCommandLine(args, isForL2), isForL2, illegalChangeHandler);
    }

    public StandardTVSConfigurationSetupManagerFactory(CommandLine commandLine, boolean isForL2, IllegalConfigurationChangeHandler illegalChangeHandler) throws ConfigurationSetupException {
        this(commandLine, isForL2, illegalChangeHandler, System.getProperty("tc.config"));
    }

    public StandardTVSConfigurationSetupManagerFactory(String[] args, boolean isForL2, IllegalConfigurationChangeHandler illegalChangeHandler, String configSpec) throws ConfigurationSetupException {
        this(StandardTVSConfigurationSetupManagerFactory.parseDefaultCommandLine(args, isForL2), isForL2, illegalChangeHandler, configSpec);
    }

    private static CommandLine parseDefaultCommandLine(String[] args, boolean isForL2) throws ConfigurationSetupException {
        try {
            if (args == null || args.length == 0) {
                return new PosixParser().parse(new Options(), new String[0]);
            }
            Options options = StandardTVSConfigurationSetupManagerFactory.createOptions(isForL2);
            return new PosixParser().parse(options, args);
        }
        catch (ParseException pe) {
            throw new ConfigurationSetupException(pe.getLocalizedMessage(), pe);
        }
    }

    public StandardTVSConfigurationSetupManagerFactory(CommandLine commandLine, boolean isForL2, IllegalConfigurationChangeHandler illegalChangeHandler, String configSpec) throws ConfigurationSetupException {
        super(illegalChangeHandler);
        String configFileOnCommandLine = null;
        String l2NameOnCommandLine = null;
        configFileOnCommandLine = StringUtils.trimToNull((String)commandLine.getOptionValue('f'));
        l2NameOnCommandLine = StringUtils.trimToNull((String)commandLine.getOptionValue('n'));
        String effectiveConfigSpec = StringUtils.trimToNull((String)(configFileOnCommandLine != null ? configFileOnCommandLine : configSpec));
        String specifiedL2Identifier = StringUtils.trimToNull((String)(l2NameOnCommandLine != null ? l2NameOnCommandLine : System.getProperty(L2_NAME_PROPERTY_NAME)));
        if (StringUtils.isBlank((String)effectiveConfigSpec)) {
            File localConfig = new File(System.getProperty("user.dir"), DEFAULT_CONFIG_SPEC);
            if (localConfig.exists()) {
                effectiveConfigSpec = localConfig.getAbsolutePath();
            } else if (isForL2) {
                effectiveConfigSpec = DEFAULT_CONFIG_URI;
            }
        }
        this.configSpec = effectiveConfigSpec;
        if (StringUtils.isBlank((String)this.configSpec)) {
            throw new ConfigurationSetupException("You must specify the location of the Terracotta configuration file for this process, using the 'tc.config' system property.");
        }
        String cwdAsString = System.getProperty("user.dir");
        if (StringUtils.isBlank((String)cwdAsString)) {
            throw new ConfigurationSetupException("We can't find the working directory of the process; we need this to continue. (The system property 'user.dir' was " + (cwdAsString == null ? "null" : "'" + cwdAsString + "'") + ".)");
        }
        this.cwd = new File(cwdAsString);
        this.defaultL2Identifier = specifiedL2Identifier;
    }

    public static Options createOptions(boolean isForL2) {
        Options options = new Options();
        Option configFileOption = new Option("f", CONFIG_SPEC_ARGUMENT_NAME, true, "the configuration file to use, specified as a file path or URL");
        configFileOption.setArgName("file-or-URL");
        configFileOption.setType(String.class);
        if (isForL2) {
            configFileOption.setRequired(false);
            options.addOption(configFileOption);
            Option l2NameOption = new Option("n", "name", true, "the name of this L2; defaults to the host name");
            l2NameOption.setRequired(false);
            l2NameOption.setArgName("l2-name");
            options.addOption(l2NameOption);
        } else {
            configFileOption.setRequired(true);
            options.addOption(configFileOption);
        }
        return options;
    }

    public L1TVSConfigurationSetupManager createL1TVSConfigurationSetupManager(TCLogger logger) throws ConfigurationSetupException {
        StandardXMLFileConfigurationCreator configurationCreator = new StandardXMLFileConfigurationCreator(logger, this.configSpec, this.cwd, this.beanFactory);
        StandardL1TVSConfigurationSetupManager setupManager = new StandardL1TVSConfigurationSetupManager(configurationCreator, this.defaultValueProvider, this.xmlObjectComparator, this.illegalChangeHandler);
        return setupManager;
    }

    public L1TVSConfigurationSetupManager createL1TVSConfigurationSetupManager() throws ConfigurationSetupException {
        StandardXMLFileConfigurationCreator configurationCreator = new StandardXMLFileConfigurationCreator(this.configSpec, this.cwd, this.beanFactory);
        StandardL1TVSConfigurationSetupManager setupManager = new StandardL1TVSConfigurationSetupManager(configurationCreator, this.defaultValueProvider, this.xmlObjectComparator, this.illegalChangeHandler);
        return setupManager;
    }

    public L2TVSConfigurationSetupManager createL2TVSConfigurationSetupManager(String l2Name) throws ConfigurationSetupException {
        if (l2Name == null) {
            l2Name = this.defaultL2Identifier;
        }
        StandardXMLFileConfigurationCreator configurationCreator = new StandardXMLFileConfigurationCreator(this.configSpec, this.cwd, this.beanFactory);
        return new StandardL2TVSConfigurationSetupManager(configurationCreator, l2Name, this.defaultValueProvider, this.xmlObjectComparator, this.illegalChangeHandler);
    }
}

