/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.ActiveServerGroupConfig;
import com.tc.config.schema.ActiveServerGroupsConfig;
import com.tc.config.schema.ActiveServerGroupsConfigObject;
import com.tc.config.schema.ConfigTCProperties;
import com.tc.config.schema.ConfigTCPropertiesFromObject;
import com.tc.config.schema.IllegalConfigurationChangeHandler;
import com.tc.config.schema.NewCommonL2Config;
import com.tc.config.schema.NewCommonL2ConfigObject;
import com.tc.config.schema.NewHaConfig;
import com.tc.config.schema.NewHaConfigObject;
import com.tc.config.schema.NewSystemConfig;
import com.tc.config.schema.NewSystemConfigObject;
import com.tc.config.schema.UpdateCheckConfig;
import com.tc.config.schema.UpdateCheckConfigObject;
import com.tc.config.schema.defaults.DefaultValueProvider;
import com.tc.config.schema.repository.ChildBeanFetcher;
import com.tc.config.schema.repository.ChildBeanRepository;
import com.tc.config.schema.setup.BaseTVSConfigurationSetupManager;
import com.tc.config.schema.setup.ConfigurationCreator;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.L2TVSConfigurationSetupManager;
import com.tc.config.schema.setup.LogSettingConfigItemListener;
import com.tc.config.schema.utils.XmlObjectComparator;
import com.tc.license.Capability;
import com.tc.license.LicenseCheck;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.config.schema.NewL2DSOConfig;
import com.tc.object.config.schema.NewL2DSOConfigObject;
import com.tc.object.config.schema.PersistenceMode;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.terracottatech.config.Application;
import com.terracottatech.config.Client;
import com.terracottatech.config.Ha;
import com.terracottatech.config.MirrorGroups;
import com.terracottatech.config.Server;
import com.terracottatech.config.Servers;
import com.terracottatech.config.System;
import com.terracottatech.config.TcConfigDocument;
import com.terracottatech.config.TcProperties;
import com.terracottatech.config.UpdateCheck;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardL2TVSConfigurationSetupManager
extends BaseTVSConfigurationSetupManager
implements L2TVSConfigurationSetupManager {
    private static final TCLogger logger = TCLogging.getLogger(StandardL2TVSConfigurationSetupManager.class);
    private final ConfigurationCreator configurationCreator;
    private NewSystemConfig systemConfig;
    private final Map l2ConfigData;
    private final NewHaConfig haConfig;
    private final ActiveServerGroupsConfig activeServerGroupsConfig;
    private final UpdateCheckConfig updateCheckConfig;
    private String thisL2Identifier;
    private L2ConfigData myConfigData;
    private final ConfigTCProperties configTCProperties;

    public StandardL2TVSConfigurationSetupManager(ConfigurationCreator configurationCreator, String thisL2Identifier, DefaultValueProvider defaultValueProvider, XmlObjectComparator xmlObjectComparator, IllegalConfigurationChangeHandler illegalConfigChangeHandler) throws ConfigurationSetupException {
        super(defaultValueProvider, xmlObjectComparator, illegalConfigChangeHandler);
        Assert.assertNotNull(configurationCreator);
        Assert.assertNotNull(defaultValueProvider);
        Assert.assertNotNull(xmlObjectComparator);
        this.configurationCreator = configurationCreator;
        this.systemConfig = null;
        this.l2ConfigData = new HashMap();
        this.thisL2Identifier = thisL2Identifier;
        this.myConfigData = null;
        this.runConfigurationCreator(this.configurationCreator);
        this.configTCProperties = new ConfigTCPropertiesFromObject((TcProperties)this.tcPropertiesRepository().bean());
        this.overwriteTcPropertiesFromConfig();
        try {
            this.updateCheckConfig = this.getUpdateCheckConfig();
        }
        catch (XmlException e2) {
            throw new ConfigurationSetupException(e2);
        }
        try {
            this.activeServerGroupsConfig = this.getActiveServerGroupsConfig();
        }
        catch (Exception e) {
            throw new ConfigurationSetupException(e);
        }
        this.selectL2((Servers)this.serversBeanRepository().bean(), "the set of L2s known to us");
        this.haConfig = this.getHaConfig();
        this.validateGroups();
        this.validateDSOClusterPersistenceMode();
        this.validateLicenseCapabilities();
    }

    @Override
    public String getL2Identifier() {
        return this.thisL2Identifier;
    }

    private void verifyPortUsed(Set<String> serverPorts, String hostname, int port) throws ConfigurationSetupException {
        String hostport = hostname + ":" + port;
        if (port != 0 && !serverPorts.add(hostport)) {
            throw new ConfigurationSetupException("The server " + hostport + " is specified more than once in tc-config." + "\nPlease provide different server name or port numbers(dso-port, jmx-port, " + "\nl2-group-port) in tc-config.");
        }
    }

    private void verifyServerPortUsed(Set<String> serverPorts, Server server) throws ConfigurationSetupException {
        String hostname = server.getHost();
        this.verifyPortUsed(serverPorts, hostname, server.getDsoPort());
        this.verifyPortUsed(serverPorts, hostname, server.getJmxPort());
        this.verifyPortUsed(serverPorts, hostname, server.getL2GroupPort());
    }

    private void validateGroups() throws ConfigurationSetupException {
        Server[] serverArray = ((Servers)this.serversBeanRepository().bean()).getServerArray();
        ActiveServerGroupConfig[] groupArray = this.activeServerGroupsConfig.getActiveServerGroupArray();
        HashSet<String> serverPorts = new HashSet<String>();
        this.validateGroupNames(groupArray);
        for (int i = 0; i < serverArray.length; ++i) {
            this.verifyServerPortUsed(serverPorts, serverArray[i]);
            String serverName = serverArray[i].getName();
            boolean found = false;
            int gid = -1;
            for (int j = 0; j < groupArray.length; ++j) {
                if (!groupArray[j].isMember(serverName)) continue;
                if (found) {
                    throw new ConfigurationSetupException("Server{" + serverName + "} is part of more than 1 mirror-group:  groups{" + gid + "," + groupArray[j].getGroupId() + "}");
                }
                gid = groupArray[j].getGroupId().toInt();
                found = true;
            }
            if (found) continue;
            throw new ConfigurationSetupException("Server{" + serverName + "} is not part of any mirror-group.");
        }
    }

    private void validateGroupNames(ActiveServerGroupConfig[] groupArray) throws ConfigurationSetupException {
        HashSet<String> list = new HashSet<String>();
        for (int i = 0; i < groupArray.length; ++i) {
            String grpName = groupArray[i].getGroupName();
            if (grpName == null) continue;
            if (list.contains(grpName)) {
                throw new ConfigurationSetupException("Group Name {" + grpName + "} is part of more than 1 mirror-group groups");
            }
            list.add(grpName);
        }
    }

    private ActiveServerGroupsConfig getActiveServerGroupsConfig() throws ConfigurationSetupException, XmlException {
        final MirrorGroups defaultActiveServerGroups = ActiveServerGroupsConfigObject.getDefaultActiveServerGroups(this.defaultValueProvider, this.serversBeanRepository(), this.getCommomOrDefaultHa().getHa());
        ChildBeanRepository beanRepository = new ChildBeanRepository(this.serversBeanRepository(), MirrorGroups.class, new ChildBeanFetcher(){

            public XmlObject getChild(XmlObject parent) {
                MirrorGroups activeServerGroups = ((Servers)parent).getMirrorGroups();
                if (activeServerGroups == null) {
                    activeServerGroups = defaultActiveServerGroups;
                    ((Servers)parent).setMirrorGroups(activeServerGroups);
                }
                return activeServerGroups;
            }
        });
        return new ActiveServerGroupsConfigObject(this.createContext(beanRepository, this.configurationCreator.directoryConfigurationLoadedFrom()), this);
    }

    private NewHaConfig getHaConfig() {
        ActiveServerGroupConfig groupConfig;
        NewHaConfig newHaConfig = null;
        if (this.activeServerGroupsConfig.getActiveServerGroupCount() != 0 && (groupConfig = this.getActiveServerGroupForThisL2()) != null) {
            newHaConfig = groupConfig.getHa();
        }
        return newHaConfig;
    }

    private UpdateCheckConfig getUpdateCheckConfig() throws XmlException {
        final UpdateCheck defaultUpdateCheck = this.getDefaultUpdateCheck();
        ChildBeanRepository beanRepository = new ChildBeanRepository(this.serversBeanRepository(), UpdateCheck.class, new ChildBeanFetcher(){

            public XmlObject getChild(XmlObject parent) {
                UpdateCheck updateCheck = ((Servers)parent).getUpdateCheck();
                if (updateCheck == null) {
                    updateCheck = defaultUpdateCheck;
                    ((Servers)parent).setUpdateCheck(updateCheck);
                }
                return updateCheck;
            }
        });
        return new UpdateCheckConfigObject(this.createContext(beanRepository, this.configurationCreator.directoryConfigurationLoadedFrom()));
    }

    private UpdateCheck getDefaultUpdateCheck() throws XmlException {
        int defaultPeriodDays = ((XmlInteger)this.defaultValueProvider.defaultFor(this.serversBeanRepository().rootBeanSchemaType(), "update-check/period-days")).getBigIntegerValue().intValue();
        boolean defaultEnabled = ((XmlBoolean)this.defaultValueProvider.defaultFor(this.serversBeanRepository().rootBeanSchemaType(), "update-check/enabled")).getBooleanValue();
        UpdateCheck uc = UpdateCheck.Factory.newInstance();
        uc.setEnabled(defaultEnabled);
        uc.setPeriodDays(defaultPeriodDays);
        return uc;
    }

    public File getConfigFilePath() {
        return this.configurationCreator.directoryConfigurationLoadedFrom();
    }

    public NewHaConfig getCommomOrDefaultHa() throws XmlException {
        NewHaConfigObject newHaConfig = null;
        final Ha defaultHa = NewHaConfigObject.getDefaultCommonHa(this.defaultValueProvider, this.serversBeanRepository());
        ChildBeanRepository beanRepository = new ChildBeanRepository(this.serversBeanRepository(), Ha.class, new ChildBeanFetcher(){

            public XmlObject getChild(XmlObject parent) {
                Ha ha = ((Servers)parent).getHa();
                if (ha == null) {
                    ha = defaultHa;
                }
                return ha;
            }
        });
        newHaConfig = new NewHaConfigObject(this.createContext(beanRepository, this.configurationCreator.directoryConfigurationLoadedFrom()));
        Assert.assertNotNull(newHaConfig);
        return newHaConfig;
    }

    @Override
    public String describeSources() {
        return this.configurationCreator.describeSources();
    }

    private synchronized L2ConfigData configDataFor(String name) throws ConfigurationSetupException {
        L2ConfigData out = (L2ConfigData)this.l2ConfigData.get(name);
        if (out == null) {
            Server[] serverList;
            out = new L2ConfigData(name);
            Servers servers = (Servers)this.serversBeanRepository().bean();
            String list = "[data unavailable]";
            if (servers != null && (serverList = servers.getServerArray()) != null) {
                list = "";
                for (int i = 0; i < serverList.length; ++i) {
                    if (i > 0) {
                        list = list + ", ";
                    }
                    if (i == serverList.length - 1) {
                        list = list + "and ";
                    }
                    list = list + "'" + serverList[i].getName() + "'";
                }
            }
            if (!out.explicitlySpecifiedInConfigFile() && name != null) {
                throw new ConfigurationSetupException("Multiple <server> elements are defined in the configuration file. As such, each server that you start needs to know which configuration it should use.\n\nHowever, this server couldn't figure out which one it is -- it thinks it's called '" + name + "', but you've only created <server> elements in the config file called " + list + ".\n\nPlease re-start the server with a '-n <name>' argument on the command line to tell this " + "server which one it is, or change the 'name' attributes of the <server> " + "elements in the config file as appropriate.");
            }
            this.l2ConfigData.put(name, out);
        }
        return out;
    }

    private void selectL2(Servers servers, String description) throws ConfigurationSetupException {
        this.systemConfig = new NewSystemConfigObject(this.createContext(this.systemBeanRepository(), this.configurationCreator.directoryConfigurationLoadedFrom()));
        if (this.allCurrentlyKnownServers().length == 1) {
            if (servers != null && servers.getServerArray() != null && servers.getServerArray()[0] != null) {
                String server0Name = servers.getServerArray()[0].getName();
                if (this.thisL2Identifier == null) {
                    this.thisL2Identifier = server0Name;
                } else if (!this.thisL2Identifier.equals(server0Name)) {
                    throw new ConfigurationSetupException("You have specified server name '" + this.thisL2Identifier + "' which does not " + "exist in the specified tc-config file. \n\n" + "Please check your settings and try again");
                }
                this.myConfigData = this.configDataFor(server0Name);
            } else {
                this.myConfigData = this.configDataFor(null);
            }
        } else {
            this.myConfigData = this.configDataFor(this.thisL2Identifier);
        }
        LogSettingConfigItemListener listener = new LogSettingConfigItemListener(2);
        this.myConfigData.commonL2Config().logsPath().addListener(listener);
        listener.valueChanged(null, this.myConfigData.commonL2Config().logsPath().getObject());
    }

    private void validateDSOClusterPersistenceMode() throws ConfigurationSetupException {
        ActiveServerGroupConfig[] groupArray = this.activeServerGroupsConfig.getActiveServerGroupArray();
        HashMap<String, Boolean> serversToMode = new HashMap<String, Boolean>();
        for (int i = 0; i < groupArray.length; ++i) {
            boolean isNwAP = groupArray[i].getHa().isNetworkedActivePassive();
            String[] members = groupArray[i].getMembers().getMemberArray();
            for (int j = 0; j < members.length; ++j) {
                serversToMode.put(members[j], isNwAP);
            }
        }
        if (super.serversBeanRepository().bean() != null) {
            Server[] servers = ((Servers)super.serversBeanRepository().bean()).getServerArray();
            HashSet<String> badServers = new HashSet<String>();
            if (servers != null && servers.length > 1) {
                for (int i = 0; i < servers.length; ++i) {
                    String name = servers[i].getName();
                    L2ConfigData data = this.configDataFor(name);
                    Assert.assertNotNull(data);
                    boolean isNwAP = (Boolean)serversToMode.get(name);
                    if (isNwAP || data.dsoL2Config().persistenceMode().getObject().equals(PersistenceMode.PERMANENT_STORE)) continue;
                    badServers.add(name);
                }
            }
            if (badServers.size() > 0) {
                throw new ConfigurationSetupException("At least one server defined in the Terracotta configuration file is in \n'" + PersistenceMode.TEMPORARY_SWAP_ONLY + "' persistence mode. (Servers in this mode: \n" + badServers + ".) \n\n" + "If even one server has persistence mode set to  " + PersistenceMode.TEMPORARY_SWAP_ONLY + ", \nthen High Availability mode must be set to 'networked-active-passive'" + "\n\nFor servers in a mirror group, High Availability mode can be set per" + "\nmirror group. A mirror-group High Availability setting overrides the main" + "\nHigh Availability for that mirror group.\n\n" + "See the Terracotta documentation for more details.");
            }
        }
    }

    public void validateLicenseCapabilities() {
        if (this.activeServerGroupsConfig.getActiveServerGroupCount() > 1) {
            LicenseCheck.checkCapability(Capability.SERVER_STRIPING);
        }
    }

    @Override
    public NewCommonL2Config commonL2ConfigFor(String name) throws ConfigurationSetupException {
        return this.configDataFor(name).commonL2Config();
    }

    @Override
    public NewCommonL2Config commonl2Config() {
        return this.myConfigData.commonL2Config();
    }

    @Override
    public NewSystemConfig systemConfig() {
        return this.systemConfig;
    }

    @Override
    public NewL2DSOConfig dsoL2ConfigFor(String name) throws ConfigurationSetupException {
        return this.configDataFor(name).dsoL2Config();
    }

    @Override
    public NewL2DSOConfig dsoL2Config() {
        return this.myConfigData.dsoL2Config();
    }

    @Override
    public NewHaConfig haConfig() {
        return this.haConfig;
    }

    @Override
    public UpdateCheckConfig updateCheckConfig() {
        return this.updateCheckConfig;
    }

    @Override
    public ActiveServerGroupsConfig activeServerGroupsConfig() {
        return this.activeServerGroupsConfig;
    }

    @Override
    public String[] allCurrentlyKnownServers() {
        Server[] l2s;
        Servers serversBean = (Servers)this.serversBeanRepository().bean();
        Server[] serverArray = l2s = serversBean == null ? null : serversBean.getServerArray();
        if (l2s == null || l2s.length == 0) {
            return new String[]{null};
        }
        String[] out = new String[l2s.length];
        for (int i = 0; i < l2s.length; ++i) {
            out[i] = l2s[i].getName();
        }
        return out;
    }

    @Override
    public InputStream rawConfigFile() {
        String text = this.configurationCreator.rawConfigText();
        try {
            return new ByteArrayInputStream(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw Assert.failure("This shouldn't be possible", uee);
        }
    }

    @Override
    public InputStream effectiveConfigFile() {
        TcConfigDocument doc = TcConfigDocument.Factory.newInstance();
        TcConfigDocument.TcConfig config = doc.addNewTcConfig();
        TcProperties tcProperties = (TcProperties)this.tcPropertiesRepository().bean();
        System system = (System)this.systemBeanRepository().bean();
        Client client = (Client)this.clientBeanRepository().bean();
        Servers servers = (Servers)this.serversBeanRepository().bean();
        Application application = (Application)this.applicationsRepository().repositoryFor("default").bean();
        if (system != null) {
            config.setSystem(system);
        }
        if (client != null) {
            config.setClients(client);
        }
        if (servers != null) {
            config.setServers(servers);
        }
        if (tcProperties != null) {
            config.setTcProperties(tcProperties);
        }
        if (application != null) {
            config.setApplication(application);
        }
        StringWriter sw = new StringWriter();
        XmlOptions options = new XmlOptions().setSavePrettyPrint().setSavePrettyPrintIndent(4);
        try {
            doc.save((Writer)sw, options);
        }
        catch (IOException ioe) {
            throw Assert.failure("Unexpected failure writing to in-memory streams", ioe);
        }
        String text = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n\n" + sw.toString();
        try {
            return new ByteArrayInputStream(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw Assert.failure("This shouldn't be possible", uee);
        }
    }

    private void overwriteTcPropertiesFromConfig() {
        TCProperties tcProps = TCPropertiesImpl.getProperties();
        tcProps.overwriteTcPropertiesFromConfig(this.configTCProperties.getTcPropertiesArray());
    }

    @Override
    public ActiveServerGroupConfig getActiveServerGroupForThisL2() {
        return this.activeServerGroupsConfig.getActiveServerGroupForL2(this.thisL2Identifier);
    }

    private class L2ConfigData {
        private final String name;
        private final ChildBeanRepository beanRepository;
        private final NewCommonL2Config commonL2Config;
        private final NewL2DSOConfig dsoL2Config;

        public L2ConfigData(String name) throws ConfigurationSetupException {
            this.name = name;
            this.findMyL2Bean();
            this.beanRepository = new ChildBeanRepository(StandardL2TVSConfigurationSetupManager.this.serversBeanRepository(), Server.class, new BeanFetcher());
            this.commonL2Config = new NewCommonL2ConfigObject(StandardL2TVSConfigurationSetupManager.this.createContext(this.beanRepository, StandardL2TVSConfigurationSetupManager.this.configurationCreator.directoryConfigurationLoadedFrom()));
            this.dsoL2Config = new NewL2DSOConfigObject(StandardL2TVSConfigurationSetupManager.this.createContext(this.beanRepository, StandardL2TVSConfigurationSetupManager.this.configurationCreator.directoryConfigurationLoadedFrom()));
        }

        public NewCommonL2Config commonL2Config() {
            return this.commonL2Config;
        }

        public NewL2DSOConfig dsoL2Config() {
            return this.dsoL2Config;
        }

        public boolean explicitlySpecifiedInConfigFile() throws ConfigurationSetupException {
            return this.findMyL2Bean() != null;
        }

        private Server findMyL2Bean() throws ConfigurationSetupException {
            Server[] l2Array;
            Servers servers = (Servers)StandardL2TVSConfigurationSetupManager.this.serversBeanRepository().bean();
            Server[] serverArray = l2Array = servers == null ? null : servers.getServerArray();
            if (l2Array == null || l2Array.length == 0) {
                return null;
            }
            if (this.name == null) {
                if (l2Array.length > 1) {
                    throw new ConfigurationSetupException("You have not specified a name for your L2, and there are " + l2Array.length + " L2s defined in the configuration file. " + "You must indicate which L2 this is.");
                }
                return l2Array[0];
            }
            for (int i = 0; i < l2Array.length; ++i) {
                if (!this.name.trim().equalsIgnoreCase(l2Array[i].getName().trim())) continue;
                return l2Array[i];
            }
            return null;
        }

        private class BeanFetcher
        implements ChildBeanFetcher {
            private BeanFetcher() {
            }

            public XmlObject getChild(XmlObject parent) {
                try {
                    return L2ConfigData.this.findMyL2Bean();
                }
                catch (ConfigurationSetupException cse) {
                    logger.warn("Unable to find L2 bean for L2 '" + L2ConfigData.this.name + "'", cse);
                    return null;
                }
            }
        }
    }
}

