/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.IllegalConfigurationChangeHandler;
import com.tc.config.schema.dynamic.ConfigItem;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import org.apache.commons.lang.ArrayUtils;

public class FatalIllegalConfigurationChangeHandler
implements IllegalConfigurationChangeHandler {
    private static TCLogger logger;

    private TCLogger getLogger() {
        if (logger == null) {
            logger = TCLogging.getLogger(FatalIllegalConfigurationChangeHandler.class);
        }
        return logger;
    }

    public void changeFailed(ConfigItem item, Object oldValue, Object newValue) {
        String text = "Error: Terracotta is using an inconsistent configuration.\n\nThe configuration that this client is using is different from the one used by\nthe connected production server.\n\nSpecific information: " + item + " has changed.\n" + "   Old value: " + this.describe(oldValue) + "\n" + "   New value: " + this.describe(newValue) + "\n";
        System.err.println(text);
        this.getLogger().fatal(text);
        System.exit(3);
    }

    private String describe(Object o) {
        if (o == null) {
            return "<null>";
        }
        if (o.getClass().isArray()) {
            return ArrayUtils.toString((Object)o);
        }
        return o.toString();
    }
}

