/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.setup;

import com.tc.config.schema.IllegalConfigurationChangeHandler;
import com.tc.config.schema.context.ConfigContext;
import com.tc.config.schema.context.StandardConfigContext;
import com.tc.config.schema.defaults.DefaultValueProvider;
import com.tc.config.schema.repository.ApplicationsRepository;
import com.tc.config.schema.repository.BeanRepository;
import com.tc.config.schema.repository.ChildBeanFetcher;
import com.tc.config.schema.repository.ChildBeanRepository;
import com.tc.config.schema.repository.MutableBeanRepository;
import com.tc.config.schema.repository.StandardApplicationsRepository;
import com.tc.config.schema.repository.StandardBeanRepository;
import com.tc.config.schema.setup.ConfigurationCreator;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.utils.XmlObjectComparator;
import com.tc.object.config.schema.NewDSOApplicationConfig;
import com.tc.object.config.schema.NewDSOApplicationConfigObject;
import com.tc.util.Assert;
import com.terracottatech.config.Application;
import com.terracottatech.config.Client;
import com.terracottatech.config.DsoApplication;
import com.terracottatech.config.Servers;
import com.terracottatech.config.System;
import com.terracottatech.config.TcProperties;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;

public class BaseTVSConfigurationSetupManager {
    private final MutableBeanRepository clientBeanRepository;
    private final MutableBeanRepository serversBeanRepository;
    private final MutableBeanRepository systemBeanRepository;
    private final MutableBeanRepository tcPropertiesRepository;
    private final ApplicationsRepository applicationsRepository;
    protected final DefaultValueProvider defaultValueProvider;
    private final XmlObjectComparator xmlObjectComparator;
    private final IllegalConfigurationChangeHandler illegalConfigurationChangeHandler;
    private final Map dsoApplicationConfigs;
    private final Map springApplicationConfigs;

    public BaseTVSConfigurationSetupManager(DefaultValueProvider defaultValueProvider, XmlObjectComparator xmlObjectComparator, IllegalConfigurationChangeHandler illegalConfigurationChangeHandler) {
        Assert.assertNotNull(defaultValueProvider);
        Assert.assertNotNull(xmlObjectComparator);
        Assert.assertNotNull(illegalConfigurationChangeHandler);
        this.systemBeanRepository = new StandardBeanRepository(System.class);
        this.clientBeanRepository = new StandardBeanRepository(Client.class);
        this.serversBeanRepository = new StandardBeanRepository(Servers.class);
        this.tcPropertiesRepository = new StandardBeanRepository(TcProperties.class);
        this.applicationsRepository = new StandardApplicationsRepository();
        this.defaultValueProvider = defaultValueProvider;
        this.xmlObjectComparator = xmlObjectComparator;
        this.illegalConfigurationChangeHandler = illegalConfigurationChangeHandler;
        this.dsoApplicationConfigs = new HashMap();
        this.springApplicationConfigs = new HashMap();
    }

    protected final MutableBeanRepository clientBeanRepository() {
        return this.clientBeanRepository;
    }

    public final MutableBeanRepository serversBeanRepository() {
        return this.serversBeanRepository;
    }

    protected final MutableBeanRepository systemBeanRepository() {
        return this.systemBeanRepository;
    }

    protected final MutableBeanRepository tcPropertiesRepository() {
        return this.tcPropertiesRepository;
    }

    protected final ApplicationsRepository applicationsRepository() {
        return this.applicationsRepository;
    }

    protected final XmlObjectComparator xmlObjectComparator() {
        return this.xmlObjectComparator;
    }

    protected final void runConfigurationCreator(ConfigurationCreator configurationCreator) throws ConfigurationSetupException {
        configurationCreator.createConfigurationIntoRepositories(this.clientBeanRepository, this.serversBeanRepository, this.systemBeanRepository, this.tcPropertiesRepository, this.applicationsRepository);
    }

    public String[] applicationNames() {
        HashSet names = new HashSet();
        names.addAll(this.dsoApplicationConfigs.keySet());
        names.addAll(this.springApplicationConfigs.keySet());
        return names.toArray(new String[names.size()]);
    }

    public final ConfigContext createContext(BeanRepository beanRepository, File configFilePath) {
        Assert.assertNotNull(beanRepository);
        return new StandardConfigContext(beanRepository, this.defaultValueProvider, this.illegalConfigurationChangeHandler, configFilePath);
    }

    public synchronized NewDSOApplicationConfig dsoApplicationConfigFor(String applicationName) {
        Assert.eval(applicationName.equals("default"));
        NewDSOApplicationConfig out = (NewDSOApplicationConfig)this.dsoApplicationConfigs.get(applicationName);
        if (out == null) {
            out = this.createNewDSOApplicationConfig(applicationName);
            this.dsoApplicationConfigs.put(applicationName, out);
        }
        return out;
    }

    protected NewDSOApplicationConfig createNewDSOApplicationConfig(String applicationName) {
        return new NewDSOApplicationConfigObject(this.createContext(new ChildBeanRepository(this.applicationsRepository.repositoryFor(applicationName), DsoApplication.class, new ChildBeanFetcher(){

            public XmlObject getChild(XmlObject parent) {
                return ((Application)parent).getDso();
            }
        }), null));
    }
}

