/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.repository;

import com.tc.config.schema.repository.ApplicationsRepository;
import com.tc.config.schema.repository.MutableBeanRepository;
import com.tc.config.schema.repository.StandardBeanRepository;
import com.tc.config.schema.validate.ConfigurationValidator;
import com.tc.util.Assert;
import com.terracottatech.config.Application;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StandardApplicationsRepository
implements ApplicationsRepository {
    private final Map applications = new HashMap();
    private final Set configurationValidators = new HashSet();

    public void addRepositoryValidator(ConfigurationValidator validator) {
        Assert.assertNotNull(validator);
        this.configurationValidators.add(validator);
    }

    public synchronized MutableBeanRepository repositoryFor(String applicationName) {
        Assert.assertNotBlank(applicationName);
        MutableBeanRepository out = (MutableBeanRepository)this.applications.get(applicationName);
        if (out == null) {
            out = new StandardBeanRepository(Application.class);
            Iterator iter = this.configurationValidators.iterator();
            while (iter.hasNext()) {
                out.addValidator((ConfigurationValidator)iter.next());
            }
            this.applications.put(applicationName, out);
        }
        return out;
    }

    public synchronized Iterator applicationNames() {
        List<String> names = Arrays.asList(this.applications.keySet().toArray(new String[this.applications.size()]));
        return names.iterator();
    }
}

