/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.dynamic;

import com.tc.config.schema.context.ConfigContext;
import com.tc.config.schema.dynamic.CompoundConfigItemListener;
import com.tc.config.schema.dynamic.ConfigItem;
import com.tc.config.schema.dynamic.ConfigItemListener;
import com.tc.config.schema.listen.ConfigurationChangeListener;
import com.tc.util.Assert;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public abstract class XPathBasedConfigItem
implements ConfigItem,
ConfigurationChangeListener {
    private final ConfigContext context;
    private final String xpath;
    private Object defaultValue;
    private boolean defaultInitialized;
    private final CompoundConfigItemListener listener;
    private boolean haveCurrentValue;
    private Object currentValue;

    public XPathBasedConfigItem(ConfigContext context, String xpath) {
        Assert.assertNotNull(context);
        Assert.assertNotBlank(xpath);
        this.context = context;
        this.xpath = xpath;
        this.defaultInitialized = false;
        this.listener = new CompoundConfigItemListener();
        this.haveCurrentValue = false;
        this.currentValue = null;
        this.context.itemCreated(this);
    }

    private synchronized void initializeDefaultIfNecessary() {
        if (!this.defaultInitialized) {
            try {
                this.defaultValue = this.context.hasDefaultFor(this.xpath) ? this.fetchDataFromXmlObject(this.context.defaultFor(this.xpath)) : null;
                this.defaultInitialized = true;
            }
            catch (XmlException xmle) {
                throw Assert.failure("Couldn't use XPath '" + this.xpath + "' to fetch a default value", xmle);
            }
        }
    }

    public XPathBasedConfigItem(ConfigContext context, String xpath, Object defaultValue) {
        Assert.assertNotNull(context);
        Assert.assertNotBlank(xpath);
        this.context = context;
        this.xpath = xpath;
        this.defaultValue = defaultValue;
        this.defaultInitialized = true;
        this.listener = new CompoundConfigItemListener();
        this.haveCurrentValue = false;
        this.currentValue = null;
        this.context.itemCreated(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObject() {
        if (!this.haveCurrentValue) {
            Object object = this.context.syncLockForBean();
            synchronized (object) {
                this.currentValue = this.fetchDataFromTopLevelBean(this.context.bean());
                this.haveCurrentValue = true;
            }
        }
        return this.currentValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fetchDataFromTopLevelBean(XmlObject bean) {
        Object out = null;
        this.initializeDefaultIfNecessary();
        if (bean != null) {
            XmlObject[] targetList;
            XmlObject xmlObject = bean;
            synchronized (xmlObject) {
                targetList = bean.selectPath(this.xpath);
            }
            if (targetList == null || targetList.length == 0 || targetList.length == 1 && targetList[0] == null) {
                out = this.fetchDataFromXmlObject(null);
            } else if (targetList.length == 1) {
                out = this.fetchDataFromXmlObject(targetList[0]);
            } else {
                throw Assert.failure("From " + bean + ", XPath '" + this.xpath + "' selected " + targetList.length + " nodes, not " + "just 1. This should never happen; there is a bug in the software.");
            }
        }
        if (out == null) {
            out = this.defaultValue;
        }
        return out;
    }

    protected abstract Object fetchDataFromXmlObject(XmlObject var1);

    protected final Object fetchDataFromXmlObjectByReflection(XmlObject xmlObject, String methodName) {
        if (xmlObject == null) {
            return null;
        }
        Method method = this.getMethodWithNoParametersByName(xmlObject.getClass(), methodName);
        if (method == null) {
            throw Assert.failure("There is no method named '" + methodName + "' on object " + xmlObject + " (of class " + xmlObject.getClass().getName() + ") with no parameters.");
        }
        try {
            return method.invoke((Object)xmlObject, new Object[0]);
        }
        catch (IllegalArgumentException iae) {
            throw Assert.failure("Unable to invoke method " + method + ".", iae);
        }
        catch (IllegalAccessException iae) {
            throw Assert.failure("Unable to invoke method " + method + ".", iae);
        }
        catch (InvocationTargetException ite) {
            throw Assert.failure("Unable to invoke method " + method + ".", ite);
        }
    }

    protected final Method getMethodWithNoParametersByName(Class theClass, String methodName) {
        Method[] allMethods = theClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            if (!allMethods[i].getName().equals(methodName) || allMethods[i].getParameterTypes().length != 0) continue;
            return allMethods[i];
        }
        return null;
    }

    public synchronized void addListener(ConfigItemListener changeListener) {
        Assert.assertNotNull(changeListener);
        this.listener.addListener(changeListener);
    }

    public synchronized void removeListener(ConfigItemListener changeListener) {
        Assert.assertNotNull(changeListener);
        this.listener.removeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void configurationChanged(XmlObject oldConfig, XmlObject newConfig) {
        Object newValue;
        Object oldValue;
        Object object = this.context.syncLockForBean();
        synchronized (object) {
            oldValue = this.haveCurrentValue ? this.currentValue : this.fetchDataFromTopLevelBean(oldConfig);
            this.currentValue = newValue = this.fetchDataFromTopLevelBean(newConfig);
            this.haveCurrentValue = true;
        }
        if (oldValue == null != (newValue == null) || oldValue != null && !oldValue.equals(newValue)) {
            this.listener.valueChanged(oldValue, newValue);
        }
    }

    public String toString() {
        return "configuration item at XPath '" + this.xpath + "'";
    }

    public ConfigContext context() {
        return this.context;
    }

    public String xpath() {
        return this.xpath;
    }

    public Object defaultValue() {
        this.initializeDefaultIfNecessary();
        return this.defaultValue;
    }
}

