/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.dynamic;

import com.tc.config.schema.context.ConfigContext;
import com.tc.config.schema.dynamic.StringArrayConfigItem;
import com.tc.config.schema.dynamic.XPathBasedConfigItem;
import com.tc.util.Assert;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.xmlbeans.XmlObject;

public class StringArrayXPathBasedConfigItem
extends XPathBasedConfigItem
implements StringArrayConfigItem {
    public StringArrayXPathBasedConfigItem(ConfigContext context, String xpath) {
        super(context, xpath);
    }

    protected Object fetchDataFromXmlObject(XmlObject xmlObject) {
        if (xmlObject == null) {
            return null;
        }
        Method targetMethod = null;
        Method[] allMethods = xmlObject.getClass().getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Method candidate = allMethods[i];
            if (!candidate.getReturnType().equals(String[].class) || candidate.getParameterTypes().length != 0 || !Modifier.isPublic(candidate.getModifiers()) || !candidate.getName().startsWith("get") || !candidate.getName().endsWith("Array")) continue;
            if (targetMethod != null) {
                throw Assert.failure("Whoa! There are multiple public methods that start with 'get', end with 'Array', take no parameters, and return String[] on class " + xmlObject.getClass().getName() + ". One is " + targetMethod + ", and another is " + candidate + ". We should fix " + "the program to account for this.");
            }
            targetMethod = candidate;
        }
        if (targetMethod == null) {
            throw Assert.failure("Class " + xmlObject.getClass().getName() + " has no public methods that start with 'get', " + "end with 'Array', take no parameters, and return String[].");
        }
        try {
            return targetMethod.invoke((Object)xmlObject, new Object[0]);
        }
        catch (IllegalArgumentException iae) {
            throw Assert.failure("Couldn't invoke method " + targetMethod + " on object " + xmlObject + ": ", iae);
        }
        catch (IllegalAccessException iae) {
            throw Assert.failure("Couldn't invoke method " + targetMethod + " on object " + xmlObject + ": ", iae);
        }
        catch (InvocationTargetException ite) {
            throw Assert.failure("Couldn't invoke method " + targetMethod + " on object " + xmlObject + ": ", ite);
        }
    }

    public String[] getStringArray() {
        return (String[])this.getObject();
    }
}

