/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.dynamic;

import com.tc.config.schema.dynamic.CompoundConfigItemListener;
import com.tc.config.schema.dynamic.ConfigItem;
import com.tc.config.schema.dynamic.ConfigItemListener;
import com.tc.util.Assert;
import com.tc.util.stringification.OurStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class DerivedConfigItem
implements ConfigItem,
ConfigItemListener {
    private final ConfigItem[] derivedFrom;
    private final CompoundConfigItemListener listener;
    private Object currentValue;

    public DerivedConfigItem(ConfigItem[] derivedFrom) {
        Assert.assertNoNullElements(derivedFrom);
        this.derivedFrom = derivedFrom;
        for (int i = 0; i < derivedFrom.length; ++i) {
            derivedFrom[i].addListener(this);
        }
        this.listener = new CompoundConfigItemListener();
        this.currentValue = this.createValueFrom(this.derivedFrom);
    }

    public Object getObject() {
        return this.currentValue;
    }

    protected abstract Object createValueFrom(ConfigItem[] var1);

    public void addListener(ConfigItemListener changeListener) {
        this.listener.addListener(changeListener);
    }

    public void removeListener(ConfigItemListener changeListener) {
        this.listener.removeListener(changeListener);
    }

    public void valueChanged(Object oldValue, Object newValue) {
        Object ourOldValue = this.currentValue;
        this.currentValue = this.createValueFrom(this.derivedFrom);
        if (ourOldValue == null != (this.currentValue == null) || ourOldValue != null && !ourOldValue.equals(this.currentValue)) {
            this.listener.valueChanged(ourOldValue, this.currentValue);
        }
    }

    public String toString() {
        return new OurStringBuilder(this, (ToStringStyle)OurStringBuilder.COMPACT_STYLE).append("derived from", this.derivedFrom).toString();
    }
}

