/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema.defaults;

import com.tc.config.schema.defaults.DefaultValueProvider;
import com.tc.util.Assert;
import java.util.regex.Pattern;
import org.apache.xmlbeans.SchemaLocalAttribute;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class FromSchemaDefaultValueProvider
implements DefaultValueProvider {
    private static final Pattern ALLOWED_COMPONENT_PATTERN = Pattern.compile("@?[A-Za-z0-9][A-Za-z0-9-]*");

    public boolean isOptional(SchemaType baseType, String xpath) throws XmlException {
        return this.fetchParticle(baseType, xpath).isOptional();
    }

    public boolean possibleForXPathToHaveDefault(String xpath) {
        return this.isInterpretableXPath(xpath);
    }

    public XmlObject defaultFor(SchemaType baseType, String xpath) throws XmlException {
        XmlObject out = this.fetchDefault(baseType, xpath);
        if (out == null) {
            throw new XmlException("The element at XPath '" + xpath + "' has no default specified.");
        }
        return out;
    }

    public boolean hasDefault(SchemaType baseType, String xpath) throws XmlException {
        return this.fetchDefault(baseType, xpath) != null;
    }

    private XmlObject fetchDefault(SchemaType baseType, String xpath) throws XmlException {
        SchemaInfo info = this.fetchParticle(baseType, xpath);
        if (!info.isDefault()) {
            return null;
        }
        return info.defaultValue();
    }

    private SchemaInfo fetchParticle(SchemaType baseType, String xpath) throws XmlException {
        Assert.assertNotNull(baseType);
        Assert.assertNotBlank(xpath);
        if (!this.isInterpretableXPath(xpath)) {
            throw new XmlException("Right now, our default-finding code doesn't support anything other than a path consisting of only simple elements. '" + xpath + "' is not such a path.");
        }
        String[] components = xpath.split("/");
        SchemaParticle currentParticle = baseType.getContentModel();
        Assert.assertNotNull(currentParticle);
        boolean anyAreOptional = false;
        if (components.length == 1 && components[0].startsWith("@")) {
            return new SchemaInfo(false, currentParticle.getMinOccurs().intValue() == 0, null);
        }
        for (int i = 0; i < components.length; ++i) {
            String component = components[i];
            if (currentParticle.getMinOccurs().intValue() == 0) {
                anyAreOptional = true;
            }
            int particleType = currentParticle.getParticleType();
            if (component.startsWith("@")) {
                throw new XmlException("Component '" + component + "' of XPath '" + xpath + "' specifies an attribute in an invalid position.");
            }
            if (i == components.length - 2 && components[i + 1].startsWith("@")) {
                String attributeName = components[i + 1].substring(1);
                if (currentParticle.getType() == null || currentParticle.getType().getAttributeModel() == null) {
                    throw new XmlException("The element purportedly containing attribute '" + attributeName + "' in XPath '" + xpath + "' seems to have no attributes at all.");
                }
                SchemaLocalAttribute[] attributes = currentParticle.getType().getAttributeModel().getAttributes();
                for (int j = 0; j < attributes.length; ++j) {
                    if (!attributes[j].getName().getLocalPart().equals(attributeName)) continue;
                    return new SchemaInfo(attributes[j].isDefault(), attributes[j].getMinOccurs().intValue() == 0, (XmlObject)attributes[j].getDefaultValue());
                }
                throw new XmlException("Attribute '" + attributeName + "' of element '" + component + "' in XPath '" + xpath + "' was not found.");
            }
            if (particleType == 4) {
                if (currentParticle.getName().getLocalPart().equals(component)) {
                    if (i == components.length - 1) break;
                    currentParticle = currentParticle.getType().getContentModel();
                    Assert.assertNotNull(currentParticle);
                    continue;
                }
                throw new XmlException("Component '" + component + "' of XPath '" + xpath + "' not found; we have one element only, '" + currentParticle.getName().getLocalPart() + "'.");
            }
            this.checkParticleType(component, particleType, xpath);
            SchemaParticle[] children = currentParticle.getParticleChildren();
            if (children == null) {
                throw new XmlException("Component '" + component + "' of XPath '" + xpath + "' seems to have " + "no children. Stop.");
            }
            ElementReturn elementReturn = this.findNextElement(xpath, component, children, i == components.length - 1);
            SchemaParticle next = elementReturn.particle();
            boolean bl = anyAreOptional = anyAreOptional || elementReturn.isOptional();
            if (next == null) {
                throw new XmlException("Component '" + component + "' of XPath '" + xpath + "' was not found. Please check the path " + "and try again.");
            }
            currentParticle = next;
        }
        if (currentParticle.getMinOccurs().intValue() == 0) {
            anyAreOptional = true;
        }
        if (currentParticle.getParticleType() != 4) {
            throw new XmlException("XPath '" + xpath + "' points to a complex type or other item, not a single element. Stop.");
        }
        if (currentParticle.isDefault() && !anyAreOptional) {
            throw new XmlException("XPath '" + xpath + "' has a default, but is not optional. This doesn't make sense.");
        }
        return new SchemaInfo(currentParticle.isDefault(), anyAreOptional, (XmlObject)currentParticle.getDefaultValue());
    }

    private ElementReturn findNextElement(String xpath, String component, SchemaParticle[] children, boolean lastOne) throws XmlException {
        SchemaParticle next = null;
        StringBuffer actualChildren = new StringBuffer();
        boolean optional = false;
        for (int childIndex = 0; childIndex < children.length; ++childIndex) {
            String thisChildName = children[childIndex].getName().getLocalPart();
            if (childIndex > 0) {
                actualChildren.append(", ");
            }
            actualChildren.append(thisChildName);
            if (thisChildName == null || !thisChildName.equals(component)) continue;
            if (next != null) {
                throw new XmlException("Component '" + component + "' of XPath '" + xpath + "' has multiple children named '" + component + "'. We don't support this. Stop.");
            }
            next = children[childIndex];
        }
        if (!lastOne && next.getParticleType() == 4) {
            optional = optional || next.getMinOccurs().intValue() == 0;
            next = next.getType().getContentModel();
        }
        if (next == null) {
            throw new XmlException("Component '" + component + "' of path '" + xpath + "' was not found. Instead, we found: " + actualChildren);
        }
        optional = optional || next.getMinOccurs().intValue() == 0;
        return new ElementReturn(next, optional);
    }

    private void checkParticleType(String component, int particleType, String xpath) throws XmlException {
        if (particleType != 1 && particleType != 2 && particleType != 3) {
            throw new XmlException("Component '" + component + "' of XPath '" + xpath + "' is a schema particle of type " + particleType + ", not " + 1 + " ('all'), " + 2 + " ('choice'), or " + 3 + " ('sequence'). Stop.");
        }
    }

    private boolean isInterpretableXPath(String xpath) {
        String[] components = xpath.split("/");
        for (int i = 0; i < components.length; ++i) {
            if (ALLOWED_COMPONENT_PATTERN.matcher(components[i]).matches()) continue;
            return false;
        }
        return true;
    }

    private static class ElementReturn {
        private final SchemaParticle particle;
        private final boolean isOptional;

        public ElementReturn(SchemaParticle particle, boolean isOptional) {
            Assert.assertNotNull(particle);
            this.particle = particle;
            this.isOptional = isOptional;
        }

        public SchemaParticle particle() {
            return this.particle;
        }

        public boolean isOptional() {
            return this.isOptional;
        }
    }

    private static class SchemaInfo {
        private final boolean isDefault;
        private final boolean isOptional;
        private final XmlObject defaultValue;

        public SchemaInfo(boolean isDefault, boolean isOptional, XmlObject defaultValue) {
            Assert.eval(defaultValue == null || isDefault);
            Assert.eval(defaultValue == null || isOptional);
            this.isDefault = isDefault;
            this.isOptional = isOptional;
            this.defaultValue = defaultValue;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public XmlObject defaultValue() {
            return this.defaultValue;
        }
    }
}

