/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.config.schema.BaseNewConfigObject;
import com.tc.config.schema.NewHaConfig;
import com.tc.config.schema.context.ConfigContext;
import com.tc.config.schema.defaults.DefaultValueProvider;
import com.tc.config.schema.repository.MutableBeanRepository;
import com.terracottatech.config.Ha;
import com.terracottatech.config.HaMode;
import com.terracottatech.config.NetworkedActivePassive;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlString;

public class NewHaConfigObject
extends BaseNewConfigObject
implements NewHaConfig {
    private final String haMode;
    private final int electionTime;
    private final Ha ha;

    public NewHaConfigObject(ConfigContext context) {
        super(context);
        context.ensureRepositoryProvides(Ha.class);
        this.ha = (Ha)context.bean();
        this.haMode = this.ha.getMode().toString();
        this.checkHaModeSet(this.haMode);
        this.electionTime = context.intItem("networked-active-passive/election-time").getInt();
    }

    private void checkHaModeSet(String mode) {
        if (mode == null) {
            throw new AssertionError((Object)"no default set for ha mode");
        }
    }

    public String haMode() {
        return this.haMode;
    }

    public int electionTime() {
        return this.electionTime;
    }

    public boolean isNetworkedActivePassive() {
        return this.haMode.equals(HaMode.NETWORKED_ACTIVE_PASSIVE.toString());
    }

    public Ha getHa() {
        return this.ha;
    }

    public static Ha getDefaultCommonHa(DefaultValueProvider defaultValueProvider, MutableBeanRepository serversBeanRepository) throws XmlException {
        int defaultElectionTime = ((XmlInteger)defaultValueProvider.defaultFor(serversBeanRepository.rootBeanSchemaType(), "ha/networked-active-passive/election-time")).getBigIntegerValue().intValue();
        String defaultHaModeString = ((XmlString)defaultValueProvider.defaultFor(serversBeanRepository.rootBeanSchemaType(), "ha/mode")).getStringValue();
        HaMode.Enum defaultHaMode = HaMode.DISK_BASED_ACTIVE_PASSIVE.toString().equals(defaultHaModeString) ? HaMode.DISK_BASED_ACTIVE_PASSIVE : HaMode.NETWORKED_ACTIVE_PASSIVE;
        Ha ha = Ha.Factory.newInstance();
        ha.setMode(defaultHaMode);
        NetworkedActivePassive nap = NetworkedActivePassive.Factory.newInstance();
        nap.setElectionTime(defaultElectionTime);
        ha.setNetworkedActivePassive(nap);
        return ha;
    }
}

