/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.config.schema.BaseNewConfigObject;
import com.tc.config.schema.NewCommonL2Config;
import com.tc.config.schema.context.ConfigContext;
import com.tc.config.schema.dynamic.FileConfigItem;
import com.tc.config.schema.dynamic.IntConfigItem;
import com.tc.config.schema.dynamic.ParameterSubstituter;
import com.tc.config.schema.dynamic.StringConfigItem;
import com.terracottatech.config.Authentication;
import com.terracottatech.config.HttpAuthentication;
import com.terracottatech.config.Server;
import java.io.File;
import javax.xml.namespace.QName;

public class NewCommonL2ConfigObject
extends BaseNewConfigObject
implements NewCommonL2Config {
    private final FileConfigItem dataPath;
    private final FileConfigItem logsPath;
    private final FileConfigItem serverDbBackupPath;
    private final FileConfigItem statisticsPath;
    private final IntConfigItem jmxPort;
    private final StringConfigItem host;
    private final boolean authentication;
    private final String passwordFile;
    private final String accessFile;
    private final boolean httpAuthentication;
    private final String userRealmFile;

    public NewCommonL2ConfigObject(ConfigContext context) {
        super(context);
        this.context.ensureRepositoryProvides(Server.class);
        this.dataPath = context.configRelativeSubstitutedFileItem("data");
        this.logsPath = context.configRelativeSubstitutedFileItem("logs");
        this.serverDbBackupPath = context.configRelativeSubstitutedFileItem("data-backup");
        this.statisticsPath = context.configRelativeSubstitutedFileItem("statistics");
        this.jmxPort = context.intItem("jmx-port");
        this.host = context.stringItem("@host");
        String pwd = null;
        String access = null;
        Server server = (Server)context.bean();
        this.authentication = server != null ? server.isSetAuthentication() : false;
        if (this.authentication) {
            pwd = server.getAuthentication().getPasswordFile();
            if (pwd == null) {
                pwd = Authentication.type.getElementProperty(QName.valueOf("password-file")).getDefaultText();
            }
            pwd = new File(ParameterSubstituter.substitute(pwd)).getAbsolutePath();
            access = server.getAuthentication().getAccessFile();
            if (access == null) {
                access = Authentication.type.getElementProperty(QName.valueOf("access-file")).getDefaultText();
            }
            access = new File(ParameterSubstituter.substitute(access)).getAbsolutePath();
        }
        this.passwordFile = pwd;
        this.accessFile = access;
        String userRealm = null;
        this.httpAuthentication = server != null ? server.isSetHttpAuthentication() : false;
        if (this.httpAuthentication) {
            userRealm = server.getHttpAuthentication().getUserRealmFile();
            if (null == userRealm) {
                userRealm = HttpAuthentication.type.getElementProperty(QName.valueOf("user-realm-file")).getDefaultText();
            }
            userRealm = new File(ParameterSubstituter.substitute(userRealm)).getAbsolutePath();
        }
        this.userRealmFile = userRealm;
    }

    public FileConfigItem dataPath() {
        return this.dataPath;
    }

    public FileConfigItem logsPath() {
        return this.logsPath;
    }

    public FileConfigItem statisticsPath() {
        return this.statisticsPath;
    }

    public FileConfigItem serverDbBackupPath() {
        return this.serverDbBackupPath;
    }

    public IntConfigItem jmxPort() {
        return this.jmxPort;
    }

    public StringConfigItem host() {
        return this.host;
    }

    public boolean authentication() {
        return this.authentication;
    }

    public String authenticationAccessFile() {
        return this.accessFile;
    }

    public String authenticationPasswordFile() {
        return this.passwordFile;
    }

    public boolean httpAuthentication() {
        return this.httpAuthentication;
    }

    public String httpAuthenticationUserRealmFile() {
        return this.userRealmFile;
    }
}

