/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.util.Assert;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class L2Info
implements Serializable {
    static final long serialVersionUID = 7607194631717518924L;
    public static final String IMPLICIT_L2_NAME = "localhost";
    private final String name;
    private final String host;
    private InetAddress hostAddress;
    private final int jmxPort;
    private Integer hashCode;

    public L2Info(String name, String host, int jmxPort) {
        Assert.assertNotBlank(host);
        Assert.eval(jmxPort >= 0);
        this.name = name;
        this.host = host;
        this.jmxPort = jmxPort;
        this.safeGetHostAddress();
    }

    public L2Info(L2Info other) {
        this(other.name(), other.host(), other.jmxPort());
    }

    public String name() {
        return this.name;
    }

    public String host() {
        return this.host;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.hostAddress != null) {
            return this.hostAddress;
        }
        this.hostAddress = IMPLICIT_L2_NAME.equals(this.host) || "127.0.0.1".equals(this.host) ? InetAddress.getLocalHost() : InetAddress.getByName(this.host);
        return this.hostAddress;
    }

    public String getCanonicalHostName() throws UnknownHostException {
        return this.getInetAddress().getCanonicalHostName();
    }

    public String safeGetCanonicalHostName() {
        try {
            return this.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            return null;
        }
    }

    public String getHostAddress() throws UnknownHostException {
        return this.getInetAddress().getHostAddress();
    }

    public String safeGetHostAddress() {
        try {
            return this.getInetAddress().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            return null;
        }
    }

    public int jmxPort() {
        return this.jmxPort;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            HashCodeBuilder builder = new HashCodeBuilder();
            if (this.name != null) {
                builder.append((Object)this.name);
            }
            builder.append(this.jmxPort);
            builder.append((Object)this.host);
            this.hashCode = new Integer(builder.toHashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof L2Info)) {
            return false;
        }
        L2Info other = (L2Info)object;
        return StringUtils.equals((String)this.name(), (String)other.name()) && this.jmxPort() == other.jmxPort() && StringUtils.equals((String)this.host(), (String)other.host());
    }

    public boolean matches(L2Info other) {
        if (!StringUtils.equals((String)this.name(), (String)other.name())) {
            return false;
        }
        if (this.jmxPort() != other.jmxPort()) {
            return false;
        }
        String hostname = this.safeGetCanonicalHostName();
        String otherHostname = other.safeGetCanonicalHostName();
        if (hostname != null || otherHostname != null) {
            return StringUtils.equals((String)hostname, (String)otherHostname);
        }
        return StringUtils.equals((String)this.host(), (String)other.host());
    }
}

