/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.config.schema.L2ConfigForL1;
import com.tc.config.schema.context.ConfigContext;
import com.tc.config.schema.dynamic.ObjectArrayConfigItem;
import com.tc.config.schema.dynamic.ObjectArrayXPathBasedConfigItem;
import com.tc.util.ActiveCoordinatorHelper;
import com.tc.util.Assert;
import com.terracottatech.config.MirrorGroup;
import com.terracottatech.config.MirrorGroups;
import com.terracottatech.config.Server;
import com.terracottatech.config.Servers;
import com.terracottatech.config.System;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;

public class L2ConfigForL1Object
implements L2ConfigForL1 {
    private static final String DEFAULT_HOST = "localhost";
    private final ConfigContext l2sContext;
    private final ConfigContext systemContext;
    private final ObjectArrayConfigItem l2Data;
    private final L2ConfigForL1.L2Data defaultL2Data;
    private final Map l2DataByName;
    private final Map l2DataByGroupId;
    private ObjectArrayConfigItem[] l2DataByGroup;

    public L2ConfigForL1Object(ConfigContext l2sContext, ConfigContext systemContext) {
        this(l2sContext, systemContext, null);
    }

    public L2ConfigForL1Object(ConfigContext l2sContext, ConfigContext systemContext, int[] dsoPorts) {
        Assert.assertNotNull(l2sContext);
        Assert.assertNotNull(systemContext);
        this.l2sContext = l2sContext;
        this.systemContext = systemContext;
        this.l2sContext.ensureRepositoryProvides(Servers.class);
        this.systemContext.ensureRepositoryProvides(System.class);
        this.l2DataByName = new HashMap();
        this.l2DataByGroupId = new LinkedHashMap();
        this.defaultL2Data = new L2ConfigForL1.L2Data(DEFAULT_HOST, this.getL2IntDefault("server/dso-port"));
        this.l2Data = new ObjectArrayXPathBasedConfigItem(this.l2sContext, ".", new L2ConfigForL1.L2Data[]{this.defaultL2Data}){

            protected Object fetchDataFromXmlObject(XmlObject xmlObject) {
                L2ConfigForL1.L2Data[] data;
                Server[] l2Array = ((Servers)xmlObject).getServerArray();
                if (l2Array == null || l2Array.length == 0) {
                    data = new L2ConfigForL1.L2Data[]{L2ConfigForL1Object.this.defaultL2Data};
                } else {
                    data = new L2ConfigForL1.L2Data[l2Array.length];
                    for (int i = 0; i < data.length; ++i) {
                        int dsoPort;
                        Server l2 = l2Array[i];
                        String host = l2.getHost();
                        String name = l2.getName();
                        if (host == null) {
                            host = L2ConfigForL1Object.this.defaultL2Data.host();
                        }
                        int n = dsoPort = l2.getDsoPort() > 0 ? l2.getDsoPort() : L2ConfigForL1Object.this.defaultL2Data.dsoPort();
                        if (name == null) {
                            name = host + ":" + dsoPort;
                        }
                        data[i] = new L2ConfigForL1.L2Data(host, dsoPort);
                        L2ConfigForL1Object.this.l2DataByName.put(name, data[i]);
                    }
                }
                this.organizeByGroup(xmlObject);
                return data;
            }

            private void organizeByGroup(XmlObject xmlObject) {
                int i;
                String[] members;
                MirrorGroup[] asgArray;
                MirrorGroups asgs = ((Servers)xmlObject).getMirrorGroups();
                if (asgs == null) {
                    asgs = ((Servers)xmlObject).addNewMirrorGroups();
                }
                if ((asgArray = asgs.getMirrorGroupArray()) == null || asgArray.length == 0) {
                    MirrorGroup group = asgs.addNewMirrorGroup();
                    members = group.addNewMembers();
                    for (String host : L2ConfigForL1Object.this.l2DataByName.keySet()) {
                        members.addMember(host);
                    }
                    asgArray = asgs.getMirrorGroupArray();
                }
                Assert.assertNotNull(asgArray);
                Assert.assertTrue(asgArray.length >= 1);
                for (i = 0; i < asgArray.length; ++i) {
                    String groupName = asgArray[i].getGroupName();
                    if (groupName != null) continue;
                    groupName = ActiveCoordinatorHelper.getGroupNameFrom(asgArray[i].getMembers().getMemberArray());
                    asgArray[i].setGroupName(groupName);
                }
                Arrays.sort(asgArray, new MirrorGroupNameComparator());
                for (i = 0; i < asgArray.length; ++i) {
                    members = asgArray[i].getMembers().getMemberArray();
                    ArrayList<L2ConfigForL1.L2Data> groupList = (ArrayList<L2ConfigForL1.L2Data>)L2ConfigForL1Object.this.l2DataByGroupId.get(new Integer(i));
                    if (groupList == null) {
                        groupList = new ArrayList<L2ConfigForL1.L2Data>();
                        L2ConfigForL1Object.this.l2DataByGroupId.put(new Integer(i), groupList);
                    }
                    for (String member : members) {
                        L2ConfigForL1.L2Data data = (L2ConfigForL1.L2Data)L2ConfigForL1Object.this.l2DataByName.get(member);
                        if (data == null) {
                            throw new RuntimeException("The member \"" + member + "\" is not persent in the server section. Please verify the configuration.");
                        }
                        Assert.assertNotNull(data);
                        data.setGroupId(i);
                        String groupName = asgArray[i].getGroupName();
                        data.setGroupName(groupName);
                        groupList.add(data);
                    }
                }
            }
        };
    }

    private int getL2IntDefault(String xpath) {
        try {
            return ((XmlInteger)this.l2sContext.defaultFor(xpath)).getBigIntegerValue().intValue();
        }
        catch (XmlException xmle) {
            throw Assert.failure("Can't fetch default for " + xpath + "?", xmle);
        }
    }

    public ObjectArrayConfigItem l2Data() {
        return this.l2Data;
    }

    public synchronized ObjectArrayConfigItem[] getL2DataByGroup() {
        if (this.l2DataByGroup == null) {
            this.createL2DataByGroup();
        }
        Assert.assertNoNullElements(this.l2DataByGroup);
        return this.l2DataByGroup;
    }

    private void createL2DataByGroup() {
        Set keys = this.l2DataByGroupId.keySet();
        Assert.assertTrue(keys.size() > 0);
        this.l2DataByGroup = new ObjectArrayConfigItem[keys.size()];
        int l2DataByGroupPosition = 0;
        for (Integer key : keys) {
            List l2DataList = (List)this.l2DataByGroupId.get(key);
            L2ConfigForL1.L2Data[] l2DataArray = new L2ConfigForL1.L2Data[l2DataList.size()];
            int position = 0;
            for (L2ConfigForL1.L2Data data : l2DataList) {
                l2DataArray[position++] = data;
            }
            this.setL2DataInGrp(l2DataByGroupPosition, l2DataArray);
            ++l2DataByGroupPosition;
        }
    }

    private void setL2DataInGrp(int l2DataByGroupPosition, final L2ConfigForL1.L2Data[] l2DataArray) {
        this.l2DataByGroup[l2DataByGroupPosition] = new ObjectArrayXPathBasedConfigItem(this.l2sContext, ".", new L2ConfigForL1.L2Data[]{this.defaultL2Data}){

            protected Object fetchDataFromXmlObject(XmlObject xmlObject) {
                return l2DataArray;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MirrorGroupNameComparator
    implements Comparator<MirrorGroup> {
        @Override
        public int compare(MirrorGroup obj1, MirrorGroup obj2) {
            return obj1.getGroupName().compareTo(obj2.getGroupName());
        }
    }
}

