/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.config.schema.dynamic.ObjectArrayConfigItem;
import com.tc.util.Assert;
import com.tc.util.stringification.OurStringBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public interface L2ConfigForL1 {
    public ObjectArrayConfigItem l2Data();

    public ObjectArrayConfigItem[] getL2DataByGroup();

    public static class L2Data {
        private final String host;
        private final int dsoPort;
        private int groupId = -1;
        private String groupName;

        public L2Data(String host, int dsoPort) {
            Assert.assertNotBlank(host);
            this.host = host;
            this.dsoPort = dsoPort;
        }

        public String host() {
            return this.host;
        }

        public int dsoPort() {
            return this.dsoPort;
        }

        public void setGroupId(int gid) {
            Assert.assertTrue(gid >= 0);
            this.groupId = gid;
        }

        public int getGroupId() {
            Assert.assertTrue(this.groupId > -1);
            return this.groupId;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public boolean equals(Object that) {
            if (!(that instanceof L2Data)) {
                return false;
            }
            L2Data thatData = (L2Data)that;
            return new EqualsBuilder().append((Object)this.host, (Object)thatData.host).append(this.dsoPort, thatData.dsoPort).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.host).append(this.dsoPort).toHashCode();
        }

        public String toString() {
            return new OurStringBuilder(this).append("host", this.host).append("DSO port", this.dsoPort).toString();
        }
    }
}

