/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.config.schema.IllegalConfigurationChangeHandler;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.FatalIllegalConfigurationChangeHandler;
import com.tc.config.schema.setup.L2TVSConfigurationSetupManager;
import com.tc.config.schema.setup.StandardTVSConfigurationSetupManagerFactory;

public class ConfigFileValidator {
    private String description;

    public void validate(String[] args) throws ConfigurationSetupException {
        StandardTVSConfigurationSetupManagerFactory factory = new StandardTVSConfigurationSetupManagerFactory(args, true, (IllegalConfigurationChangeHandler)new FatalIllegalConfigurationChangeHandler());
        L2TVSConfigurationSetupManager manager = factory.createL2TVSConfigurationSetupManager(null);
        this.description = manager.describeSources();
    }

    public String toString() {
        return this.description;
    }

    public static void main(String[] args) {
        ConfigFileValidator validator = new ConfigFileValidator();
        try {
            validator.validate(args);
            System.err.println(validator.toString() + ": VALID.");
            System.exit(0);
        }
        catch (ConfigurationSetupException cse) {
            System.err.println(validator.toString() + ": INVALID.");
            for (Throwable exception = cse; exception != null; exception = exception.getCause()) {
                System.err.println(exception.getLocalizedMessage());
            }
            System.exit(1);
        }
    }
}

