/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.config.schema.NewConfig;
import com.tc.config.schema.context.ConfigContext;
import com.tc.config.schema.dynamic.ConfigItem;
import com.tc.config.schema.dynamic.ConfigItemListener;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.util.Assert;
import java.lang.reflect.Array;
import org.apache.commons.lang.ClassUtils;
import org.apache.xmlbeans.XmlObject;

public class BaseNewConfigObject
implements NewConfig {
    private static final TCLogger logger = TCLogging.getLogger(BaseNewConfigObject.class);
    protected final ConfigContext context;

    public BaseNewConfigObject(ConfigContext context) {
        Assert.assertNotNull(context);
        this.context = context;
    }

    public void changesInItemIgnored(ConfigItem item) {
        Assert.assertNotNull(item);
        item.addListener(new IgnoringConfigItemListener(item));
    }

    public void changesInItemForbidden(ConfigItem item) {
        Assert.assertNotNull(item);
        item.addListener(new ForbiddenConfigItemListener(item));
    }

    public String toString() {
        return ClassUtils.getShortClassName(this.getClass()) + " around bean:\n" + this.context.bean();
    }

    public XmlObject getBean() {
        return this.context.bean();
    }

    private class ForbiddenConfigItemListener
    implements ConfigItemListener {
        private final ConfigItem item;

        public ForbiddenConfigItemListener(ConfigItem item) {
            Assert.assertNotNull(item);
            this.item = item;
        }

        private boolean isEqual(Object one, Object two) {
            if (one != null && two != null && one.getClass().isArray() && two.getClass().isArray() && one.getClass().getComponentType().equals(two.getClass().getComponentType())) {
                if (Array.getLength(one) != Array.getLength(two)) {
                    return false;
                }
                for (int i = 0; i < Array.getLength(one); ++i) {
                    if (this.isEqual(Array.get(one, i), Array.get(two, i))) continue;
                    return false;
                }
                return true;
            }
            if (one != null && two != null) {
                return one.equals(two);
            }
            return one == two;
        }

        public void valueChanged(Object oldValue, Object newValue) {
            if (oldValue == null) {
                return;
            }
            if (newValue != null && this.isEqual(oldValue, newValue)) {
                return;
            }
            BaseNewConfigObject.this.context.illegalConfigurationChangeHandler().changeFailed(this.item, oldValue, newValue);
        }
    }

    private static class IgnoringConfigItemListener
    implements ConfigItemListener {
        private final ConfigItem item;

        public IgnoringConfigItemListener(ConfigItem item) {
            Assert.assertNotNull(item);
            this.item = item;
        }

        public void valueChanged(Object oldValue, Object newValue) {
            logger.warn("The attempt to change the value of " + this.item + " from " + oldValue + " to " + newValue + " was ignored; runtime changes in this configuration value are not yet supported.");
        }
    }
}

