/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.config.schema.ActiveServerGroupConfig;
import com.tc.config.schema.ActiveServerGroupConfigObject;
import com.tc.config.schema.ActiveServerGroupsConfig;
import com.tc.config.schema.BaseNewConfigObject;
import com.tc.config.schema.context.ConfigContext;
import com.tc.config.schema.defaults.DefaultValueProvider;
import com.tc.config.schema.repository.ChildBeanFetcher;
import com.tc.config.schema.repository.ChildBeanRepository;
import com.tc.config.schema.repository.MutableBeanRepository;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.StandardL2TVSConfigurationSetupManager;
import com.tc.net.GroupID;
import com.terracottatech.config.Ha;
import com.terracottatech.config.MirrorGroup;
import com.terracottatech.config.MirrorGroups;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class ActiveServerGroupsConfigObject
extends BaseNewConfigObject
implements ActiveServerGroupsConfig {
    private final ActiveServerGroupConfig[] groupConfigArray;
    private final int activeServerGroupCount;

    public ActiveServerGroupsConfigObject(ConfigContext context, StandardL2TVSConfigurationSetupManager setupManager) throws XmlException {
        super(context);
        int i;
        context.ensureRepositoryProvides(MirrorGroups.class);
        MirrorGroups groups = (MirrorGroups)context.bean();
        if (groups == null) {
            throw new AssertionError((Object)"ActiveServerGroups is null!  This should never happen since we make sure default is used.");
        }
        MirrorGroup[] groupArray = groups.getMirrorGroupArray();
        if (groupArray == null || groupArray.length == 0) {
            throw new AssertionError((Object)"ActiveServerGroup array is null!  This should never happen since we make sure default is used.");
        }
        this.activeServerGroupCount = groupArray.length;
        ActiveServerGroupConfigObject[] tempGroupConfigArray = new ActiveServerGroupConfigObject[groupArray.length];
        for (i = 0; i < groupArray.length; ++i) {
            if (!groupArray[i].isSetHa()) {
                groupArray[i].setHa(setupManager.getCommomOrDefaultHa().getHa());
            }
            tempGroupConfigArray[i] = new ActiveServerGroupConfigObject(this.createContext(setupManager, groupArray[i]), setupManager);
        }
        Arrays.sort(tempGroupConfigArray, new ActiveGroupNameComparator());
        for (i = 0; i < tempGroupConfigArray.length; ++i) {
            tempGroupConfigArray[i].setGroupId(new GroupID(i));
        }
        this.groupConfigArray = tempGroupConfigArray;
    }

    public int getActiveServerGroupCount() {
        return this.activeServerGroupCount;
    }

    public ActiveServerGroupConfig[] getActiveServerGroupArray() {
        return this.groupConfigArray;
    }

    private final ConfigContext createContext(StandardL2TVSConfigurationSetupManager setupManager, final MirrorGroup group) {
        ChildBeanRepository beanRepository = new ChildBeanRepository(setupManager.serversBeanRepository(), MirrorGroup.class, new ChildBeanFetcher(){

            public XmlObject getChild(XmlObject parent) {
                return group;
            }
        });
        return setupManager.createContext(beanRepository, setupManager.getConfigFilePath());
    }

    public static MirrorGroups getDefaultActiveServerGroups(DefaultValueProvider defaultValueProvider, MutableBeanRepository serversBeanRepository, Ha commonHa) throws ConfigurationSetupException {
        MirrorGroups asgs = MirrorGroups.Factory.newInstance();
        MirrorGroup[] groupArray = new MirrorGroup[]{ActiveServerGroupConfigObject.getDefaultActiveServerGroup(defaultValueProvider, serversBeanRepository, commonHa)};
        asgs.setMirrorGroupArray(groupArray);
        return asgs;
    }

    public ActiveServerGroupConfig getActiveServerGroupForL2(String name) {
        for (int groupCount = 0; groupCount < this.activeServerGroupCount; ++groupCount) {
            if (!this.groupConfigArray[groupCount].isMember(name)) continue;
            return this.groupConfigArray[groupCount];
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActiveGroupNameComparator
    implements Comparator<ActiveServerGroupConfig> {
        @Override
        public int compare(ActiveServerGroupConfig obj1, ActiveServerGroupConfig obj2) {
            return obj1.getGroupName().compareTo(obj2.getGroupName());
        }
    }
}

