/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.config.schema.ActiveServerGroupConfig;
import com.tc.config.schema.BaseNewConfigObject;
import com.tc.config.schema.MembersConfig;
import com.tc.config.schema.MembersConfigObject;
import com.tc.config.schema.NewHaConfig;
import com.tc.config.schema.NewHaConfigObject;
import com.tc.config.schema.context.ConfigContext;
import com.tc.config.schema.defaults.DefaultValueProvider;
import com.tc.config.schema.repository.ChildBeanFetcher;
import com.tc.config.schema.repository.ChildBeanRepository;
import com.tc.config.schema.repository.MutableBeanRepository;
import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.config.schema.setup.StandardL2TVSConfigurationSetupManager;
import com.tc.net.GroupID;
import com.tc.util.ActiveCoordinatorHelper;
import com.terracottatech.config.Ha;
import com.terracottatech.config.Members;
import com.terracottatech.config.MirrorGroup;
import com.terracottatech.config.Server;
import com.terracottatech.config.Servers;
import org.apache.xmlbeans.XmlObject;

public class ActiveServerGroupConfigObject
extends BaseNewConfigObject
implements ActiveServerGroupConfig {
    public static final int defaultGroupId = 0;
    private GroupID groupId;
    private final NewHaConfig haConfig;
    private final MembersConfig membersConfig;
    private final String grpName;

    public ActiveServerGroupConfigObject(ConfigContext context, StandardL2TVSConfigurationSetupManager setupManager) {
        super(context);
        context.ensureRepositoryProvides(MirrorGroup.class);
        MirrorGroup group = (MirrorGroup)context.bean();
        String groupName = group.getGroupName();
        if (groupName == null) {
            groupName = ActiveCoordinatorHelper.getGroupNameFrom(group.getMembers().getMemberArray());
        }
        this.grpName = groupName;
        this.membersConfig = new MembersConfigObject(this.createContext(setupManager, true, group));
        this.haConfig = new NewHaConfigObject(this.createContext(setupManager, false, group));
    }

    public void setGroupId(GroupID groupId) {
        this.groupId = groupId;
    }

    public NewHaConfig getHa() {
        return this.haConfig;
    }

    public String getGroupName() {
        return this.grpName;
    }

    public MembersConfig getMembers() {
        return this.membersConfig;
    }

    public GroupID getGroupId() {
        return this.groupId;
    }

    private final ConfigContext createContext(StandardL2TVSConfigurationSetupManager setupManager, boolean isMembers, final MirrorGroup group) {
        if (isMembers) {
            ChildBeanRepository beanRepository = new ChildBeanRepository(setupManager.serversBeanRepository(), Members.class, new ChildBeanFetcher(){

                public XmlObject getChild(XmlObject parent) {
                    return group.getMembers();
                }
            });
            return setupManager.createContext(beanRepository, setupManager.getConfigFilePath());
        }
        ChildBeanRepository beanRepository = new ChildBeanRepository(setupManager.serversBeanRepository(), Ha.class, new ChildBeanFetcher(){

            public XmlObject getChild(XmlObject parent) {
                return group.getHa();
            }
        });
        return setupManager.createContext(beanRepository, setupManager.getConfigFilePath());
    }

    public static MirrorGroup getDefaultActiveServerGroup(DefaultValueProvider defaultValueProvider, MutableBeanRepository serversBeanRepository, Ha commonHa) throws ConfigurationSetupException {
        MirrorGroup asg = MirrorGroup.Factory.newInstance();
        asg.setHa(commonHa);
        Members members = asg.addNewMembers();
        Server[] serverArray = ((Servers)serversBeanRepository.bean()).getServerArray();
        for (int i = 0; i < serverArray.length; ++i) {
            String name = serverArray[i].getName();
            if (name == null || name.equals("")) {
                throw new ConfigurationSetupException("server's name not defined... name=[" + name + "] serverDsoPort=[" + serverArray[i].getDsoPort() + "]");
            }
            members.insertMember(i, serverArray[i].getName());
        }
        return asg;
    }

    public boolean isMember(String l2Name) {
        String[] members = this.getMembers().getMemberArray();
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].equals(l2Name)) continue;
            return true;
        }
        return false;
    }
}

