/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config;

import com.terracottatech.config.TcConfigDocument;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public final class Loader {
    private TcConfigDocument convert(InputStream in, XmlOptions xmlOptions) throws IOException, XmlException {
        byte[] data = new byte[in.available()];
        in.read(data);
        in.close();
        ByteArrayInputStream ain = new ByteArrayInputStream(data);
        SchemaType type = TcConfigDocument.type;
        if (xmlOptions == null) {
            xmlOptions = new XmlOptions();
        }
        xmlOptions.setDocumentType(type);
        return TcConfigDocument.Factory.parse((InputStream)ain, (XmlOptions)xmlOptions);
    }

    public TcConfigDocument parse(File file) throws IOException, XmlException {
        return this.convert(new FileInputStream(file), null);
    }

    public TcConfigDocument parse(File file, XmlOptions xmlOptions) throws IOException, XmlException {
        return this.convert(new FileInputStream(file), xmlOptions);
    }

    public TcConfigDocument parse(String xmlText) throws IOException, XmlException {
        return this.convert(new ByteArrayInputStream(xmlText.getBytes()), null);
    }

    public TcConfigDocument parse(String xmlText, XmlOptions xmlOptions) throws IOException, XmlException {
        return this.convert(new ByteArrayInputStream(xmlText.getBytes()), xmlOptions);
    }

    public TcConfigDocument parse(InputStream stream) throws IOException, XmlException {
        return this.convert(stream, null);
    }

    public TcConfigDocument parse(InputStream stream, XmlOptions xmlOptions) throws IOException, XmlException {
        return this.convert(stream, xmlOptions);
    }

    public TcConfigDocument parse(URL url) throws IOException, XmlException {
        return this.convert(url.openStream(), null);
    }

    public TcConfigDocument parse(URL url, XmlOptions xmlOptions) throws IOException, XmlException {
        return this.convert(url.openStream(), xmlOptions);
    }
}

