/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.commons.lang.StringUtils;

public class Directories {
    public static final String TC_INSTALL_ROOT_PROPERTY_NAME = "tc.install-root";
    public static final String TC_INSTALL_ROOT_IGNORE_CHECKS_PROPERTY_NAME = "tc.install-root.ignore-checks";

    public static File getInstallationRoot() throws FileNotFoundException {
        boolean ignoreCheck = Boolean.getBoolean(TC_INSTALL_ROOT_IGNORE_CHECKS_PROPERTY_NAME);
        if (ignoreCheck) {
            String baseDir = System.getProperty("tc.base-dir");
            return new File(baseDir != null ? baseDir : ".", "../../../code/base");
        }
        String path = System.getProperty(TC_INSTALL_ROOT_PROPERTY_NAME);
        if (StringUtils.isBlank((String)path)) {
            throw new FileNotFoundException("The system property 'tc.install-root' has not been set. As such, the Terracotta installation directory cannot be located.");
        }
        File rootPath = new File(path).getAbsoluteFile();
        if (!rootPath.isDirectory()) {
            throw new FileNotFoundException("The specified Terracotta installation directory, '" + rootPath + "', located via the value of the system property '" + TC_INSTALL_ROOT_PROPERTY_NAME + "', does not actually exist.");
        }
        return rootPath;
    }

    public static boolean tcInstallRootDefined() {
        String path = System.getProperty(TC_INSTALL_ROOT_PROPERTY_NAME);
        return !StringUtils.isBlank((String)path);
    }
}

