/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles.exception;

import com.tc.bundles.ResolverUtils;
import com.tc.bundles.exception.BundleExceptionSummary;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.BundleException;

public class MissingDefaultRepositoryException
extends BundleException
implements BundleExceptionSummary {
    private File repository;

    public MissingDefaultRepositoryException(String msg) {
        super(msg);
    }

    public MissingDefaultRepositoryException(String msg, File repository) {
        super(msg);
        this.repository = repository;
    }

    public String getSummary() {
        StringBuffer buf = new StringBuffer(this.getMessage()).append("\n\n").append("   ");
        buf.append("You should set the value of the com.tc.l1.modules.repositories system property to declare a valid default TIM repository.");
        if (this.repository != null) {
            buf.append("\n").append("   ");
            buf.append("Or, make sure that the following path resolves to a directory:\n\n").append("      ");
            buf.append(ResolverUtils.canonicalize(this.repository)).append("\n\n").append("   ");
        }
        return StringUtils.replace((String)buf.toString(), (String)"\n", (String)System.getProperty("line.separator"));
    }
}

